@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.layout.widget

import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.ui.Margin
import app.cash.redwood.widget.Widget
import kotlin.Any
import kotlin.OptIn
import kotlin.Suppress
import kotlin.experimental.ExperimentalObjCName
import kotlin.native.ObjCName

/**
 * {tag=4}
 */
@OptIn(ExperimentalObjCName::class)
@ObjCName(
  "Box",
  exact = true,
)
public interface Box<W : Any> : Widget<W> {
  /**
   * {tag=1}
   */
  public val children: Widget.Children<W>

  /**
   * {tag=1}
   */
  public fun width(width: Constraint)

  /**
   * {tag=2}
   */
  public fun height(height: Constraint)

  /**
   * {tag=3}
   */
  public fun margin(margin: Margin)

  /**
   * {tag=4}
   */
  public fun horizontalAlignment(horizontalAlignment: CrossAxisAlignment)

  /**
   * {tag=5}
   */
  public fun verticalAlignment(verticalAlignment: CrossAxisAlignment)
}
