@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.layout.widget

import app.cash.redwood.Modifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.widget.Widget
import app.cash.redwood.widget.WidgetFactoryOwner
import app.cash.redwood.widget.WidgetSystem
import kotlin.Any
import kotlin.OptIn
import kotlin.Suppress
import kotlin.collections.List
import kotlin.experimental.ExperimentalObjCName
import kotlin.native.ObjCName

@OptIn(
  ExperimentalObjCName::class,
  RedwoodCodegenApi::class,
)
@ObjCName(
  "RedwoodLayoutWidgetSystem",
  exact = true,
)
public class RedwoodLayoutWidgetSystem<W : Any>(
  override val RedwoodLayout: RedwoodLayoutWidgetFactory<W>,
) : WidgetSystem<W>,
    RedwoodLayoutWidgetFactoryOwner<W> {
  override fun apply(`value`: W, element: Modifier.UnscopedElement) {
    RedwoodLayoutWidgetFactoryOwner.apply(RedwoodLayout, value, element)
  }

  public companion object {
    public fun <W : Any> allChildren(widget: Widget<W>): List<Widget<W>> = when (widget) {
      is Box<*> -> {
        widget as Box<W>
        widget.children.widgets
      }
      is Column<*> -> {
        widget as Column<W>
        widget.children.widgets
      }
      is Row<*> -> {
        widget as Row<W>
        widget.children.widgets
      }
      else -> emptyList()
    }
  }
}

/**
 * @suppress For generated code usage only.
 */
@RedwoodCodegenApi
public interface RedwoodLayoutWidgetFactoryOwner<W : Any> : WidgetFactoryOwner<W> {
  public val RedwoodLayout: RedwoodLayoutWidgetFactory<W>

  @RedwoodCodegenApi
  public companion object {
    @Suppress("UNUSED_PARAMETER")
    public fun <W : Any> apply(
      factory: RedwoodLayoutWidgetFactory<W>,
      `value`: W,
      element: Modifier.UnscopedElement,
    ) {
    }
  }
}
