package app.cash.redwood.layout.widget

import app.cash.redwood.widget.Widget
import kotlin.Any
import kotlin.OptIn
import kotlin.experimental.ExperimentalObjCName
import kotlin.native.ObjCName

@OptIn(ExperimentalObjCName::class)
@ObjCName(
  "RedwoodLayoutWidgetFactories",
  exact = true,
)
public class RedwoodLayoutWidgetFactories<W : Any>(
  override val RedwoodLayout: RedwoodLayoutWidgetFactory<W>,
) : RedwoodLayoutWidgetFactoryProvider<W>

public interface RedwoodLayoutWidgetFactoryProvider<W : Any> : Widget.Provider<W> {
  public val RedwoodLayout: RedwoodLayoutWidgetFactory<W>
}
