package app.cash.redwood.layout.widget

import kotlin.Any
import kotlin.OptIn
import kotlin.experimental.ExperimentalObjCName
import kotlin.native.ObjCName

@OptIn(ExperimentalObjCName::class)
@ObjCName(
  "RedwoodLayoutWidgetFactory",
  exact = true,
)
public interface RedwoodLayoutWidgetFactory<W : Any> {
  /**
   * {tag=1}
   */
  public fun Row(): Row<W>

  /**
   * {tag=2}
   */
  public fun Column(): Column<W>

  /**
   * {tag=3}
   */
  public fun Spacer(): Spacer<W>
}
