@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.layout.widget

import kotlin.Any
import kotlin.OptIn
import kotlin.Suppress
import kotlin.experimental.ExperimentalObjCName
import kotlin.native.ObjCName

@OptIn(ExperimentalObjCName::class)
@ObjCName(
  "RedwoodLayoutWidgetFactory",
  exact = true,
)
public interface RedwoodLayoutWidgetFactory<W : Any> {
  /**
   * {tag=4}
   */
  public fun Box(): Box<W>

  /**
   * {tag=2}
   */
  public fun Column(): Column<W>

  /**
   * {tag=1}
   */
  public fun Row(): Row<W>

  /**
   * {tag=3}
   */
  public fun Spacer(): Spacer<W>
}
