@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.lazylayout.compose

import androidx.compose.runtime.Composable
import app.cash.redwood.Modifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.compose.RedwoodComposeNode
import app.cash.redwood.compose.WidgetNode
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.lazylayout.api.ScrollItemIndex
import app.cash.redwood.lazylayout.widget.RedwoodLazyLayoutWidgetFactoryProvider
import app.cash.redwood.lazylayout.widget.RefreshableLazyList
import app.cash.redwood.ui.Margin
import kotlin.Boolean
import kotlin.Int
import kotlin.OptIn
import kotlin.Suppress
import kotlin.UInt
import kotlin.Unit

@Composable
@OptIn(RedwoodCodegenApi::class)
public fun RefreshableLazyList(
  isVertical: Boolean,
  onViewportChanged: (Int, Int) -> Unit,
  itemsBefore: Int,
  itemsAfter: Int,
  refreshing: Boolean,
  onRefresh: (() -> Unit)?,
  width: Constraint,
  height: Constraint,
  margin: Margin,
  crossAxisAlignment: CrossAxisAlignment,
  scrollItemIndex: ScrollItemIndex,
  pullRefreshContentColor: UInt,
  modifier: Modifier = Modifier,
  placeholder: @Composable () -> Unit,
  items: @Composable () -> Unit,
) {
  RedwoodComposeNode<RedwoodLazyLayoutWidgetFactoryProvider<*>, RefreshableLazyList<*>>(
      factory = { it.RedwoodLazyLayout.RefreshableLazyList() },
      update = {
        set(modifier, WidgetNode.SetModifiers)
        set(isVertical) { recordChanged(); widget.isVertical(it) }
        set(onViewportChanged) { recordChanged(); widget.onViewportChanged(it) }
        set(itemsBefore) { recordChanged(); widget.itemsBefore(it) }
        set(itemsAfter) { recordChanged(); widget.itemsAfter(it) }
        set(refreshing) { recordChanged(); widget.refreshing(it) }
        set(onRefresh) { recordChanged(); widget.onRefresh(it) }
        set(width) { recordChanged(); widget.width(it) }
        set(height) { recordChanged(); widget.height(it) }
        set(margin) { recordChanged(); widget.margin(it) }
        set(crossAxisAlignment) { recordChanged(); widget.crossAxisAlignment(it) }
        set(scrollItemIndex) { recordChanged(); widget.scrollItemIndex(it) }
        set(pullRefreshContentColor) { recordChanged(); widget.pullRefreshContentColor(it) }
      },
      content = {
        into(RefreshableLazyList<*>::placeholder) {
          placeholder()
        }
        into(RefreshableLazyList<*>::items) {
          items()
        }
      },
      )
}
