package app.cash.redwood.lazylayout.compose

import androidx.compose.runtime.Composable
import app.cash.redwood.LayoutModifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.compose.RedwoodComposeNode
import app.cash.redwood.compose.WidgetNode
import app.cash.redwood.lazylayout.widget.LazyList
import app.cash.redwood.lazylayout.widget.RedwoodLazyLayoutWidgetFactoryProvider
import kotlin.Boolean
import kotlin.Int
import kotlin.OptIn
import kotlin.Unit

@Composable
@OptIn(RedwoodCodegenApi::class)
public fun LazyList(
  isVertical: Boolean,
  onPositionDisplayed: (Int) -> Unit,
  layoutModifier: LayoutModifier = LayoutModifier,
  items: @Composable () -> Unit,
): Unit {
  RedwoodComposeNode<RedwoodLazyLayoutWidgetFactoryProvider<*>, LazyList<*>>(
      factory = { it.RedwoodLazyLayout.LazyList() },
      update = {
        set(layoutModifier, WidgetNode.SetLayoutModifiers)
        set(isVertical) { widget.isVertical(it) }
        set(onPositionDisplayed) { widget.onPositionDisplayed(it) }
      },
      content = {
        into(LazyList<*>::items) {
          items()
        }
      },
      )
}
