package app.cash.redwood.lazylayout.compose

import androidx.compose.runtime.Composable
import app.cash.redwood.Modifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.compose.RedwoodComposeNode
import app.cash.redwood.compose.WidgetNode
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.lazylayout.widget.LazyList
import app.cash.redwood.lazylayout.widget.RedwoodLazyLayoutWidgetFactoryProvider
import kotlin.Boolean
import kotlin.Int
import kotlin.OptIn
import kotlin.Unit

@Composable
@OptIn(RedwoodCodegenApi::class)
public fun LazyList(
  isVertical: Boolean,
  onViewportChanged: (Int, Int) -> Unit,
  itemsBefore: Int,
  itemsAfter: Int,
  width: Constraint,
  height: Constraint,
  modifier: Modifier = Modifier,
  placeholder: @Composable () -> Unit,
  items: @Composable () -> Unit,
) {
  RedwoodComposeNode<RedwoodLazyLayoutWidgetFactoryProvider<*>, LazyList<*>>(
      factory = { it.RedwoodLazyLayout.LazyList() },
      update = {
        set(modifier, WidgetNode.SetModifiers)
        set(isVertical) { recordChanged(); widget.isVertical(it) }
        set(onViewportChanged) { recordChanged(); widget.onViewportChanged(it) }
        set(itemsBefore) { recordChanged(); widget.itemsBefore(it) }
        set(itemsAfter) { recordChanged(); widget.itemsAfter(it) }
        set(width) { recordChanged(); widget.width(it) }
        set(height) { recordChanged(); widget.height(it) }
      },
      content = {
        into(LazyList<*>::placeholder) {
          placeholder()
        }
        into(LazyList<*>::items) {
          items()
        }
      },
      )
}
