package app.cash.redwood.lazylayout.widget

import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.testing.TestRedwoodComposition
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.widget.MutableListChildren
import kotlin.OptIn
import kotlin.collections.List
import kotlinx.coroutines.coroutineScope

@OptIn(RedwoodCodegenApi::class)
public suspend fun <R>
    RedwoodLazyLayoutTester(body: suspend TestRedwoodComposition<List<WidgetValue>>.() -> R): R =
    coroutineScope {
  val factories = RedwoodLazyLayoutWidgetFactories(
    RedwoodLazyLayout = RedwoodLazyLayoutTestingWidgetFactory(),
  )
  val container = MutableListChildren<WidgetValue>()
  val tester = TestRedwoodComposition(this, factories, container) {
    container.map { it.value }
  }
  try {
    tester.body()
  } finally {
    tester.cancel()
  }
}
