package app.cash.redwood.lazylayout.widget

import app.cash.redwood.Modifier
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.ui.Margin
import app.cash.redwood.widget.Widget
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.listOf

public class RefreshableLazyListValue(
  override val modifier: Modifier = Modifier,
  public val isVertical: Boolean,
  public val onViewportChanged: (Int, Int) -> Unit,
  public val itemsBefore: Int,
  public val itemsAfter: Int,
  public val refreshing: Boolean,
  public val onRefresh: (() -> Unit)?,
  public val width: Constraint,
  public val height: Constraint,
  public val margin: Margin,
  public val crossAxisAlignment: CrossAxisAlignment,
  public val placeholder: List<WidgetValue> = listOf(),
  public val items: List<WidgetValue> = listOf(),
) : WidgetValue {
  override val childrenLists: List<List<WidgetValue>>
    get() = listOf(placeholder, items)

  override fun equals(other: Any?): Boolean = other is RefreshableLazyListValue &&
  other.modifier == modifier &&
  other.isVertical == isVertical &&
  other.itemsBefore == itemsBefore &&
  other.itemsAfter == itemsAfter &&
  other.refreshing == refreshing &&
  other.width == width &&
  other.height == height &&
  other.margin == margin &&
  other.crossAxisAlignment == crossAxisAlignment &&
  other.placeholder == placeholder &&
  other.items == items

  override fun hashCode(): Int = listOf(modifier, isVertical, itemsBefore, itemsAfter, refreshing,
      width, height, margin, crossAxisAlignment, placeholder, items).hashCode()

  override fun toString(): String =
      """RefreshableLazyListValue(modifier=$modifier, isVertical=$isVertical, itemsBefore=$itemsBefore, itemsAfter=$itemsAfter, refreshing=$refreshing, width=$width, height=$height, margin=$margin, crossAxisAlignment=$crossAxisAlignment, placeholder=$placeholder, items=$items)"""

  override fun <W : Any> toWidget(provider: Widget.Provider<W>): Widget<W> {
    val factory = provider as RedwoodLazyLayoutWidgetFactoryProvider<W>
    val instance = factory.RedwoodLazyLayout.RefreshableLazyList()

    instance.modifier = modifier
    instance.isVertical(isVertical)
    instance.itemsBefore(itemsBefore)
    instance.itemsAfter(itemsAfter)
    instance.refreshing(refreshing)
    instance.width(width)
    instance.height(height)
    instance.margin(margin)
    instance.crossAxisAlignment(crossAxisAlignment)

    for ((index, child) in placeholder.withIndex()) {
      instance.placeholder.insert(index, child.toWidget(provider))
    }
    for ((index, child) in items.withIndex()) {
      instance.items.insert(index, child.toWidget(provider))
    }

    return instance
  }
}
