@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.lazylayout.testing

import app.cash.redwood.Modifier
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.lazylayout.api.ScrollItemIndex
import app.cash.redwood.lazylayout.widget.RefreshableLazyList
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.ui.Margin
import app.cash.redwood.widget.MutableListChildren
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.UInt
import kotlin.Unit

internal class MutableRefreshableLazyList : RefreshableLazyList<WidgetValue> {
  override val `value`: WidgetValue
    get() = RefreshableLazyListValue(
      modifier = modifier,
      isVertical = isVertical!!,
      onViewportChanged = onViewportChanged!!,
      itemsBefore = itemsBefore!!,
      itemsAfter = itemsAfter!!,
      refreshing = refreshing!!,
      onRefresh = onRefresh,
      width = width!!,
      height = height!!,
      margin = margin!!,
      crossAxisAlignment = crossAxisAlignment!!,
      scrollItemIndex = scrollItemIndex!!,
      pullRefreshContentColor = pullRefreshContentColor!!,
      placeholder = placeholder.map { it.`value` },
      items = items.map { it.`value` },
    )

  override var modifier: Modifier = Modifier

  private var isVertical: Boolean? = null

  private var onViewportChanged: ((Int, Int) -> Unit)? = null

  private var itemsBefore: Int? = null

  private var itemsAfter: Int? = null

  private var refreshing: Boolean? = null

  private var onRefresh: (() -> Unit)? = null

  private var width: Constraint? = null

  private var height: Constraint? = null

  private var margin: Margin? = null

  private var crossAxisAlignment: CrossAxisAlignment? = null

  private var scrollItemIndex: ScrollItemIndex? = null

  private var pullRefreshContentColor: UInt? = null

  override val placeholder: MutableListChildren<WidgetValue> = MutableListChildren()

  override val items: MutableListChildren<WidgetValue> = MutableListChildren()

  override fun isVertical(isVertical: Boolean) {
    this.isVertical = isVertical
  }

  override fun onViewportChanged(onViewportChanged: (Int, Int) -> Unit) {
    this.onViewportChanged = onViewportChanged
  }

  override fun itemsBefore(itemsBefore: Int) {
    this.itemsBefore = itemsBefore
  }

  override fun itemsAfter(itemsAfter: Int) {
    this.itemsAfter = itemsAfter
  }

  override fun refreshing(refreshing: Boolean) {
    this.refreshing = refreshing
  }

  override fun onRefresh(onRefresh: (() -> Unit)?) {
    this.onRefresh = onRefresh
  }

  override fun width(width: Constraint) {
    this.width = width
  }

  override fun height(height: Constraint) {
    this.height = height
  }

  override fun margin(margin: Margin) {
    this.margin = margin
  }

  override fun crossAxisAlignment(crossAxisAlignment: CrossAxisAlignment) {
    this.crossAxisAlignment = crossAxisAlignment
  }

  override fun scrollItemIndex(scrollItemIndex: ScrollItemIndex) {
    this.scrollItemIndex = scrollItemIndex
  }

  override fun pullRefreshContentColor(pullRefreshContentColor: UInt) {
    this.pullRefreshContentColor = pullRefreshContentColor
  }
}
