@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.lazylayout.testing

import app.cash.redwood.Modifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.lazylayout.api.ScrollItemIndex
import app.cash.redwood.lazylayout.widget.RedwoodLazyLayoutWidgetFactoryOwner
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.ui.Margin
import app.cash.redwood.widget.Widget
import app.cash.redwood.widget.WidgetSystem
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.OptIn
import kotlin.String
import kotlin.Suppress
import kotlin.UInt
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.listOf

public class RefreshableLazyListValue(
  override val modifier: Modifier = Modifier,
  public val isVertical: Boolean,
  public val onViewportChanged: (Int, Int) -> Unit,
  public val itemsBefore: Int,
  public val itemsAfter: Int,
  public val refreshing: Boolean,
  public val onRefresh: (() -> Unit)?,
  public val width: Constraint,
  public val height: Constraint,
  public val margin: Margin,
  public val crossAxisAlignment: CrossAxisAlignment,
  public val scrollItemIndex: ScrollItemIndex,
  public val pullRefreshContentColor: UInt,
  public val placeholder: List<WidgetValue> = listOf(),
  public val items: List<WidgetValue> = listOf(),
) : WidgetValue {
  override val childrenLists: List<List<WidgetValue>>
    get() = listOf(placeholder, items)

  override fun equals(other: Any?): Boolean = other is RefreshableLazyListValue &&
  other.modifier == modifier &&
  other.isVertical == isVertical &&
  other.itemsBefore == itemsBefore &&
  other.itemsAfter == itemsAfter &&
  other.refreshing == refreshing &&
  other.width == width &&
  other.height == height &&
  other.margin == margin &&
  other.crossAxisAlignment == crossAxisAlignment &&
  other.scrollItemIndex == scrollItemIndex &&
  other.pullRefreshContentColor == pullRefreshContentColor &&
  other.placeholder == placeholder &&
  other.items == items

  override fun hashCode(): Int = listOf(modifier, isVertical, itemsBefore, itemsAfter, refreshing,
      width, height, margin, crossAxisAlignment, scrollItemIndex, pullRefreshContentColor,
      placeholder, items).hashCode()

  override fun toString(): String =
      """RefreshableLazyListValue(modifier=$modifier, isVertical=$isVertical, itemsBefore=$itemsBefore, itemsAfter=$itemsAfter, refreshing=$refreshing, width=$width, height=$height, margin=$margin, crossAxisAlignment=$crossAxisAlignment, scrollItemIndex=$scrollItemIndex, pullRefreshContentColor=$pullRefreshContentColor, placeholder=$placeholder, items=$items)"""

  @OptIn(RedwoodCodegenApi::class)
  override fun <W : Any> toWidget(widgetSystem: WidgetSystem<W>): Widget<W> {
    @Suppress("UNCHECKED_CAST") // Type parameter shared in generated code.
    val factoryOwner = widgetSystem as RedwoodLazyLayoutWidgetFactoryOwner<W>
    val instance = factoryOwner.RedwoodLazyLayout.RefreshableLazyList()

    instance.isVertical(isVertical)
    instance.itemsBefore(itemsBefore)
    instance.itemsAfter(itemsAfter)
    instance.refreshing(refreshing)
    instance.width(width)
    instance.height(height)
    instance.margin(margin)
    instance.crossAxisAlignment(crossAxisAlignment)
    instance.scrollItemIndex(scrollItemIndex)
    instance.pullRefreshContentColor(pullRefreshContentColor)
    instance.modifier = modifier

    for ((index, child) in placeholder.withIndex()) {
      instance.placeholder.insert(index, child.toWidget(widgetSystem))
    }
    for ((index, child) in items.withIndex()) {
      instance.items.insert(index, child.toWidget(widgetSystem))
    }

    return instance
  }
}
