@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.lazylayout.widget

import kotlin.Any
import kotlin.OptIn
import kotlin.Suppress
import kotlin.experimental.ExperimentalObjCName
import kotlin.native.ObjCName

@OptIn(ExperimentalObjCName::class)
@ObjCName(
  "RedwoodLazyLayoutWidgetFactory",
  exact = true,
)
public interface RedwoodLazyLayoutWidgetFactory<W : Any> {
  /**
   * {tag=1}
   */
  public fun LazyList(): LazyList<W>

  /**
   * {tag=2}
   */
  public fun RefreshableLazyList(): RefreshableLazyList<W>
}
