@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.lazylayout.widget

import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.lazylayout.api.ScrollItemIndex
import app.cash.redwood.ui.Margin
import app.cash.redwood.widget.Widget
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.OptIn
import kotlin.Suppress
import kotlin.UInt
import kotlin.Unit
import kotlin.experimental.ExperimentalObjCName
import kotlin.native.ObjCName

/**
 * {tag=2}
 */
@OptIn(ExperimentalObjCName::class)
@ObjCName(
  "RefreshableLazyList",
  exact = true,
)
public interface RefreshableLazyList<W : Any> : Widget<W> {
  /**
   * {tag=1}
   */
  public val placeholder: Widget.Children<W>

  /**
   * {tag=2}
   */
  public val items: Widget.Children<W>

  /**
   * {tag=1}
   */
  public fun isVertical(isVertical: Boolean)

  /**
   * {tag=2}
   */
  public fun onViewportChanged(onViewportChanged: (Int, Int) -> Unit)

  /**
   * {tag=3}
   */
  public fun itemsBefore(itemsBefore: Int)

  /**
   * {tag=4}
   */
  public fun itemsAfter(itemsAfter: Int)

  /**
   * {tag=5}
   */
  public fun refreshing(refreshing: Boolean)

  /**
   * {tag=6}
   */
  public fun onRefresh(onRefresh: (() -> Unit)?)

  /**
   * {tag=7}
   */
  public fun width(width: Constraint)

  /**
   * {tag=8}
   */
  public fun height(height: Constraint)

  /**
   * {tag=9}
   */
  public fun margin(margin: Margin)

  /**
   * {tag=10}
   */
  public fun crossAxisAlignment(crossAxisAlignment: CrossAxisAlignment)

  /**
   * {tag=11}
   */
  public fun scrollItemIndex(scrollItemIndex: ScrollItemIndex)

  /**
   * {tag=12}
   */
  public fun pullRefreshContentColor(pullRefreshContentColor: UInt)
}
