/*
 * Decompiled with CFR 0.152.
 */
package app.cash.redwood.treehouse;

import app.cash.redwood.leaks.LeakDetector;
import app.cash.redwood.treehouse.AppService;
import app.cash.redwood.treehouse.CodeEventPublisher;
import app.cash.redwood.treehouse.CodeHost;
import app.cash.redwood.treehouse.CodeSession;
import app.cash.redwood.treehouse.CodeState;
import app.cash.redwood.treehouse.Content;
import app.cash.redwood.treehouse.State;
import app.cash.redwood.treehouse.TreehouseContentSource;
import app.cash.redwood.treehouse.TreehouseDispatchers;
import app.cash.redwood.treehouse.TreehouseView;
import app.cash.redwood.treehouse.ViewContentCodeBinding;
import app.cash.redwood.treehouse.ViewState;
import app.cash.redwood.ui.OnBackPressedDispatcher;
import app.cash.redwood.ui.UiConfiguration;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B;\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0014\u0010\u001c\u001a\u00020\u00162\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0016H\u0016J\u0016\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016J\u001e\u0010'\u001a\u00020\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000&2\u0006\u0010)\u001a\u00020*H\u0016J\u0016\u0010+\u001a\u00020\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016J\u0012\u0010,\u001a\u00020\u00162\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J:\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000&2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0017\u001a\u00020\u00182\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lapp/cash/redwood/treehouse/TreehouseAppContent;", "A", "Lapp/cash/redwood/treehouse/AppService;", "Lapp/cash/redwood/treehouse/Content;", "Lapp/cash/redwood/treehouse/CodeHost$Listener;", "Lapp/cash/redwood/treehouse/CodeSession$Listener;", "codeHost", "Lapp/cash/redwood/treehouse/CodeHost;", "dispatchers", "Lapp/cash/redwood/treehouse/TreehouseDispatchers;", "codeEventPublisher", "Lapp/cash/redwood/treehouse/CodeEventPublisher;", "source", "Lapp/cash/redwood/treehouse/TreehouseContentSource;", "leakDetector", "Lapp/cash/redwood/leaks/LeakDetector;", "<init>", "(Lapp/cash/redwood/treehouse/CodeHost;Lapp/cash/redwood/treehouse/TreehouseDispatchers;Lapp/cash/redwood/treehouse/CodeEventPublisher;Lapp/cash/redwood/treehouse/TreehouseContentSource;Lapp/cash/redwood/leaks/LeakDetector;)V", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lapp/cash/redwood/treehouse/State;", "preload", "", "onBackPressedDispatcher", "Lapp/cash/redwood/ui/OnBackPressedDispatcher;", "uiConfiguration", "Lkotlinx/coroutines/flow/StateFlow;", "Lapp/cash/redwood/ui/UiConfiguration;", "bind", "view", "Lapp/cash/redwood/treehouse/TreehouseView;", "awaitContent", "untilChangeCount", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unbind", "codeSessionChanged", "next", "Lapp/cash/redwood/treehouse/CodeSession;", "onUncaughtException", "codeSession", "exception", "", "onStop", "codeSessionStopped", "startViewCodeContentBinding", "Lapp/cash/redwood/treehouse/ViewContentCodeBinding;", "isInitialLaunch", "", "firstUiConfiguration", "redwood-treehouse-host"})
public final class TreehouseAppContent<A extends AppService>
implements Content,
CodeHost.Listener<A>,
CodeSession.Listener<A> {
    @NotNull
    private final CodeHost<A> codeHost;
    @NotNull
    private final TreehouseDispatchers dispatchers;
    @NotNull
    private final CodeEventPublisher codeEventPublisher;
    @NotNull
    private final TreehouseContentSource<A> source;
    @NotNull
    private final LeakDetector leakDetector;
    @NotNull
    private final MutableStateFlow<State<A>> stateFlow;

    public TreehouseAppContent(@NotNull CodeHost<A> codeHost2, @NotNull TreehouseDispatchers dispatchers, @NotNull CodeEventPublisher codeEventPublisher, @NotNull TreehouseContentSource<A> source, @NotNull LeakDetector leakDetector) {
        Intrinsics.checkNotNullParameter(codeHost2, (String)"codeHost");
        Intrinsics.checkNotNullParameter((Object)dispatchers, (String)"dispatchers");
        Intrinsics.checkNotNullParameter((Object)codeEventPublisher, (String)"codeEventPublisher");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)leakDetector, (String)"leakDetector");
        this.codeHost = codeHost2;
        this.dispatchers = dispatchers;
        this.codeEventPublisher = codeEventPublisher;
        this.source = source;
        this.leakDetector = leakDetector;
        this.stateFlow = StateFlowKt.MutableStateFlow(new State(ViewState.None.INSTANCE, new CodeState.Idle(true)));
    }

    @Override
    public void preload(@NotNull OnBackPressedDispatcher onBackPressedDispatcher, @NotNull StateFlow<UiConfiguration> uiConfiguration) {
        Intrinsics.checkNotNullParameter((Object)onBackPressedDispatcher, (String)"onBackPressedDispatcher");
        Intrinsics.checkNotNullParameter(uiConfiguration, (String)"uiConfiguration");
        this.dispatchers.checkUi();
        State previousState = (State)this.stateFlow.getValue();
        if (Intrinsics.areEqual((Object)previousState.getViewState(), (Object)new ViewState.Preloading(onBackPressedDispatcher, uiConfiguration))) {
            return;
        }
        if (!(previousState.getViewState() instanceof ViewState.None)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ViewState.Preloading nextViewState = new ViewState.Preloading(onBackPressedDispatcher, uiConfiguration);
        CodeSession<A> codeSession = this.codeHost.getCodeSession();
        CodeState nextCodeState = previousState.getCodeState() instanceof CodeState.Idle && codeSession != null ? (CodeState)new CodeState.Running(this.startViewCodeContentBinding(codeSession, true, onBackPressedDispatcher, uiConfiguration), 0, 0, 6, null) : previousState.getCodeState();
        this.codeHost.addListener(this);
        this.stateFlow.setValue(new State(nextViewState, nextCodeState));
    }

    @Override
    public void bind(@NotNull TreehouseView<?> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.dispatchers.checkUi();
        if (Intrinsics.areEqual((Object)((State)this.stateFlow.getValue()).getViewState(), (Object)new ViewState.Bound(view))) {
            return;
        }
        this.preload(view.getOnBackPressedDispatcher(), (StateFlow<UiConfiguration>)view.getUiConfiguration());
        State previousState = (State)this.stateFlow.getValue();
        ViewState previousViewState = previousState.getViewState();
        if (!(previousViewState instanceof ViewState.Preloading)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ViewState.Bound nextViewState = new ViewState.Bound(view);
        CodeState nextCodeState = previousState.getCodeState();
        CodeState codeState = nextCodeState;
        if (codeState instanceof CodeState.Idle) {
            this.codeEventPublisher.onInitialCodeLoading(view);
        } else if (codeState instanceof CodeState.Running) {
            ((CodeState.Running)nextCodeState).getViewContentCodeBinding().initView(view);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.stateFlow.setValue(new State(nextViewState, nextCodeState));
    }

    @Override
    @Nullable
    public Object awaitContent(int untilChangeCount, @NotNull Continuation<? super Unit> $completion) {
        Object object = FlowKt.first((Flow)((Flow)this.stateFlow), (Function2)new Function2<State<A>, Continuation<? super Boolean>, Object>(untilChangeCount, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ int $untilChangeCount;
            {
                this.$untilChangeCount = $untilChangeCount;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        State it = (State)this.L$0;
                        if (it.getViewState() instanceof ViewState.None) {
                            throw new CancellationException("unbound while awaiting content");
                        }
                        return Boxing.boxBoolean((it.getCodeState() instanceof CodeState.Running && ((CodeState.Running)it.getCodeState()).getChangeCount() >= this.$untilChangeCount ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<State<A>, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(State<A> p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void unbind() {
        this.dispatchers.checkUi();
        State previousState = (State)this.stateFlow.getValue();
        ViewState previousViewState = previousState.getViewState();
        if (previousViewState instanceof ViewState.None) {
            return;
        }
        ViewState.None nextViewState = ViewState.None.INSTANCE;
        CodeState.Idle nextCodeState = new CodeState.Idle(true);
        this.codeHost.removeListener(this);
        if (previousState.getCodeState() instanceof CodeState.Running) {
            ViewContentCodeBinding binding = ((CodeState.Running)previousState.getCodeState()).getViewContentCodeBinding();
            binding.cancel(null);
            binding.getCodeSession().removeListener(this);
        }
        this.stateFlow.setValue(new State(nextViewState, nextCodeState));
    }

    @Override
    public void codeSessionChanged(@NotNull CodeSession<A> next) {
        StateFlow stateFlow;
        OnBackPressedDispatcher onBackPressedDispatcher;
        Intrinsics.checkNotNullParameter(next, (String)"next");
        this.dispatchers.checkUi();
        State previousState = (State)this.stateFlow.getValue();
        ViewState viewState = previousState.getViewState();
        CodeState previousCodeState = previousState.getCodeState();
        ViewState viewState2 = viewState;
        if (viewState2 instanceof ViewState.Preloading) {
            onBackPressedDispatcher = ((ViewState.Preloading)viewState).getOnBackPressedDispatcher();
        } else if (viewState2 instanceof ViewState.Bound) {
            onBackPressedDispatcher = ((ViewState.Bound)viewState).getView().getOnBackPressedDispatcher();
        } else {
            throw new IllegalStateException("unexpected receiveCodeSession with no view bound and no preload".toString());
        }
        OnBackPressedDispatcher onBackPressedDispatcher2 = onBackPressedDispatcher;
        ViewState viewState3 = viewState;
        if (viewState3 instanceof ViewState.Preloading) {
            stateFlow = ((ViewState.Preloading)viewState).getUiConfiguration();
        } else if (viewState3 instanceof ViewState.Bound) {
            stateFlow = ((ViewState.Bound)viewState).getView().getUiConfiguration();
        } else {
            throw new IllegalStateException("unexpected receiveCodeSession with no view bound and no preload".toString());
        }
        StateFlow uiConfiguration = stateFlow;
        CodeState.Idle idle = previousCodeState instanceof CodeState.Idle ? (CodeState.Idle)previousCodeState : null;
        CodeState.Running nextCodeState = new CodeState.Running(this.startViewCodeContentBinding(next, idle != null ? idle.isInitialLaunch() : false, onBackPressedDispatcher2, (StateFlow<UiConfiguration>)uiConfiguration), 0, 0, 6, null);
        if (viewState instanceof ViewState.Bound) {
            nextCodeState.getViewContentCodeBinding().initView(((ViewState.Bound)viewState).getView());
        }
        if (previousCodeState instanceof CodeState.Running) {
            ViewContentCodeBinding binding = ((CodeState.Running)previousCodeState).getViewContentCodeBinding();
            binding.cancel(null);
            binding.getCodeSession().removeListener(this);
        }
        this.stateFlow.setValue(new State(viewState, nextCodeState));
    }

    @Override
    public void onUncaughtException(@NotNull CodeSession<A> codeSession, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter(codeSession, (String)"codeSession");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.codeSessionStopped(exception);
    }

    @Override
    public void onStop(@NotNull CodeSession<A> codeSession) {
        Intrinsics.checkNotNullParameter(codeSession, (String)"codeSession");
        this.codeSessionStopped(null);
    }

    private final void codeSessionStopped(Throwable exception) {
        this.dispatchers.checkUi();
        State previousState = (State)this.stateFlow.getValue();
        ViewState viewState = previousState.getViewState();
        CodeState previousCodeState = previousState.getCodeState();
        if (!(previousCodeState instanceof CodeState.Running)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ViewContentCodeBinding binding = ((CodeState.Running)previousCodeState).getViewContentCodeBinding();
        binding.cancel(exception);
        binding.getCodeSession().removeListener(this);
        CodeState.Idle nextCodeState = new CodeState.Idle(false);
        this.stateFlow.setValue(new State(viewState, nextCodeState));
    }

    private final ViewContentCodeBinding<A> startViewCodeContentBinding(CodeSession<A> codeSession, boolean isInitialLaunch, OnBackPressedDispatcher onBackPressedDispatcher, StateFlow<UiConfiguration> firstUiConfiguration) {
        ViewContentCodeBinding<A> viewContentCodeBinding;
        this.dispatchers.checkUi();
        codeSession.addListener(this);
        ViewContentCodeBinding<A> $this$startViewCodeContentBinding_u24lambda_u240 = viewContentCodeBinding = new ViewContentCodeBinding<A>(this.codeHost.getStateStore(), this.dispatchers, codeSession.getEventPublisher(), this.source, this.codeEventPublisher, this.stateFlow, codeSession, isInitialLaunch, onBackPressedDispatcher, firstUiConfiguration, this.leakDetector);
        boolean bl = false;
        $this$startViewCodeContentBinding_u24lambda_u240.start();
        return viewContentCodeBinding;
    }
}

