/*
 * Decompiled with CFR 0.152.
 */
package app.cash.redwood.treehouse;

import app.cash.redwood.leaks.LeakDetector;
import app.cash.redwood.treehouse.AppService;
import app.cash.redwood.treehouse.CodeHost;
import app.cash.redwood.treehouse.CodeSession;
import app.cash.redwood.treehouse.CodeState;
import app.cash.redwood.treehouse.Content;
import app.cash.redwood.treehouse.InternalState;
import app.cash.redwood.treehouse.TreehouseAppContentKt;
import app.cash.redwood.treehouse.TreehouseContentSource;
import app.cash.redwood.treehouse.TreehouseDispatchers;
import app.cash.redwood.treehouse.TreehouseView;
import app.cash.redwood.treehouse.ViewContentCodeBinding;
import app.cash.redwood.treehouse.ViewState;
import app.cash.redwood.ui.OnBackPressedDispatcher;
import app.cash.redwood.ui.UiConfiguration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B3\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016H\u0016J\u0014\u0010\u001f\u001a\u00020\u001a2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\b\u0010\"\u001a\u00020\u001aH\u0016J\u0016\u0010#\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u001e\u0010&\u001a\u00020\u001a2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u0010*\u001a\u00020\u001a2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u0012\u0010+\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J2\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000-2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lapp/cash/redwood/treehouse/TreehouseAppContent;", "A", "Lapp/cash/redwood/treehouse/AppService;", "Lapp/cash/redwood/treehouse/Content;", "Lapp/cash/redwood/treehouse/CodeHost$Listener;", "Lapp/cash/redwood/treehouse/CodeSession$Listener;", "codeHost", "Lapp/cash/redwood/treehouse/CodeHost;", "dispatchers", "Lapp/cash/redwood/treehouse/TreehouseDispatchers;", "source", "Lapp/cash/redwood/treehouse/TreehouseContentSource;", "leakDetector", "Lapp/cash/redwood/leaks/LeakDetector;", "<init>", "(Lapp/cash/redwood/treehouse/CodeHost;Lapp/cash/redwood/treehouse/TreehouseDispatchers;Lapp/cash/redwood/treehouse/TreehouseContentSource;Lapp/cash/redwood/leaks/LeakDetector;)V", "internalStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lapp/cash/redwood/treehouse/InternalState;", "externalStateFlow", "Lapp/cash/redwood/treehouse/Content$State;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "preload", "", "onBackPressedDispatcher", "Lapp/cash/redwood/ui/OnBackPressedDispatcher;", "uiConfiguration", "Lapp/cash/redwood/ui/UiConfiguration;", "bind", "view", "Lapp/cash/redwood/treehouse/TreehouseView;", "unbind", "codeSessionChanged", "next", "Lapp/cash/redwood/treehouse/CodeSession;", "onUncaughtException", "codeSession", "exception", "", "onStop", "codeSessionStopped", "startViewCodeContentBinding", "Lapp/cash/redwood/treehouse/ViewContentCodeBinding;", "firstUiConfiguration", "redwood-treehouse-host"})
public final class TreehouseAppContent<A extends AppService>
implements Content,
CodeHost.Listener<A>,
CodeSession.Listener<A> {
    @NotNull
    private final CodeHost<A> codeHost;
    @NotNull
    private final TreehouseDispatchers dispatchers;
    @NotNull
    private final TreehouseContentSource<A> source;
    @NotNull
    private final LeakDetector leakDetector;
    @NotNull
    private final MutableStateFlow<InternalState<A>> internalStateFlow;
    @NotNull
    private final MutableStateFlow<Content.State> externalStateFlow;

    public TreehouseAppContent(@NotNull CodeHost<A> codeHost2, @NotNull TreehouseDispatchers dispatchers, @NotNull TreehouseContentSource<A> source, @NotNull LeakDetector leakDetector) {
        Intrinsics.checkNotNullParameter(codeHost2, (String)"codeHost");
        Intrinsics.checkNotNullParameter((Object)dispatchers, (String)"dispatchers");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)leakDetector, (String)"leakDetector");
        this.codeHost = codeHost2;
        this.dispatchers = dispatchers;
        this.source = source;
        this.leakDetector = leakDetector;
        this.internalStateFlow = StateFlowKt.MutableStateFlow(new InternalState(ViewState.None.INSTANCE, new CodeState.Idle(0, null)));
        this.externalStateFlow = StateFlowKt.MutableStateFlow((Object)new Content.State(0, false, 0, null, 8, null));
    }

    @Override
    @NotNull
    public StateFlow<Content.State> getState() {
        return (StateFlow)this.externalStateFlow;
    }

    @Override
    public void preload(@NotNull OnBackPressedDispatcher onBackPressedDispatcher, @NotNull StateFlow<UiConfiguration> uiConfiguration) {
        CodeState codeState;
        Intrinsics.checkNotNullParameter((Object)onBackPressedDispatcher, (String)"onBackPressedDispatcher");
        Intrinsics.checkNotNullParameter(uiConfiguration, (String)"uiConfiguration");
        this.dispatchers.checkUi();
        InternalState previousState = (InternalState)this.internalStateFlow.getValue();
        if (Intrinsics.areEqual((Object)previousState.getViewState(), (Object)new ViewState.Preloading(onBackPressedDispatcher, uiConfiguration))) {
            return;
        }
        if (!(previousState.getViewState() instanceof ViewState.None)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ViewState.Preloading nextViewState = new ViewState.Preloading(onBackPressedDispatcher, uiConfiguration);
        CodeSession<A> codeSession = this.codeHost.getCodeSession();
        if (previousState.getCodeState() instanceof CodeState.Idle && codeSession != null) {
            int newLoadCount = ((CodeState.Idle)previousState.getCodeState()).getLoadCount() + 1;
            codeState = new CodeState.Running(newLoadCount, ((CodeState.Idle)previousState.getCodeState()).getLastUncaughtException(), this.startViewCodeContentBinding(codeSession, onBackPressedDispatcher, uiConfiguration), 0, 0, 24, null);
        } else {
            codeState = previousState.getCodeState();
        }
        CodeState nextCodeState = codeState;
        this.codeHost.addListener(this);
        this.internalStateFlow.setValue(new InternalState(nextViewState, nextCodeState));
        this.externalStateFlow.setValue((Object)nextCodeState.asState());
    }

    @Override
    public void bind(@NotNull TreehouseView<?> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.dispatchers.checkUi();
        if (Intrinsics.areEqual((Object)((InternalState)this.internalStateFlow.getValue()).getViewState(), (Object)new ViewState.Bound(view))) {
            return;
        }
        this.preload(view.getOnBackPressedDispatcher(), (StateFlow<UiConfiguration>)view.getUiConfiguration());
        InternalState previousState = (InternalState)this.internalStateFlow.getValue();
        ViewState previousViewState = previousState.getViewState();
        CodeState previousCodeState = previousState.getCodeState();
        if (!(previousViewState instanceof ViewState.Preloading)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ViewState.Bound nextViewState = new ViewState.Bound(view);
        CodeState codeState = previousCodeState;
        if (codeState instanceof CodeState.Idle) {
            TreehouseAppContentKt.access$showLoading(view);
        } else if (codeState instanceof CodeState.Running) {
            ((CodeState.Running)previousCodeState).getViewContentCodeBinding().initView(view, true);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        CodeState nextCodeState = ((InternalState)this.internalStateFlow.getValue()).getCodeState();
        this.internalStateFlow.setValue(new InternalState(nextViewState, nextCodeState));
        this.externalStateFlow.setValue((Object)nextCodeState.asState());
    }

    @Override
    public void unbind() {
        this.dispatchers.checkUi();
        InternalState previousState = (InternalState)this.internalStateFlow.getValue();
        ViewState previousViewState = previousState.getViewState();
        CodeState previousCodeState = previousState.getCodeState();
        if (previousViewState instanceof ViewState.None) {
            return;
        }
        ViewState.None nextViewState = ViewState.None.INSTANCE;
        CodeState.Idle nextCodeState = new CodeState.Idle(previousCodeState.getLoadCount(), previousCodeState.getLastUncaughtException());
        this.codeHost.removeListener(this);
        if (previousCodeState instanceof CodeState.Running) {
            ViewContentCodeBinding binding = ((CodeState.Running)previousCodeState).getViewContentCodeBinding();
            binding.cancel(null);
            binding.getCodeSession().removeListener(this);
        }
        this.internalStateFlow.setValue(new InternalState(nextViewState, nextCodeState));
        this.externalStateFlow.setValue((Object)nextCodeState.asState());
    }

    @Override
    public void codeSessionChanged(@NotNull CodeSession<A> next) {
        StateFlow stateFlow;
        OnBackPressedDispatcher onBackPressedDispatcher;
        Intrinsics.checkNotNullParameter(next, (String)"next");
        this.dispatchers.checkUi();
        InternalState previousState = (InternalState)this.internalStateFlow.getValue();
        ViewState viewState = previousState.getViewState();
        CodeState previousCodeState = previousState.getCodeState();
        ViewState viewState2 = viewState;
        if (viewState2 instanceof ViewState.Preloading) {
            onBackPressedDispatcher = ((ViewState.Preloading)viewState).getOnBackPressedDispatcher();
        } else if (viewState2 instanceof ViewState.Bound) {
            onBackPressedDispatcher = ((ViewState.Bound)viewState).getView().getOnBackPressedDispatcher();
        } else {
            throw new IllegalStateException("unexpected receiveCodeSession with no view bound and no preload".toString());
        }
        OnBackPressedDispatcher onBackPressedDispatcher2 = onBackPressedDispatcher;
        ViewState viewState3 = viewState;
        if (viewState3 instanceof ViewState.Preloading) {
            stateFlow = ((ViewState.Preloading)viewState).getUiConfiguration();
        } else if (viewState3 instanceof ViewState.Bound) {
            stateFlow = ((ViewState.Bound)viewState).getView().getUiConfiguration();
        } else {
            throw new IllegalStateException("unexpected receiveCodeSession with no view bound and no preload".toString());
        }
        StateFlow uiConfiguration = stateFlow;
        int newLoadCount = previousCodeState.getLoadCount() + 1;
        CodeState.Running nextCodeState = new CodeState.Running(newLoadCount, previousState.getCodeState().getLastUncaughtException(), this.startViewCodeContentBinding(next, onBackPressedDispatcher2, (StateFlow<UiConfiguration>)uiConfiguration), 0, 0, 24, null);
        if (viewState instanceof ViewState.Bound) {
            nextCodeState.getViewContentCodeBinding().initView(((ViewState.Bound)viewState).getView(), false);
        }
        if (previousCodeState instanceof CodeState.Running) {
            ViewContentCodeBinding binding = ((CodeState.Running)previousCodeState).getViewContentCodeBinding();
            binding.cancel(null);
            binding.getCodeSession().removeListener(this);
        }
        this.internalStateFlow.setValue(new InternalState(viewState, nextCodeState));
        this.externalStateFlow.setValue((Object)nextCodeState.asState());
    }

    @Override
    public void onUncaughtException(@NotNull CodeSession<A> codeSession, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter(codeSession, (String)"codeSession");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.codeSessionStopped(exception);
    }

    @Override
    public void onStop(@NotNull CodeSession<A> codeSession) {
        Intrinsics.checkNotNullParameter(codeSession, (String)"codeSession");
        this.codeSessionStopped(null);
    }

    private final void codeSessionStopped(Throwable exception) {
        this.dispatchers.checkUi();
        InternalState previousState = (InternalState)this.internalStateFlow.getValue();
        ViewState viewState = previousState.getViewState();
        CodeState previousCodeState = previousState.getCodeState();
        if (!(previousCodeState instanceof CodeState.Running)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ViewContentCodeBinding binding = ((CodeState.Running)previousCodeState).getViewContentCodeBinding();
        binding.cancel(exception);
        binding.getCodeSession().removeListener(this);
        CodeState.Idle nextCodeState = new CodeState.Idle(((CodeState.Running)previousCodeState).getLoadCount(), exception);
        this.internalStateFlow.setValue(new InternalState(viewState, nextCodeState));
        this.externalStateFlow.setValue((Object)nextCodeState.asState());
    }

    private final ViewContentCodeBinding<A> startViewCodeContentBinding(CodeSession<A> codeSession, OnBackPressedDispatcher onBackPressedDispatcher, StateFlow<UiConfiguration> firstUiConfiguration) {
        ViewContentCodeBinding<A> viewContentCodeBinding;
        this.dispatchers.checkUi();
        codeSession.addListener(this);
        ViewContentCodeBinding<A> $this$startViewCodeContentBinding_u24lambda_u240 = viewContentCodeBinding = new ViewContentCodeBinding<A>(this.codeHost, this.dispatchers, codeSession.getEventPublisher(), this.source, this.internalStateFlow, this.externalStateFlow, codeSession, onBackPressedDispatcher, firstUiConfiguration, this.leakDetector);
        boolean bl = false;
        $this$startViewCodeContentBinding_u24lambda_u240.start();
        return viewContentCodeBinding;
    }
}

