/*
 * Copyright (C) 2022 Square, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package app.cash.redwood.treehouse

import kotlin.time.Duration
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.transformLatest

/**
 * Returns a flow that mirrors [this], but repeats the latest value every [duration] if no value is
 * emitted by [this]. This is the inverse of `Flow.debounce()`.
 */
@OptIn(ExperimentalCoroutinesApi::class)
internal fun <T> Flow<T>.rebounce(duration: Duration): Flow<T> {
  return transformLatest {
    while (true) {
      emit(it)
      delay(duration)
    }
  }
}
