package app.cash.redwood.treehouse.lazylayout.compose

import androidx.compose.runtime.Composable
import app.cash.redwood.LayoutModifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.compose.RedwoodComposeNode
import app.cash.redwood.treehouse.lazylayout.api.LazyListIntervalContent
import app.cash.redwood.treehouse.lazylayout.widget.LazyColumn
import app.cash.redwood.treehouse.lazylayout.widget.RedwoodTreehouseLazyLayoutWidgetFactoryProvider
import kotlin.OptIn
import kotlin.Unit
import kotlin.collections.List

@Composable
@OptIn(RedwoodCodegenApi::class)
public fun LazyColumn(intervals: List<LazyListIntervalContent>, layoutModifier: LayoutModifier =
    LayoutModifier): Unit {
  RedwoodComposeNode<RedwoodTreehouseLazyLayoutWidgetFactoryProvider<*>, LazyColumn<*>>(
      factory = { it.RedwoodTreehouseLazyLayout.LazyColumn() },
      update = {
        set(layoutModifier) { layoutModifiers = it }
        set(intervals, LazyColumn<*>::intervals)
      },
      content = {
      },
      )
}
