/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisActionUtils;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAnalysisAction
extends AnAction {
    private final Supplier<@NlsContexts.DialogTitle String> myTitle;
    private final Supplier<String> myAnalysisNoun;

    protected BaseAnalysisAction(@NlsContexts.DialogTitle String title, @Nls(capitalization=Nls.Capitalization.Title) String analysisNoun) {
        this.myTitle = () -> title;
        this.myAnalysisNoun = () -> analysisNoun;
    }

    protected BaseAnalysisAction(Supplier<String> title, Supplier<String> analysisNoun) {
        this.myTitle = title;
        this.myAnalysisNoun = analysisNoun;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BaseAnalysisAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseAnalysisAction.$$$reportNull$$$0(1);
        }
        Project project2 = e.getProject();
        e.getPresentation().setEnabled(project2 != null && !DumbService.isDumb(project2) && this.getInspectionScope(e.getDataContext(), project2) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement element2;
        List<ModelScopeItem> items;
        AnalysisUIOptions uiOptions;
        Project project2;
        if (e == null) {
            BaseAnalysisAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        DataContext dataContext = e.getDataContext();
        AnalysisScope scope = this.getInspectionScope(dataContext, project2);
        if (scope == null) {
            return;
        }
        String title = this.getDialogTitle();
        String scopeTitle = CodeInsightBundle.message("analysis.scope.title", this.myAnalysisNoun.get());
        Module module = BaseAnalysisAction.getModuleFromContext(dataContext);
        boolean rememberScope = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        BaseAnalysisActionDialog dlg = this.getAnalysisDialog(project2, title, scopeTitle, rememberScope, uiOptions = AnalysisUIOptions.getInstance(project2), items = BaseAnalysisActionDialog.standardItems(project2, scope, module, element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)));
        if (!dlg.showAndGet()) {
            this.canceled();
            return;
        }
        int oldScopeType = uiOptions.SCOPE_TYPE;
        scope = dlg.getScope(scope);
        if (!rememberScope) {
            uiOptions.SCOPE_TYPE = oldScopeType;
        }
        uiOptions.ANALYZE_TEST_SOURCES = dlg.isInspectTestSources();
        FileDocumentManager.getInstance().saveAllDocuments();
        this.analyze(project2, scope);
    }

    @NotNull
    public BaseAnalysisActionDialog getAnalysisDialog(Project project2, @NlsContexts.DialogTitle String title, @NlsSafe String scopeTitle, boolean rememberScope, AnalysisUIOptions uiOptions, List<ModelScopeItem> items) {
        return new BaseAnalysisActionDialog(title, scopeTitle, project2, items, uiOptions, rememberScope){

            @Override
            protected JComponent getAdditionalActionSettings(Project project2) {
                return BaseAnalysisAction.this.getAdditionalActionSettings(project2, this);
            }

            protected String getHelpId() {
                return BaseAnalysisAction.this.getHelpTopic();
            }
        };
    }

    @NotNull
    @NlsContexts.DialogTitle
    protected String getDialogTitle() {
        String string2 = CodeInsightBundle.message("specify.analysis.scope", this.myTitle.get());
        if (string2 == null) {
            BaseAnalysisAction.$$$reportNull$$$0(3);
        }
        return string2;
    }

    protected String getHelpTopic() {
        return "reference.dialogs.analyzeDependencies.scope";
    }

    protected void canceled() {
    }

    protected abstract void analyze(@NotNull Project var1, @NotNull AnalysisScope var2);

    @Nullable
    private AnalysisScope getInspectionScope(@NotNull DataContext dataContext, @NotNull Project project2) {
        if (dataContext == null) {
            BaseAnalysisAction.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            BaseAnalysisAction.$$$reportNull$$$0(5);
        }
        return AnalysisActionUtils.getInspectionScope(dataContext, project2, this.acceptNonProjectDirectories());
    }

    protected boolean acceptNonProjectDirectories() {
        return false;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project2, BaseAnalysisActionDialog dialog) {
        return null;
    }

    @Nullable
    private static Module getModuleFromContext(@NotNull DataContext dataContext) {
        AnalysisScope scope;
        InspectionResultsView inspectionView;
        if (dataContext == null) {
            BaseAnalysisAction.$$$reportNull$$$0(6);
        }
        if ((inspectionView = (InspectionResultsView)dataContext.getData(InspectionResultsView.DATA_KEY)) != null && (scope = inspectionView.getScope()).getScopeType() == 4 && scope.isValid()) {
            return scope.getModule();
        }
        return (Module)dataContext.getData(PlatformCoreDataKeys.MODULE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/BaseAnalysisAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/BaseAnalysisAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleFromContext";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

