/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.NodeComparator;
import com.intellij.analysis.problemsView.toolWindow.ProblemNode;
import com.intellij.analysis.problemsView.toolWindow.ProblemsTreeModel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewIconUpdater;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewStatsCollector;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewTab;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.preview.DescriptorPreview;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemsViewPanel
extends OnePixelSplitter
implements Disposable,
DataProvider,
ProblemsViewTab {
    protected final ClientId myClientId;
    private final Project myProject;
    private final String myId;
    private final ProblemsViewState myState;
    private final Supplier<@NlsContexts.TabTitle String> myName;
    private final ProblemsTreeModel myTreeModel;
    private final DescriptorPreview myPreview;
    private final JPanel myPanel;
    private final ActionToolbar myToolbar;
    private final Insets myToolbarInsets;
    private final Tree myTree;
    private final TreeExpander myTreeExpander;
    private final AtomicReference<Long> myShowTime;
    private final SingleAlarm mySelectionAlarm;
    private final SingleAlarm myUpdateAlarm;
    private final ToggleOptionAction.Option myAutoscrollToSource;
    private final ToggleOptionAction.Option myOpenInPreviewTab;
    private final ToggleOptionAction.Option myShowPreview;
    private final ToggleOptionAction.Option myGroupByToolId;
    private final ToggleOptionAction.Option mySortFoldersFirst;
    private final ToggleOptionAction.Option mySortBySeverity;
    private final ToggleOptionAction.Option mySortByName;

    public ProblemsViewPanel(@NotNull Project project2, @NotNull String id2, @NotNull ProblemsViewState state, @NotNull Supplier<String> name2) {
        if (project2 == null) {
            ProblemsViewPanel.$$$reportNull$$$0(0);
        }
        if (id2 == null) {
            ProblemsViewPanel.$$$reportNull$$$0(1);
        }
        if (state == null) {
            ProblemsViewPanel.$$$reportNull$$$0(2);
        }
        if (name2 == null) {
            ProblemsViewPanel.$$$reportNull$$$0(3);
        }
        super(false, 0.5f, 0.1f, 0.9f);
        this.myClientId = ClientId.getCurrent();
        this.myTreeModel = new ProblemsTreeModel(this);
        this.myPreview = new DescriptorPreview((Splitter)((Object)this), true, this.myClientId);
        this.myToolbarInsets = JBUI.insetsRight(1);
        this.myShowTime = new AtomicReference();
        this.mySelectionAlarm = new SingleAlarm(() -> {
            ProblemNode node2 = (ProblemNode)((Object)((Object)TreeUtil.getLastUserObject(ProblemNode.class, (TreePath)this.getTree().getSelectionPath())));
            if (node2 != null) {
                ProblemsViewStatsCollector.problemSelected(this, node2.getProblem());
            }
            this.updateAutoscroll();
            this.updatePreview();
        }, 50, ModalityState.stateForComponent((Component)((Object)this)), (Disposable)this);
        this.myUpdateAlarm = new SingleAlarm(() -> {
            ToolWindow window = this.getCurrentToolWindow();
            if (window == null) {
                return;
            }
            Content content2 = this.getCurrentContent();
            if (content2 == null) {
                return;
            }
            Root root = this.myTreeModel.getRoot();
            int count2 = root == null ? 0 : root.getProblemCount();
            content2.setDisplayName(this.getName(count2));
            ProblemsViewIconUpdater.update(this.getProject());
        }, 50, ModalityState.stateForComponent((Component)((Object)this)), (Disposable)this);
        this.myAutoscrollToSource = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getAutoscrollToSource();
            }

            public void setSelected(boolean selected) {
                ProblemsViewPanel.this.myState.setAutoscrollToSource(selected);
                if (selected) {
                    ProblemsViewPanel.this.updateAutoscroll();
                }
            }
        };
        this.myOpenInPreviewTab = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return UISettings.getInstance().getOpenInPreviewTabIfPossible();
            }

            public void setSelected(boolean selected) {
                UISettings.getInstance().setOpenInPreviewTabIfPossible(selected);
                if (selected) {
                    ProblemsViewPanel.this.updateAutoscroll();
                }
            }
        };
        this.myShowPreview = new ToggleOptionAction.Option(){

            public boolean isEnabled() {
                VirtualFile file2 = ProblemsViewPanel.this.getSelectedFile();
                return file2 != null && null != ProblemsView.getDocument(ProblemsViewPanel.this.getProject(), file2);
            }

            public boolean isAlwaysVisible() {
                return true;
            }

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getShowPreview();
            }

            public void setSelected(boolean selected) {
                ProblemsViewPanel.this.myState.setShowPreview(selected);
                ProblemsViewPanel.this.updatePreview();
            }
        };
        this.myGroupByToolId = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getGroupByToolId();
            }

            public void setSelected(boolean selected) {
                ProblemsViewPanel.this.myState.setGroupByToolId(selected);
                ProblemsViewPanel.this.myTreeModel.structureChanged(null);
            }
        };
        this.mySortFoldersFirst = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getSortFoldersFirst();
            }

            public void setSelected(boolean selected) {
                ProblemsViewPanel.this.myState.setSortFoldersFirst(selected);
                ProblemsViewPanel.this.myTreeModel.setComparator(ProblemsViewPanel.this.createComparator());
            }
        };
        this.mySortBySeverity = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getSortBySeverity();
            }

            public void setSelected(boolean selected) {
                ProblemsViewPanel.this.myState.setSortBySeverity(selected);
                ProblemsViewPanel.this.myTreeModel.setComparator(ProblemsViewPanel.this.createComparator());
            }
        };
        this.mySortByName = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getSortByName();
            }

            public void setSelected(boolean selected) {
                ProblemsViewPanel.this.myState.setSortByName(selected);
                ProblemsViewPanel.this.myTreeModel.setComparator(ProblemsViewPanel.this.createComparator());
            }
        };
        this.myProject = project2;
        this.myId = id2;
        this.myState = state;
        this.myName = name2;
        this.myTreeModel.setComparator(this.createComparator());
        this.myTree = new Tree((TreeModel)new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), (Disposable)this));
        this.myTree.setRootVisible(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addTreeSelectionListener((TreeSelectionListener)new RestoreSelectionListener());
        this.myTree.addTreeSelectionListener(event -> this.mySelectionAlarm.cancelAndRequest());
        new TreeSpeedSearch((JTree)this.myTree);
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
        PopupHandler.installPopupMenu((JComponent)this.myTree, (String)this.getPopupHandlerGroupId(), (String)"ProblemsView.ToolWindow.TreePopup");
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myToolbar = this.getToolbar();
        this.myToolbar.setTargetComponent((JComponent)this.myTree);
        this.myToolbar.getComponent().setVisible(state.getShowToolbar());
        this.myPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree, (boolean)true);
        if (ExperimentalUI.isNewUI()) {
            scrollPane.getHorizontalScrollBar().addAdjustmentListener(event -> {
                Border border = event.getAdjustable().getValue() != 0 ? new CustomLineBorder(this.myToolbarInsets) : JBUI.Borders.empty(this.myToolbarInsets);
                this.myToolbar.getComponent().setBorder(border);
                this.myToolbar.getComponent().repaint();
            });
        } else {
            UIUtil.addBorder(this.myToolbar.getComponent(), new CustomLineBorder(this.myToolbarInsets));
        }
        this.myPanel.add("Center", scrollPane);
        this.myPanel.add("West", this.myToolbar.getComponent());
        this.myPanel.putClientProperty(FileEditorManagerImpl.OPEN_IN_PREVIEW_TAB, true);
        this.setFirstComponent(this.myPanel);
    }

    @Override
    public void dispose() {
        this.visibilityChangedTo(false);
        this.myPreview.close();
    }

    @Nullable
    private Content getCurrentContent() {
        ToolWindow window = this.getCurrentToolWindow();
        if (window == null) {
            return null;
        }
        ContentManager manager = window.getContentManagerIfCreated();
        if (manager == null) {
            return null;
        }
        return manager.getContent((JComponent)((Object)this));
    }

    private ToolWindow getCurrentToolWindow() {
        return ProblemsView.getToolWindow(this.getProject());
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ProblemsViewPanel.$$$reportNull$$$0(4);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.getProject();
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.getTreeExpander();
        }
        if (PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
            Editor editor2 = this.getPreview();
            if (editor2 != null) {
                return TextEditorProvider.getInstance().getTextEditor(editor2);
            }
            Node node2 = this.getSelectedNode();
            VirtualFile file2 = node2 == null ? null : node2.getVirtualFile();
            return file2 == null ? null : ArrayUtil.getFirstElement(FileEditorManager.getInstance(this.myProject).getEditors(file2));
        }
        Node node3 = this.getSelectedNode();
        if (node3 != null) {
            if (PlatformCoreDataKeys.SELECTED_ITEM.is(dataId)) {
                return node3;
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return node3.getNavigatable();
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return node3.getVirtualFile();
            }
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                Navigatable[] navigatableArray;
                Navigatable navigatable = node3.getNavigatable();
                if (navigatable == null) {
                    navigatableArray = null;
                } else {
                    Navigatable[] navigatableArray2 = new Navigatable[1];
                    navigatableArray = navigatableArray2;
                    navigatableArray2[0] = navigatable;
                }
                return navigatableArray;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                VirtualFile[] virtualFileArray;
                VirtualFile file3 = node3.getVirtualFile();
                if (file3 == null) {
                    virtualFileArray = null;
                } else {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = file3;
                }
                return virtualFileArray;
            }
        }
        return null;
    }

    protected void updateToolWindowContent() {
        this.myUpdateAlarm.cancelAndRequest();
    }

    @Override
    @NotNull
    @NlsContexts.TabTitle
    public String getName(int count2) {
        String name2 = this.myName.get();
        if (count2 <= 0) {
            String string2 = name2;
            if (string2 == null) {
                ProblemsViewPanel.$$$reportNull$$$0(5);
            }
            return string2;
        }
        String string3 = new HtmlBuilder().append(name2).append(" ").append(HtmlChunk.tag("font").attr("color", ColorUtil.toHtmlColor(UIUtil.getInactiveTextColor())).addText(String.valueOf(count2))).wrapWithHtmlBody().toString();
        if (string3 == null) {
            ProblemsViewPanel.$$$reportNull$$$0(6);
        }
        return string3;
    }

    protected void loadProportion() {
        if (this.myState != null) {
            this.setProportion(this.myState.getProportion());
        }
    }

    protected void saveProportion() {
        if (this.myState != null) {
            this.myState.setProportion(this.getProportion());
        }
    }

    @NotNull
    public final Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            ProblemsViewPanel.$$$reportNull$$$0(7);
        }
        return project2;
    }

    @NotNull
    public final ProblemsViewState getState() {
        ProblemsViewState problemsViewState = this.myState;
        if (problemsViewState == null) {
            ProblemsViewPanel.$$$reportNull$$$0(8);
        }
        return problemsViewState;
    }

    @NotNull
    public final ProblemsTreeModel getTreeModel() {
        ProblemsTreeModel problemsTreeModel = this.myTreeModel;
        if (problemsTreeModel == null) {
            ProblemsViewPanel.$$$reportNull$$$0(9);
        }
        return problemsTreeModel;
    }

    @NotNull
    public final Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            ProblemsViewPanel.$$$reportNull$$$0(10);
        }
        return tree;
    }

    @Nullable
    final Editor getPreview() {
        return this.myPreview.editor();
    }

    @Nullable
    TreeExpander getTreeExpander() {
        return this.myTreeExpander;
    }

    void orientationChangedTo(boolean vertical) {
        this.setOrientation(vertical);
        this.myPanel.remove(this.myToolbar.getComponent());
        this.myToolbar.setOrientation(vertical ? 0 : 1);
        this.myToolbarInsets.right = !vertical ? JBUIScale.scale(1) : 0;
        this.myToolbarInsets.bottom = vertical ? JBUIScale.scale(1) : 0;
        this.myPanel.add(vertical ? "North" : "West", this.myToolbar.getComponent());
        this.updatePreview();
    }

    void selectionChangedTo(boolean selected) {
        if (selected) {
            this.myTreeModel.setComparator(this.createComparator());
            this.updatePreview();
            ToolWindow window = ProblemsView.getToolWindow(this.getProject());
            if (window instanceof ToolWindowEx) {
                ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("ProblemsView.ToolWindow.SecondaryActions");
                window.setAdditionalGearActions(group);
            }
        }
        this.visibilityChangedTo(selected);
    }

    void visibilityChangedTo(boolean visible) {
        if (visible) {
            this.myShowTime.set(System.nanoTime());
            ProblemsViewStatsCollector.tabShown(this);
        } else {
            Long time = this.myShowTime.getAndSet(null);
            if (time != null) {
                ProblemsViewStatsCollector.tabHidden(this, System.nanoTime() - time);
            }
            IntentionsUI.getInstance(this.getProject()).hide();
        }
    }

    @Override
    @NotNull
    @NonNls
    public String getTabId() {
        String string2 = this.myId;
        if (string2 == null) {
            ProblemsViewPanel.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Nullable
    private static Node getNode(@Nullable TreePath path2) {
        return (Node)((Object)TreeUtil.getLastUserObject(Node.class, (TreePath)path2));
    }

    @Nullable
    private Node getSelectedNode() {
        return ProblemsViewPanel.getNode(this.getTree().getSelectionPath());
    }

    @Nullable
    VirtualFile getSelectedFile() {
        Node node2 = this.getSelectedNode();
        return node2 == null ? null : node2.getVirtualFile();
    }

    private boolean isActiveTab() {
        ToolWindow window = ProblemsView.getToolWindow(this.getProject());
        if (window == null || !window.isActive()) {
            return false;
        }
        Content content2 = window.getContentManager().getSelectedContent();
        if (content2 == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom((Component)((Object)this), content2.getComponent());
    }

    private void updateAutoscroll() {
        if (this.isActiveTab() && (ProblemsViewPanel.isNotNullAndSelected(this.getAutoscrollToSource()) || ProblemsViewPanel.isNotNullAndSelected(this.getOpenInPreviewTab()))) {
            this.invokeLater(() -> {
                Navigatable navigatable;
                Node node2 = this.getSelectedNode();
                Navigatable navigatable2 = navigatable = node2 == null ? null : node2.getNavigatable();
                if (navigatable != null && navigatable.canNavigateToSource()) {
                    try (AccessToken ignored = ClientId.withClientId(this.myClientId);){
                        OpenSourceUtil.navigate((boolean)false, (Navigatable[])new Navigatable[]{navigatable});
                    }
                }
            });
        }
    }

    protected void updatePreview() {
        Node node2 = ProblemsViewPanel.isNotNullAndSelected(this.getShowPreview()) ? this.getSelectedNode() : null;
        this.myPreview.open(node2 == null ? null : node2.getDescriptor());
    }

    private void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            ProblemsViewPanel.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent((Component)((Object)this)));
    }

    protected String getPopupHandlerGroupId() {
        return "ProblemsView.ToolWindow.TreePopup";
    }

    protected String getToolbarActionGroupId() {
        return "ProblemsView.ToolWindow.Toolbar";
    }

    protected ActionToolbar getToolbar() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction(this.getToolbarActionGroupId());
        return ActionManager.getInstance().createActionToolbar(this.getClass().getName(), group, false);
    }

    @NotNull
    protected Comparator<Node> createComparator() {
        return new NodeComparator(ProblemsViewPanel.isNullableOrSelected(this.getSortFoldersFirst()), ProblemsViewPanel.isNullableOrSelected(this.getSortBySeverity()), ProblemsViewPanel.isNotNullAndSelected(this.getSortByName()));
    }

    @Nullable
    ToggleOptionAction.Option getAutoscrollToSource() {
        return ProblemsViewPanel.isNotNullAndSelected(this.getShowPreview()) ? null : this.myAutoscrollToSource;
    }

    @Nullable
    ToggleOptionAction.Option getOpenInPreviewTab() {
        return ProblemsViewPanel.isNotNullAndSelected(this.getShowPreview()) ? null : this.myOpenInPreviewTab;
    }

    @Nullable
    public ToggleOptionAction.Option getShowPreview() {
        return this.myShowPreview;
    }

    @Nullable
    ToggleOptionAction.Option getGroupByToolId() {
        return this instanceof HighlightingPanel ? this.myGroupByToolId : null;
    }

    @Nullable
    ToggleOptionAction.Option getSortFoldersFirst() {
        return null;
    }

    @Nullable
    ToggleOptionAction.Option getSortBySeverity() {
        return this instanceof HighlightingPanel ? this.mySortBySeverity : null;
    }

    @Nullable
    ToggleOptionAction.Option getSortByName() {
        return this.mySortByName;
    }

    private static boolean isNotNullAndSelected(@Nullable ToggleOptionAction.Option option) {
        return option != null && option.isSelected();
    }

    private static boolean isNullableOrSelected(@Nullable ToggleOptionAction.Option option) {
        return option == null || option.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

