/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleMainPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleConfigurableWrapper
implements SearchableConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
OptionsContainingConfigurable {
    private boolean myInitialResetInvoked;
    protected CodeStyleMainPanel myPanel;
    private final CodeStyleSettingsProvider myProvider;
    private final CodeStyleSettingsPanelFactory myFactory;
    private final CodeStyleSchemesConfigurable myOwner;

    public CodeStyleConfigurableWrapper(@NotNull CodeStyleSettingsProvider provider2, @NotNull CodeStyleSettingsPanelFactory factory2, CodeStyleSchemesConfigurable owner) {
        if (provider2 == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(0);
        }
        if (factory2 == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(1);
        }
        this.myProvider = provider2;
        this.myFactory = factory2;
        this.myOwner = owner;
        this.myInitialResetInvoked = false;
    }

    @Nls
    public String getDisplayName() {
        String displayName = this.myProvider.getConfigurableDisplayName();
        if (displayName != null) {
            return displayName;
        }
        return this.myPanel != null ? this.myPanel.getDisplayName() : null;
    }

    public String getHelpTopic() {
        return this.myPanel != null ? this.myPanel.getHelpTopic() : null;
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new CodeStyleMainPanel(this.myOwner.getModel(), this.myFactory, this.canBeShared());
        }
        return this.myPanel;
    }

    public void setSchemesPanelVisible(boolean isVisible) {
        if (this.myPanel != null) {
            this.myPanel.setSchemesPanelVisible(isVisible);
        }
    }

    protected boolean canBeShared() {
        return true;
    }

    public boolean isModified() {
        if (this.myPanel != null) {
            boolean someSchemeModified = this.myPanel.isModified();
            if (someSchemeModified) {
                this.myOwner.resetCompleted();
            }
            return someSchemeModified;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.myOwner.apply();
    }

    public void resetPanel() {
        if (this.myPanel != null) {
            this.myPanel.reset();
        }
    }

    public String toString() {
        return this.myProvider.getClass().getName();
    }

    public void reset() {
        if (!this.myInitialResetInvoked) {
            try {
                this.myOwner.resetFromChild();
            }
            finally {
                this.myInitialResetInvoked = true;
            }
        } else {
            this.myOwner.revert();
        }
    }

    @NotNull
    public String getId() {
        return CodeStyleConfigurableWrapper.getConfigurableId(this.getDisplayName());
    }

    @NotNull
    public Class<?> getOriginalClass() {
        Class<?> clazz = this.myProvider.getClass();
        if (clazz == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            this.myPanel.disposeUIResources();
        }
    }

    public boolean isPanelModified() {
        return this.myPanel != null && this.myPanel.isModified();
    }

    public void applyPanel() throws ConfigurationException {
        if (this.myPanel != null) {
            this.myPanel.apply();
        }
    }

    @NotNull
    public Set<String> processListOptions() {
        Set set2 = this.getOptionIndexer().processListOptions();
        if (set2 == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    public Map<String, Set<String>> processListOptionsWithPaths() {
        Map map2 = this.getOptionIndexer().processListOptionsWithPaths();
        if (map2 == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @NotNull
    private OptionsContainingConfigurable getOptionIndexer() {
        if (this.myPanel == null) {
            this.myPanel = new CodeStyleMainPanel(this.myOwner.getModel(), this.myFactory, this.canBeShared());
        }
        OptionsContainingConfigurable optionsContainingConfigurable = this.myPanel.getOptionIndexer();
        if (optionsContainingConfigurable == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(5);
        }
        return optionsContainingConfigurable;
    }

    public void selectTab(@NotNull String tab) {
        if (tab == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(6);
        }
        this.createComponent();
        this.myPanel.showTabOnCurrentPanel(tab);
    }

    @NotNull
    public static String getConfigurableId(String configurableDisplayName) {
        String string2 = "preferences.sourceCode." + configurableDisplayName;
        if (string2 == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return this.myPanel != null ? () -> this.myPanel.highlightOptions(option) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleConfigurableWrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleConfigurableWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processListOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processListOptionsWithPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionIndexer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectTab";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

