/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroExpandableProtocolBean;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> myPathsIndex;
    private final Map<String, String> myMacroMap;
    public static final String[] PROTOCOLS;

    public ReplacePathToMacroMap() {
        this.myPathsIndex = null;
        this.myMacroMap = new LinkedHashMap<String, String>();
    }

    public ReplacePathToMacroMap(@NotNull ReplacePathToMacroMap map2) {
        if (map2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(0);
        }
        this.myPathsIndex = null;
        this.myMacroMap = new LinkedHashMap<String, String>();
        this.myMacroMap.putAll(map2.myMacroMap);
    }

    public void addMacroReplacement(String path2, String macroName) {
        this.addReplacement(FileUtilRt.toSystemIndependentName(path2), "$" + macroName + "$", true);
    }

    public void addReplacement(String path2, String macroExpr, boolean overwrite) {
        path2 = Strings.trimEnd(path2, "/");
        this.putIfAbsent(path2, macroExpr, overwrite);
        for (String protocol : PROTOCOLS) {
            this.putIfAbsent(protocol + ":" + path2, protocol + ":" + macroExpr, overwrite);
            this.putIfAbsent(protocol + ":/" + path2, protocol + ":/" + macroExpr, overwrite);
            this.putIfAbsent(protocol + "://" + path2, protocol + "://" + macroExpr, overwrite);
        }
    }

    private void putIfAbsent(String path2, String substitution, boolean overwrite) {
        if (overwrite || !this.myMacroMap.containsKey(path2)) {
            this.myMacroMap.put(path2, substitution);
        }
    }

    @NotNull
    public String substitute(@NotNull String text2, boolean caseSensitive) {
        if (text2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(1);
        }
        for (String path2 : this.getPathIndex()) {
            text2 = this.replacePathMacro(text2, path2, caseSensitive);
        }
        String string2 = text2;
        if (string2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    private String replacePathMacro(@NotNull String text2, @NotNull String path2, boolean caseSensitive) {
        if (text2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(3);
        }
        if (path2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(4);
        }
        if (text2.length() < path2.length() || path2.isEmpty()) {
            String string2 = text2;
            if (string2 == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(5);
            }
            return string2;
        }
        if (!(!caseSensitive ? StringUtilRt.startsWithIgnoreCase(text2, path2) : text2.startsWith(path2))) {
            String string3 = text2;
            if (string3 == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(6);
            }
            return string3;
        }
        int endOfOccurrence = path2.length();
        boolean isWindowsRoot = path2.endsWith(":/");
        if (!(isWindowsRoot || endOfOccurrence >= text2.length() || text2.charAt(endOfOccurrence) == '/' || text2.charAt(endOfOccurrence) == '!' && text2.substring(endOfOccurrence).startsWith("!/"))) {
            String string4 = text2;
            if (string4 == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(7);
            }
            return string4;
        }
        String s = this.myMacroMap.get(path2);
        if (text2.length() > endOfOccurrence) {
            String string5 = s + text2.substring(endOfOccurrence);
            if (string5 == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(8);
            }
            return string5;
        }
        String string6 = s;
        if (string6 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(9);
        }
        return string6;
    }

    @NotNull
    public CharSequence substituteRecursively(@NotNull String text2, boolean caseSensitive) {
        if (text2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(10);
        }
        CharSequence result2 = text2;
        for (String path2 : this.getPathIndex()) {
            result2 = this.replacePathMacroRecursively(result2, path2, caseSensitive);
        }
        String string2 = result2;
        if (string2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(11);
        }
        return string2;
    }

    private CharSequence replacePathMacroRecursively(@NotNull CharSequence text2, @NotNull String path2, boolean caseSensitive) {
        if (text2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(12);
        }
        if (path2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(13);
        }
        if (text2.length() < path2.length() || path2.isEmpty()) {
            return text2;
        }
        StringBuilder newText = new StringBuilder();
        boolean isWindowsRoot = path2.endsWith(":/");
        int i = 0;
        while (i < text2.length()) {
            int occurrenceOfPath;
            int n = occurrenceOfPath = caseSensitive ? Strings.indexOf(text2, path2, i) : Strings.indexOfIgnoreCase(text2, (CharSequence)path2, i);
            if (occurrenceOfPath >= 0) {
                char prev;
                int endOfOccurrence = occurrenceOfPath + path2.length();
                if (!isWindowsRoot && endOfOccurrence < text2.length() && text2.charAt(endOfOccurrence) != '/' && text2.charAt(endOfOccurrence) != '\"' && text2.charAt(endOfOccurrence) != ' ' && !Strings.startsWith(text2, endOfOccurrence, "!/")) {
                    newText.append(text2, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
                if (occurrenceOfPath > 0 && (Character.isLetterOrDigit(prev = text2.charAt(occurrenceOfPath - 1)) || prev == '_')) {
                    newText.append(text2, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
            }
            if (occurrenceOfPath < 0) {
                if (newText.length() == 0) {
                    return text2;
                }
                newText.append(text2, i, text2.length());
                break;
            }
            newText.append(text2, i, occurrenceOfPath);
            newText.append(this.myMacroMap.get(path2));
            i = occurrenceOfPath + path2.length();
        }
        return newText;
    }

    private static int getIndex(@NotNull String replacement) {
        if (replacement == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(14);
        }
        if (replacement.contains("..") || replacement.contains("$USER_HOME$") || replacement.contains("$APPLICATION_HOME_DIR$") || replacement.contains("$MAVEN_REPOSITORY$")) {
            return 1;
        }
        if (replacement.contains("$MODULE_DIR$") || replacement.contains("$PROJECT_DIR$")) {
            return 3;
        }
        return 2;
    }

    private static int stripPrefix(@NotNull String key) {
        if (key == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(15);
        }
        key = StringUtil.trimStart(key, "jar:");
        key = StringUtil.trimStart(key, "file:");
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        return key.length();
    }

    @NotNull
    private List<String> getPathIndex() {
        if (this.myPathsIndex != null && this.myPathsIndex.size() == this.myMacroMap.size()) {
            List<String> list2 = this.myPathsIndex;
            if (list2 == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(16);
            }
            return list2;
        }
        ArrayList<Map.Entry<String, String>> entries2 = new ArrayList<Map.Entry<String, String>>(this.myMacroMap.entrySet());
        Object2IntOpenHashMap<String> weights = new Object2IntOpenHashMap<String>(entries2.size());
        for (Map.Entry entry2 : entries2) {
            weights.put((String)entry2.getKey(), ReplacePathToMacroMap.getIndex((String)entry2.getValue()) * 512 + ReplacePathToMacroMap.stripPrefix((String)entry2.getKey()));
        }
        entries2.sort((o1, o2) -> weights.getInt(o2.getKey()) - weights.getInt(o1.getKey()));
        List<String> list3 = this.myPathsIndex = ContainerUtil.map2List(entries2, entry -> (String)entry.getKey());
        if (list3 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(17);
        }
        return list3;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return this.myMacroMap.equals(((ReplacePathToMacroMap)((Object)obj)).myMacroMap);
    }

    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    public void put(String path2, String replacement) {
        this.myMacroMap.put(path2, replacement);
    }

    public String toString() {
        return "macroMap: " + this.myMacroMap + "\n\npathsIndex: " + StringUtil.join(this.myPathsIndex, "\n");
    }

    static {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("file");
        protocols.add("jar");
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(PathMacroExpandableProtocolBean.EP_NAME)) {
            PathMacroExpandableProtocolBean.EP_NAME.forEachExtensionSafe(bean -> protocols.add(bean.protocol));
        }
        PROTOCOLS = ArrayUtilRt.toStringArray(protocols);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "replacePathMacro";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteRecursively";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacro";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "substituteRecursively";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacroRecursively";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefix";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

