/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesActions;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesPanel
extends SimpleSchemesPanel<CodeStyleScheme> {
    private final CodeStyleSchemesModel myModel;
    private boolean myIsReset;
    private JLabel myBottomLabel;
    private JPanel myBottomPanel;

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model2, int vGap) {
        super(vGap);
        this.myModel = model2;
    }

    CodeStyleSchemesPanel(CodeStyleSchemesModel model2) {
        super(8);
        this.myModel = model2;
        this.showOverridingMessage(this.myModel.getOverridingStatus());
    }

    private void onCombo() {
        CodeStyleScheme selected = (CodeStyleScheme)this.getSelectedScheme();
        if (selected != null) {
            this.myModel.selectScheme(selected, (Object)this);
        }
    }

    public void resetSchemesCombo() {
        this.myIsReset = true;
        try {
            ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>(this.myModel.getAllSortedSchemes());
            this.resetSchemes(schemes);
            this.selectScheme((Scheme)this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void onSelectedSchemeChanged() {
        this.myIsReset = true;
        try {
            this.selectScheme((Scheme)this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    @NotNull
    protected AbstractSchemeActions<CodeStyleScheme> createSchemeActions() {
        return new CodeStyleSchemesActions((AbstractSchemesPanel)this){

            protected void onSchemeChanged(@Nullable CodeStyleScheme scheme) {
                if (!CodeStyleSchemesPanel.this.myIsReset) {
                    ApplicationManager.getApplication().invokeLater(() -> CodeStyleSchemesPanel.this.onCombo());
                }
            }

            protected void renameScheme(@NotNull CodeStyleScheme scheme, @NotNull String newName2) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newName2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                CodeStyleSchemeImpl newScheme = new CodeStyleSchemeImpl(newName2, false, scheme);
                CodeStyleSchemesPanel.this.myModel.addScheme(newScheme, false);
                CodeStyleSchemesPanel.this.myModel.removeScheme(scheme);
                CodeStyleSchemesPanel.this.myModel.selectScheme(newScheme, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel$1";
                objectArray[2] = "renameScheme";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public SchemesModel<CodeStyleScheme> getModel() {
        CodeStyleSchemesModel codeStyleSchemesModel = this.myModel;
        if (codeStyleSchemesModel == null) {
            CodeStyleSchemesPanel.$$$reportNull$$$0(0);
        }
        return codeStyleSchemesModel;
    }

    protected boolean supportsProjectSchemes() {
        return true;
    }

    protected boolean highlightNonDefaultSchemes() {
        return true;
    }

    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    @Nullable
    protected JComponent createBottomComponent() {
        this.myBottomPanel = new JPanel(new FlowLayout(0));
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(AllIcons.General.Warning);
        this.myBottomPanel.add(iconLabel);
        this.myBottomPanel.add(Box.createRigidArea(new JBDimension(5, 0)));
        this.myBottomLabel = new JLabel();
        this.myBottomPanel.add(this.myBottomLabel);
        ActionLink disableHyperLink = new ActionLink(LangBundle.message("action.link.disable", new Object[0]), e -> this.disableOverriding());
        this.myBottomPanel.add((Component)disableHyperLink);
        this.myBottomPanel.setVisible(false);
        return this.myBottomPanel;
    }

    private void disableOverriding() {
        CodeStyleSchemesModel.OverridingStatus status = this.myModel.getOverridingStatus();
        if (status != null) {
            CodeStyleScheme currScheme = (CodeStyleScheme)this.getSelectedScheme();
            CodeStyleSettings currSettings = currScheme.getCodeStyleSettings();
            CodeStyleSettings modelSettings = this.myModel.getCloneSettings(currScheme);
            for (CodeStyleSettingsModifier modifier : status.getModifiers()) {
                Consumer disablingFunction = modifier.getDisablingFunction();
                if (disablingFunction == null) continue;
                disablingFunction.accept(currSettings);
                CodeStyleSettingsManager.getInstance((Project)this.myModel.getProject()).notifyCodeStyleSettingsChanged();
                disablingFunction.accept(modelSettings);
            }
            this.myModel.updateOverridingStatus();
            this.myModel.fireModelSettingsChanged(modelSettings);
        } else {
            this.myBottomPanel.setVisible(false);
        }
    }

    public final void updateOverridingMessage() {
        this.showOverridingMessage(this.myModel.getOverridingStatus());
    }

    private void showOverridingMessage(@Nullable CodeStyleSchemesModel.OverridingStatus overridingStatus) {
        if (overridingStatus != null) {
            CodeStyleSettingsModifier[] modifiers = overridingStatus.getModifiers();
            this.myBottomLabel.setText(CodeStyleSchemesPanel.getMessage(modifiers));
            this.myBottomPanel.setVisible(true);
            return;
        }
        this.myBottomPanel.setVisible(false);
    }

    @NlsContexts.Label
    private static String getMessage(CodeStyleSettingsModifier @NotNull [] modifiers) {
        if (modifiers == null) {
            CodeStyleSchemesPanel.$$$reportNull$$$0(1);
        }
        StringBuilder modifiersListBuilder = new StringBuilder();
        boolean isList = false;
        for (CodeStyleSettingsModifier modifier : modifiers) {
            if (isList) {
                modifiersListBuilder.append(", ");
            }
            modifiersListBuilder.append(modifier.getName());
            isList = true;
        }
        return CodeInsightBundle.message("code.style.possibly.overridden.message", modifiersListBuilder.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

