/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.group;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.group.ArrangementGroupingComponent;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementRepresentationAware;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementGroupingRulesControl
extends JBTable {
    @NotNull
    public static final DataKey<ArrangementGroupingRulesControl> KEY = DataKey.create((String)"Arrangement.Rule.Group.Control");
    @NotNull
    private final Map<ArrangementSettingsToken, ArrangementGroupingComponent> myComponents;
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;

    public ArrangementGroupingRulesControl(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider) {
        if (settingsManager == null) {
            ArrangementGroupingRulesControl.$$$reportNull$$$0(0);
        }
        if (colorsProvider == null) {
            ArrangementGroupingRulesControl.$$$reportNull$$$0(1);
        }
        super((TableModel)new DefaultTableModel(0, 1));
        this.myComponents = new HashMap<ArrangementSettingsToken, ArrangementGroupingComponent>();
        this.mySettingsManager = settingsManager;
        this.setDefaultRenderer(Object.class, new MyRenderer());
        this.getColumnModel().getColumn(0).setCellEditor(new MyEditor());
        this.setShowColumns(false);
        this.setShowGrid(false);
        this.setBorder(IdeBorderFactory.createBorder());
        this.setSelectionMode(0);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        List<CompositeArrangementSettingsToken> groupingTokens = settingsManager.getSupportedGroupingTokens();
        if (groupingTokens != null) {
            for (CompositeArrangementSettingsToken token : groupingTokens) {
                ArrangementGroupingComponent component2 = new ArrangementGroupingComponent(token, colorsProvider, settingsManager);
                this.myComponents.put(token.getToken(), component2);
                this.getModel().addRow(new Object[]{component2});
            }
        }
    }

    public DefaultTableModel getModel() {
        return (DefaultTableModel)super.getModel();
    }

    public void setRules(@Nullable List<? extends ArrangementGroupingRule> rules) {
        for (ArrangementGroupingComponent component2 : this.myComponents.values()) {
            component2.setSelected(false);
        }
        if (rules == null) {
            return;
        }
        DefaultTableModel model2 = this.getModel();
        while (model2.getRowCount() > 0) {
            model2.removeRow(model2.getRowCount() - 1);
        }
        HashSet<ArrangementSettingsToken> groupingTokens = new HashSet<ArrangementSettingsToken>(this.myComponents.keySet());
        for (ArrangementGroupingRule arrangementGroupingRule : rules) {
            ArrangementSettingsToken groupingType = arrangementGroupingRule.getGroupingType();
            ArrangementGroupingComponent component3 = this.myComponents.get(groupingType);
            component3.setSelected(true);
            component3.setOrderType(arrangementGroupingRule.getOrderType());
            model2.addRow(new Object[]{component3});
            groupingTokens.remove(groupingType);
        }
        List<ArrangementSettingsToken> types = new ArrayList<ArrangementSettingsToken>(groupingTokens);
        types = this.mySettingsManager.sort(types);
        for (ArrangementSettingsToken type : types) {
            model2.addRow(new Object[]{this.myComponents.get(type)});
        }
    }

    @NotNull
    public List<ArrangementGroupingRule> getRules() {
        ArrayList<ArrangementGroupingRule> result2 = new ArrayList<ArrangementGroupingRule>();
        DefaultTableModel model2 = this.getModel();
        int max = model2.getRowCount();
        for (int i = 0; i < max; ++i) {
            ArrangementGroupingComponent component2 = (ArrangementGroupingComponent)model2.getValueAt(i, 0);
            if (!component2.isSelected()) continue;
            ArrangementSettingsToken orderType = component2.getOrderType();
            if (orderType == null) {
                result2.add(new ArrangementGroupingRule(component2.getGroupingType()));
                continue;
            }
            result2.add(new ArrangementGroupingRule(component2.getGroupingType(), orderType));
        }
        ArrayList<ArrangementGroupingRule> arrayList = result2;
        if (arrayList == null) {
            ArrangementGroupingRulesControl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingRulesControl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingRulesControl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEditor
    extends AbstractTableCellEditor {
        @Nullable
        Object myValue;

        private MyEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof ArrangementEditorAware) {
                this.myValue = value;
                return ((ArrangementEditorAware)value).getComponent();
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }

        @Override
        public boolean stopCellEditing() {
            super.stopCellEditing();
            this.myValue = null;
            return true;
        }
    }

    private static class MyRenderer
    implements TableCellRenderer {
        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof ArrangementGroupingComponent) {
                ArrangementGroupingComponent component2 = (ArrangementGroupingComponent)value;
                component2.setRowIndex(row + 1);
                component2.setHighlight(TableHoverListener.getHoveredRow((JTable)table) == row || table.isRowSelected(row));
                component2.revalidate();
                return component2;
            }
            if (value instanceof ArrangementRepresentationAware) {
                return ((ArrangementRepresentationAware)value).getComponent();
            }
            return null;
        }
    }
}

