/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditorBase;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.VisualGuidesAccessor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class LanguageCodeStylePropertyMapper
extends AbstractCodeStylePropertyMapper {
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final String myLanguageDomainId;
    @Nullable
    private final LanguageCodeStyleSettingsProvider mySettingsProvider;
    @NotNull
    private final List<CustomCodeStyleSettings> myCustomSettings;

    public LanguageCodeStylePropertyMapper(@NotNull CodeStyleSettings settings, @NotNull Language language, @Nullable String languageDomainId) {
        if (settings == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(0);
        }
        if (language == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(1);
        }
        super(settings);
        this.myLanguage = language;
        this.myLanguageDomainId = languageDomainId == null ? StringUtil.toLowerCase(this.myLanguage.getID()) : languageDomainId;
        this.mySettingsProvider = LanguageCodeStyleSettingsProvider.forLanguage(language);
        this.myCustomSettings = this.getCustomSettings();
    }

    @Override
    @Nullable
    protected CodeStylePropertyAccessor<?> getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        CodeStyleFieldAccessor accessor;
        if (codeStyleObject == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(2);
        }
        if (field == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(3);
        }
        CodeStyleFieldAccessor codeStyleFieldAccessor = accessor = this.mySettingsProvider != null ? this.mySettingsProvider.getAccessor(codeStyleObject, field) : null;
        if (accessor != null) {
            return accessor;
        }
        return super.getAccessor(codeStyleObject, field);
    }

    @Override
    protected void addAdditionalAccessors(@NotNull Map<String, CodeStylePropertyAccessor<?>> accessorMap) {
        if (accessorMap == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(4);
        }
        accessorMap.put("visual_guides", new VisualGuidesAccessor(this.getRootSettings(), this.myLanguage));
        if (this.mySettingsProvider != null) {
            for (CustomCodeStyleSettings customSettings : this.myCustomSettings) {
                for (CodeStylePropertyAccessor accessor : this.mySettingsProvider.getAdditionalAccessors(customSettings)) {
                    accessorMap.put(accessor.getPropertyName(), accessor);
                }
            }
        }
    }

    @Override
    @NotNull
    protected List<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> getSupportedFields() {
        ArrayList<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> fieldsDescriptors = new ArrayList<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor>();
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getRootSettings().getCommonSettings(this.myLanguage).getIndentOptions();
        if (indentOptions != null) {
            fieldsDescriptors.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor(indentOptions, this.getSupportedIndentOptions()));
        }
        fieldsDescriptors.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor(this.getRootSettings().getCommonSettings(this.myLanguage), this.getSupportedLanguageFields()));
        for (CustomCodeStyleSettings customSettings : this.myCustomSettings) {
            fieldsDescriptors.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor(customSettings, null));
        }
        ArrayList<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> arrayList = fieldsDescriptors;
        if (arrayList == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(6);
        }
        return language;
    }

    @Override
    @NotNull
    public String getLanguageDomainId() {
        String string2 = this.myLanguageDomainId;
        if (string2 == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private List<CustomCodeStyleSettings> getCustomSettings() {
        ArrayList<CustomCodeStyleSettings> customSettingsList = new ArrayList<CustomCodeStyleSettings>();
        this.addCustomSettings(customSettingsList, this.getRootSettings(), CodeStyleSettingsProvider.EXTENSION_POINT_NAME.getExtensionList());
        this.addCustomSettings(customSettingsList, this.getRootSettings(), new ArrayList<LanguageCodeStyleSettingsProvider>(LanguageCodeStyleSettingsProvider.getSettingsPagesProviders()));
        return customSettingsList;
    }

    private void addCustomSettings(@NotNull List<? super CustomCodeStyleSettings> list2, @NotNull CodeStyleSettings rootSettings, @NotNull List<? extends CodeStyleSettingsProvider> providerList) {
        if (list2 == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(8);
        }
        if (rootSettings == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(9);
        }
        if (providerList == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(10);
        }
        for (CodeStyleSettingsProvider codeStyleSettingsProvider : providerList) {
            CustomCodeStyleSettings customSettingsTemplate;
            if (codeStyleSettingsProvider.getLanguage() != this.myLanguage || !LanguageCodeStylePropertyMapper.isEnabled(codeStyleSettingsProvider) || (customSettingsTemplate = codeStyleSettingsProvider.createCustomSettings(rootSettings)) == null) continue;
            CustomCodeStyleSettings customSettings = rootSettings.getCustomSettings(customSettingsTemplate.getClass());
            list2.add((CustomCodeStyleSettings)customSettings);
        }
    }

    private static boolean isEnabled(@NotNull CodeStyleSettingsProvider provider2) {
        if (provider2 == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(11);
        }
        return !ApplicationManager.getApplication().isUnitTestMode() || provider2.hasSettingsPage();
    }

    private Set<String> getSupportedIndentOptions() {
        IndentOptionsEditor editor2;
        LanguageCodeStyleSettingsProvider provider2 = LanguageCodeStyleSettingsProvider.forLanguage(this.myLanguage);
        if (provider2 == null) {
            return Collections.emptySet();
        }
        HashSet<String> indentOptions = new HashSet<String>(provider2.getSupportedFields(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS));
        if (indentOptions.isEmpty() && (editor2 = provider2.getIndentOptionsEditor()) != null) {
            indentOptions.add("TAB_SIZE");
            indentOptions.add("USE_TAB_CHARACTER");
            indentOptions.add("INDENT_SIZE");
            if (editor2 instanceof SmartIndentOptionsEditorBase) {
                indentOptions.add("CONTINUATION_INDENT_SIZE");
                indentOptions.add("SMART_TABS");
                indentOptions.add("KEEP_INDENTS_ON_EMPTY_LINES");
            }
        }
        return indentOptions;
    }

    private Set<String> getSupportedLanguageFields() {
        return this.mySettingsProvider == null ? Collections.emptySet() : this.mySettingsProvider.getSupportedFields();
    }

    @Override
    @Nullable
    public String getPropertyDescription(@NotNull String externalName) {
        String key;
        if (externalName == null) {
            LanguageCodeStylePropertyMapper.$$$reportNull$$$0(12);
        }
        return OptionsBundle.INSTANCE.containsKey(key = "codestyle.property.description." + externalName) ? OptionsBundle.message((String)key, (Object[])new Object[0]) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorMap";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/properties/LanguageCodeStylePropertyMapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/properties/LanguageCodeStylePropertyMapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFields";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageDomainId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalAccessors";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addCustomSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescription";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

