/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.ComponentOrientation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildContentManagerImpl
implements BuildContentManager,
Disposable {
    public static final Supplier<@NlsContexts.TabTitle String> BUILD_TAB_TITLE_SUPPLIER = LangBundle.messagePointer("tab.title.build", new Object[0]);
    private static final BadgeIconSupplier TW_ICON = new BadgeIconSupplier(AllIcons.Toolwindows.ToolWindowBuild);
    private static final List<Supplier<@NlsContexts.TabTitle String>> presetOrder = List.of(LangBundle.messagePointer("tab.title.sync", new Object[0]), BUILD_TAB_TITLE_SUPPLIER, LangBundle.messagePointer("tab.title.run", new Object[0]), LangBundle.messagePointer("tab.title.debug", new Object[0]));
    private static final Key<Map<Object, CloseListener>> CONTENT_CLOSE_LISTENERS = Key.create("CONTENT_CLOSE_LISTENERS");
    private final Project project;
    private final Map<Content, Pair<Icon, AtomicInteger>> liveContentsMap;

    public BuildContentManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(0);
        }
        this.liveContentsMap = new ConcurrentHashMap<Content, Pair<Icon, AtomicInteger>>();
        this.project = project2;
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public ToolWindow getOrCreateToolWindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Build");
        if (toolWindow != null) {
            ToolWindow toolWindow2 = toolWindow;
            if (toolWindow2 == null) {
                BuildContentManagerImpl.$$$reportNull$$$0(1);
            }
            return toolWindow2;
        }
        toolWindow = toolWindowManager.registerToolWindow("Build", builder2 -> {
            builder2.stripeTitle = UIBundle.messagePointer((String)"tool.window.name.build", (Object[])new Object[0]);
            builder2.icon = TW_ICON.getOriginalIcon();
            return Unit.INSTANCE;
        });
        toolWindow.setToHideOnEmptyContent(true);
        ToolWindow toolWindow3 = toolWindow;
        if (toolWindow3 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(2);
        }
        return toolWindow3;
    }

    private void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(3);
        }
        if (this.project.isDefault()) {
            return;
        }
        StartupManagerEx.getInstanceEx((Project)this.project).runAfterOpened(() -> ModalityUiUtil.invokeLaterIfNeeded(ModalityState.defaultModalityState(), this.project.getDisposed(), runnable));
    }

    public void addContent(@NotNull Content content2) {
        if (content2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(4);
        }
        this.invokeLaterIfNeeded(() -> {
            ContentManager contentManager = this.getOrCreateToolWindow().getContentManager();
            String name2 = content2.getTabName();
            String category = Strings.trimEnd(StringUtil.split(name2, " ").get(0), ':');
            int index = -1;
            for (int i = 0; i < presetOrder.size(); ++i) {
                String s = presetOrder.get(i).get();
                if (!s.equals(category)) continue;
                index = i;
                break;
            }
            Content[] existingContents = contentManager.getContents();
            if (index != -1) {
                MultiMap<String, String> existingCategoriesNames = new MultiMap<String, String>();
                Content[] contentArray = existingContents;
                int n = contentArray.length;
                for (int i = 0; i < n; ++i) {
                    Content existingContent = contentArray[i];
                    String tabName = existingContent.getTabName();
                    existingCategoriesNames.putValue(Strings.trimEnd(StringUtil.split(tabName, " ").get(0), ':'), tabName);
                }
                int place = 0;
                for (int i = 0; i <= index; ++i) {
                    String key = presetOrder.get(i).get();
                    place += existingCategoriesNames.get(key).size();
                }
                contentManager.addContent(content2, place);
            } else {
                contentManager.addContent(content2);
            }
            for (Content existingContent : existingContents) {
                existingContent.setDisplayName(existingContent.getTabName());
            }
            this.updateTabDisplayName(content2, content2.getTabName());
        });
    }

    public void updateTabDisplayName(Content content2, @NlsContexts.TabTitle String tabName) {
        this.invokeLaterIfNeeded(() -> {
            if (!tabName.equals(content2.getDisplayName())) {
                content2.setTabName(tabName);
                content2.setDisplayName(tabName);
            }
        });
    }

    public void removeContent(Content content2) {
        this.invokeLaterIfNeeded(() -> {
            ContentManager contentManager;
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow("Build");
            ContentManager contentManager2 = contentManager = toolWindow == null ? null : toolWindow.getContentManager();
            if (contentManager != null && !contentManager.isDisposed()) {
                contentManager.removeContent(content2, true);
            }
        });
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus, boolean forcedFocus, boolean activate, @Nullable Runnable activationCallback) {
        if (content2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(5);
        }
        this.invokeLaterIfNeeded(() -> {
            ToolWindow toolWindow = this.getOrCreateToolWindow();
            if (!toolWindow.isAvailable()) {
                return;
            }
            if (activate) {
                toolWindow.show(activationCallback);
            }
            toolWindow.getContentManager().setSelectedContent(content2, requestFocus, forcedFocus, false);
        });
    }

    public void startBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content2, @Nullable BuildProcessHandler processHandler) {
        if (buildDescriptor == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(6);
        }
        if (content2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(7);
        }
        if (processHandler != null) {
            HashMap<Object, CloseListener> closeListenerMap = (HashMap<Object, CloseListener>)content2.getUserData(CONTENT_CLOSE_LISTENERS);
            if (closeListenerMap == null) {
                closeListenerMap = new HashMap<Object, CloseListener>();
                content2.putUserData(CONTENT_CLOSE_LISTENERS, closeListenerMap);
            }
            closeListenerMap.put(buildDescriptor.getId(), new CloseListener(this, content2, processHandler));
        }
        Pair pair = this.liveContentsMap.computeIfAbsent(content2, c -> new Pair<Icon, AtomicInteger>(c.getIcon(), new AtomicInteger(0)));
        ((AtomicInteger)pair.second).incrementAndGet();
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        if (pair.first == null) {
            content2.putUserData(Content.TAB_LABEL_ORIENTATION_KEY, (Object)ComponentOrientation.RIGHT_TO_LEFT);
        }
        content2.setIcon(ExecutionUtil.getLiveIndicator((Icon)((Icon)pair.first), (int)0, (int)13));
        this.invokeLaterIfNeeded(() -> {
            JComponent component2 = content2.getComponent();
            component2.invalidate();
            if (!this.liveContentsMap.isEmpty()) {
                this.getOrCreateToolWindow().setIcon(TW_ICON.getLiveIndicatorIcon());
            }
        });
    }

    public void finishBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content2) {
        Pair<Icon, AtomicInteger> pair;
        CloseListener closeListener;
        Map closeListenerMap;
        if (buildDescriptor == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(8);
        }
        if (content2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(9);
        }
        if ((closeListenerMap = (Map)content2.getUserData(CONTENT_CLOSE_LISTENERS)) != null && (closeListener = (CloseListener)((Object)closeListenerMap.remove(buildDescriptor.getId()))) != null) {
            Disposer.dispose((Disposable)((Object)closeListener));
            if (closeListenerMap.isEmpty()) {
                content2.putUserData(CONTENT_CLOSE_LISTENERS, null);
            }
        }
        if ((pair = this.liveContentsMap.get(content2)) != null && ((AtomicInteger)pair.second).decrementAndGet() == 0) {
            content2.setIcon((Icon)pair.first);
            if (pair.first == null) {
                content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.FALSE);
            }
            this.liveContentsMap.remove(content2);
        }
        this.invokeLaterIfNeeded(() -> {
            if (this.liveContentsMap.isEmpty()) {
                this.getOrCreateToolWindow().setIcon(TW_ICON.getOriginalIcon());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildContentManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildContentManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startBuildNotified";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "finishBuildNotified";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CloseListener
    extends BaseContentCloseListener {
        @Nullable
        private BuildProcessHandler myProcessHandler;

        private CloseListener(@NotNull BuildContentManagerImpl buildContentManager, @NotNull Content content2, @NotNull BuildProcessHandler processHandler) {
            if (buildContentManager == null) {
                CloseListener.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                CloseListener.$$$reportNull$$$0(1);
            }
            if (processHandler == null) {
                CloseListener.$$$reportNull$$$0(2);
            }
            super(content2, buildContentManager.project, (Disposable)buildContentManager);
            this.myProcessHandler = processHandler;
        }

        protected void disposeContent(@NotNull Content content2) {
            if (content2 == null) {
                CloseListener.$$$reportNull$$$0(3);
            }
            if (this.myProcessHandler instanceof Disposable) {
                Disposer.dispose((Disposable)((Object)this.myProcessHandler));
            }
            this.myProcessHandler = null;
        }

        protected boolean closeQuery(@NotNull Content content2, boolean modal) {
            if (content2 == null) {
                CloseListener.$$$reportNull$$$0(4);
            }
            if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating()) {
                return true;
            }
            this.myProcessHandler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, Boolean.TRUE);
            String sessionName = this.myProcessHandler.getExecutionName();
            BaseContentCloseListener.WaitForProcessTask task2 = new BaseContentCloseListener.WaitForProcessTask(this.myProcessHandler, sessionName, modal, this.myProject){

                public void onCancel() {
                    myProcessHandler.forceProcessDetach();
                }
            };
            return this.askUserAndWait(this.myProcessHandler, sessionName, task2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildContentManager";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/build/BuildContentManagerImpl$CloseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disposeContent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "closeQuery";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

