/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildConsoleView;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildIssueEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.LazyFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildTextConsoleView
extends ConsoleViewImpl
implements BuildConsoleView,
AnsiEscapeDecoder.ColoredTextAcceptor {
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;

    public BuildTextConsoleView(@NotNull Project project2, boolean viewer, @NotNull List<? extends Filter> executionFilters) {
        if (project2 == null) {
            BuildTextConsoleView.$$$reportNull$$$0(0);
        }
        if (executionFilters == null) {
            BuildTextConsoleView.$$$reportNull$$$0(1);
        }
        super(project2, GlobalSearchScope.allScope(project2), viewer, true);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        executionFilters.forEach(this::addMessageFilter);
    }

    @Override
    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildTextConsoleView.$$$reportNull$$$0(2);
        }
        if (event == null) {
            BuildTextConsoleView.$$$reportNull$$$0(3);
        }
        if (event instanceof BuildIssueEvent) {
            BuildConsoleUtils.print(this, ((BuildIssueEvent)event).getGroup(), ((BuildIssueEvent)event).getIssue());
        } else if (event instanceof FileMessageEvent) {
            boolean isStdOut = ((FileMessageEvent)event).getResult().getKind() != MessageEvent.Kind.ERROR;
            String description = event.getDescription();
            if (description != null) {
                this.append(description, isStdOut);
            } else {
                FilePosition position = ((FileMessageEvent)event).getFilePosition();
                StringBuilder fileLink = new StringBuilder();
                fileLink.append(position.getFile().getName());
                if (position.getStartLine() > 0) {
                    fileLink.append(":").append(position.getStartLine() + 1);
                }
                if (position.getStartColumn() > 0) {
                    fileLink.append(":").append(position.getStartColumn() + 1);
                }
                this.print(fileLink.toString(), ConsoleViewContentType.NORMAL_OUTPUT, new LazyFileHyperlinkInfo(this.getProject(), position.getFile().getPath(), position.getStartLine(), position.getStartColumn()));
                this.print(": ", ConsoleViewContentType.NORMAL_OUTPUT);
                this.append(event.getMessage(), isStdOut);
            }
        } else if (event instanceof MessageEvent) {
            this.appendEventResult(((MessageEvent)event).getResult());
        } else if (event instanceof FinishEvent) {
            this.appendEventResult(((FinishEvent)event).getResult());
        } else if (event instanceof OutputBuildEvent) {
            this.onEvent((OutputBuildEvent)((Object)event));
        } else {
            this.append(ObjectUtils.chooseNotNull(event.getDescription(), event.getMessage()), true);
        }
    }

    public void onEvent(@NotNull OutputBuildEvent event) {
        if (event == null) {
            BuildTextConsoleView.$$$reportNull$$$0(4);
        }
        this.append(event.getMessage(), event.isStdOut());
    }

    public boolean appendEventResult(@Nullable EventResult eventResult) {
        if (eventResult == null) {
            return false;
        }
        boolean hasChanged = false;
        if (eventResult instanceof FailureResult) {
            List<? extends Failure> failures = ((FailureResult)eventResult).getFailures();
            if (failures.isEmpty()) {
                return false;
            }
            Iterator<? extends Failure> iterator = failures.iterator();
            while (iterator.hasNext()) {
                Failure failure = iterator.next();
                if (this.append(failure)) {
                    hasChanged = true;
                }
                if (!iterator.hasNext()) continue;
                this.print("\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
        } else if (eventResult instanceof MessageEventResult) {
            String details2 = ((MessageEventResult)eventResult).getDetails();
            if (details2 == null) {
                return false;
            }
            if (details2.isEmpty()) {
                return false;
            }
            BuildConsoleUtils.printDetails(this, null, details2);
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean append(@NotNull Failure failure) {
        String text2;
        if (failure == null) {
            BuildTextConsoleView.$$$reportNull$$$0(5);
        }
        if ((text2 = ObjectUtils.chooseNotNull(failure.getDescription(), failure.getMessage())) == null && failure.getError() != null) {
            text2 = failure.getError().getMessage();
        }
        if (text2 == null) {
            return false;
        }
        BuildConsoleUtils.printDetails(this, failure, text2);
        return true;
    }

    public void append(@NotNull String text2, boolean isStdOut) {
        if (text2 == null) {
            BuildTextConsoleView.$$$reportNull$$$0(6);
        }
        Key<?> outputType = !isStdOut ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT;
        this.myAnsiEscapeDecoder.escapeText(text2, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    public void coloredTextAvailable(@NotNull String text2, @NotNull Key attributes) {
        if (text2 == null) {
            BuildTextConsoleView.$$$reportNull$$$0(7);
        }
        if (attributes == null) {
            BuildTextConsoleView.$$$reportNull$$$0(8);
        }
        this.print(text2, ConsoleViewContentType.getConsoleViewType((Key)attributes));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionFilters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failure";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/build/BuildTextConsoleView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onEvent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "coloredTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

