/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.HighlightingDuplicate;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildProgressObservable;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/build/BuildViewProblemsService;", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildIdToFileProblems", "", "", "", "Lcom/intellij/build/BuildViewProblemsService$FileBuildProblem;", "getBuildIdToFileProblems", "()Ljava/util/Map;", "getProject", "()Lcom/intellij/openapi/project/Project;", "workingDirToBuildId", "", "getWorkingDirToBuildId", "dispose", "", "listenToBuildView", "buildProgressObservable", "Lcom/intellij/build/BuildProgressObservable;", "BuildProblemsProvider", "FileBuildProblem", "intellij.platform.lang.impl"})
public final class BuildViewProblemsService
implements ProblemsProvider {
    @NotNull
    private final Map<String, Object> workingDirToBuildId;
    @NotNull
    private final Map<Object, Set<FileBuildProblem>> buildIdToFileProblems;
    @NotNull
    private final Project project;

    @Override
    public void dispose() {
        this.buildIdToFileProblems.clear();
        this.workingDirToBuildId.clear();
    }

    @NotNull
    public final Map<String, Object> getWorkingDirToBuildId() {
        return this.workingDirToBuildId;
    }

    @NotNull
    public final Map<Object, Set<FileBuildProblem>> getBuildIdToFileProblems() {
        return this.buildIdToFileProblems;
    }

    public final void listenToBuildView(@NotNull BuildProgressObservable buildProgressObservable) {
        Intrinsics.checkNotNullParameter((Object)buildProgressObservable, (String)"buildProgressObservable");
        Project $this$service$iv = this.getProject();
        boolean $i$f$service = false;
        ProblemsCollector problemsCollector = $this$service$iv.getService(ProblemsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)problemsCollector, (String)"getService(T::class.java)");
        ProblemsCollector collector2 = problemsCollector;
        buildProgressObservable.addListener(new BuildProgressListener(this, collector2){
            final /* synthetic */ BuildViewProblemsService this$0;
            final /* synthetic */ ProblemsCollector $collector;

            /*
             * WARNING - void declaration
             */
            public final void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event instanceof FileMessageEvent && ((FileMessageEvent)event).getKind() == MessageEvent.Kind.ERROR) {
                        Set problems;
                        Object object;
                        void $this$getOrPut$iv;
                        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                        FilePosition filePosition = ((FileMessageEvent)event).getFilePosition();
                        Intrinsics.checkNotNullExpressionValue((Object)filePosition, (String)"event.filePosition");
                        VirtualFile virtualFile2 = virtualFileManager.findFileByNioPath(filePosition.getFile().toPath());
                        if (virtualFile2 == null) {
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"VirtualFileManager.getIn\u2026urn@BuildProgressListener");
                        VirtualFile virtualFile3 = virtualFile2;
                        FileBuildProblem problem = new FileBuildProblem((FileMessageEvent)event, virtualFile3, this.this$0);
                        Map<Object, Set<FileBuildProblem>> map2 = this.this$0.getBuildIdToFileProblems();
                        Object key$iv = buildId;
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            Set answer$iv = new HashSet<E>();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        if ((problems = (Set)object).add(problem)) {
                            this.$collector.problemAppeared(problem);
                        } else {
                            this.$collector.problemUpdated(problem);
                        }
                    }
                    if (!(event instanceof StartBuildEvent)) break block9;
                    Map<String, Object> map3 = this.this$0.getWorkingDirToBuildId();
                    BuildDescriptor buildDescriptor = ((StartBuildEvent)event).getBuildDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)buildDescriptor, (String)"event.buildDescriptor");
                    String string2 = buildDescriptor.getWorkingDir();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.buildDescriptor.workingDir");
                    Object object = map3.put(string2, buildId);
                    if (object != null) {
                        Object object2;
                        Object oldBuildId = object2 = object;
                        boolean bl = false;
                        Set<FileBuildProblem> set2 = this.this$0.getBuildIdToFileProblems().get(oldBuildId);
                        if (set2 != null) {
                            Iterable $this$forEach$iv = set2;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                FileBuildProblem it = (FileBuildProblem)element$iv;
                                boolean bl2 = false;
                                this.$collector.problemDisappeared(it);
                            }
                        }
                        this.this$0.getBuildIdToFileProblems().remove(oldBuildId);
                    }
                }
            }
            {
                this.this$0 = buildViewProblemsService;
                this.$collector = problemsCollector;
            }
        }, this);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    public BuildViewProblemsService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.workingDirToBuildId = new LinkedHashMap();
        this.buildIdToFileProblems = new LinkedHashMap();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/build/BuildViewProblemsService$BuildProblemsProvider;", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
    public static final class BuildProblemsProvider
    implements ProblemsProvider {
        @NotNull
        private final Project project;

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }

        public BuildProblemsProvider(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        @Override
        public void dispose() {
            ProblemsProvider.DefaultImpls.dispose(this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u000bH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/build/BuildViewProblemsService$FileBuildProblem;", "Lcom/intellij/analysis/problemsView/FileProblem;", "Lcom/intellij/analysis/problemsView/HighlightingDuplicate;", "event", "Lcom/intellij/build/events/FileMessageEvent;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "problemsProvider", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "(Lcom/intellij/build/events/FileMessageEvent;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/analysis/problemsView/ProblemsProvider;)V", "column", "", "getColumn", "()I", "description", "", "getDescription", "()Ljava/lang/String;", "getEvent", "()Lcom/intellij/build/events/FileMessageEvent;", "file", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "line", "getLine", "getProblemsProvider", "()Lcom/intellij/analysis/problemsView/ProblemsProvider;", "provider", "getProvider", "text", "getText", "getVirtualFile", "equals", "", "other", "", "hashCode", "intellij.platform.lang.impl"})
    public static final class FileBuildProblem
    implements FileProblem,
    HighlightingDuplicate {
        @NotNull
        private final FileMessageEvent event;
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final ProblemsProvider problemsProvider;

        @Override
        @Nullable
        public String getDescription() {
            return this.event.getDescription();
        }

        @Override
        @NotNull
        public VirtualFile getFile() {
            return this.virtualFile;
        }

        @Override
        public int getLine() {
            FilePosition filePosition = this.event.getFilePosition();
            Intrinsics.checkNotNullExpressionValue((Object)filePosition, (String)"event.filePosition");
            return filePosition.getStartLine();
        }

        @Override
        public int getColumn() {
            FilePosition filePosition = this.event.getFilePosition();
            Intrinsics.checkNotNullExpressionValue((Object)filePosition, (String)"event.filePosition");
            return filePosition.getStartColumn();
        }

        @Override
        @NotNull
        public ProblemsProvider getProvider() {
            return this.problemsProvider;
        }

        @Override
        @NotNull
        public String getText() {
            String string2 = this.event.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.message");
            return string2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.build.BuildViewProblemsService.FileBuildProblem");
            }
            FileBuildProblem cfr_ignored_0 = (FileBuildProblem)object2;
            if (Intrinsics.areEqual((Object)this.event, (Object)((FileBuildProblem)other).event) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.virtualFile, (Object)((FileBuildProblem)other).virtualFile) ^ true) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.problemsProvider, (Object)((FileBuildProblem)other).problemsProvider) ^ true);
        }

        public int hashCode() {
            int result2 = this.event.hashCode();
            result2 = 31 * result2 + this.virtualFile.hashCode();
            result2 = 31 * result2 + this.problemsProvider.hashCode();
            return result2;
        }

        @NotNull
        public final FileMessageEvent getEvent() {
            return this.event;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final ProblemsProvider getProblemsProvider() {
            return this.problemsProvider;
        }

        public FileBuildProblem(@NotNull FileMessageEvent event, @NotNull VirtualFile virtualFile2, @NotNull ProblemsProvider problemsProvider) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)problemsProvider, (String)"problemsProvider");
            this.event = event;
            this.virtualFile = virtualFile2;
            this.problemsProvider = problemsProvider;
        }

        @Override
        @Nullable
        public String getGroup() {
            return FileProblem.DefaultImpls.getGroup(this);
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return FileProblem.DefaultImpls.getIcon(this);
        }
    }
}

