/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.FilePosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNavigatable
implements Navigatable {
    private final Project myProject;
    private final NullableLazyValue<OpenFileDescriptor> myValue;
    private final FilePosition myFilePosition;

    public FileNavigatable(@NotNull Project project2, @NotNull FilePosition filePosition) {
        if (project2 == null) {
            FileNavigatable.$$$reportNull$$$0(0);
        }
        if (filePosition == null) {
            FileNavigatable.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myFilePosition = filePosition;
        this.myValue = new NullableLazyValue<OpenFileDescriptor>(){

            @Override
            @Nullable
            protected OpenFileDescriptor compute() {
                return FileNavigatable.this.createDescriptor();
            }
        };
    }

    @Override
    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor = this.getFileDescriptor();
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        OpenFileDescriptor descriptor = this.getFileDescriptor();
        if (descriptor != null) {
            return descriptor.canNavigate();
        }
        return false;
    }

    @Override
    public boolean canNavigateToSource() {
        OpenFileDescriptor descriptor = this.getFileDescriptor();
        if (descriptor != null) {
            return descriptor.canNavigateToSource();
        }
        return false;
    }

    @Nullable
    public OpenFileDescriptor getFileDescriptor() {
        return this.myValue.getValue();
    }

    @NotNull
    public FilePosition getFilePosition() {
        FilePosition filePosition = this.myFilePosition;
        if (filePosition == null) {
            FileNavigatable.$$$reportNull$$$0(2);
        }
        return filePosition;
    }

    @Nullable
    private OpenFileDescriptor createDescriptor() {
        OpenFileDescriptor descriptor = null;
        VirtualFile file2 = VfsUtil.findFileByIoFile(this.myFilePosition.getFile(), false);
        if (file2 != null) {
            descriptor = new OpenFileDescriptor(this.myProject, file2, this.myFilePosition.getStartLine(), this.myFilePosition.getStartColumn());
        }
        return descriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePosition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/FileNavigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/FileNavigatable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

