/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.HtmlStyleManagerKt;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.BitUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000eJ\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0012J\u0016\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003J\u001c\u0010\"\u001a\u00020\u00142\n\u0010\u0005\u001a\u00060#j\u0002`$2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0016\u0010%\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0012R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/codeEditor/printing/HtmlStyleManager;", "", "isInline", "", "(Z)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "()Z", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Lorg/jetbrains/annotations/NotNull;", "separatorStyleMap", "Ljava/util/HashMap;", "Ljava/awt/Color;", "", "Lkotlin/collections/HashMap;", "styleMap", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "ensureStyles", "", "hIterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "methodSeparators", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getSeparatorClassName", "color", "isDefaultAttributes", "attributes", "writeStyleTag", "writer", "Ljava/io/Writer;", "isUseLineNumberStyle", "writeTextAttributes", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "writeTextStyle", "intellij.platform.lang.impl"})
public final class HtmlStyleManager {
    private final HashMap<TextAttributes, String> styleMap;
    private final HashMap<Color, String> separatorStyleMap;
    private final StringBuilder buffer;
    private final EditorColorsScheme scheme;
    private final boolean isInline;

    public final void ensureStyles(@NotNull HighlighterIterator hIterator, @NotNull List<? extends LineMarkerInfo<?>> methodSeparators) {
        Intrinsics.checkNotNullParameter((Object)hIterator, (String)"hIterator");
        Intrinsics.checkNotNullParameter(methodSeparators, (String)"methodSeparators");
        while (!hIterator.atEnd()) {
            TextAttributes textAttributes = hIterator.getTextAttributes();
            if (!this.styleMap.containsKey(textAttributes)) {
                String styleName = "s" + this.styleMap.size();
                this.styleMap.put(textAttributes, styleName);
                this.buffer.append("." + styleName + " { ");
                Appendable appendable = this.buffer;
                TextAttributes textAttributes2 = textAttributes;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"textAttributes");
                this.writeTextAttributes(appendable, textAttributes2);
                this.buffer.append("}\n");
            }
            hIterator.advance();
        }
        for (LineMarkerInfo<?> separator : methodSeparators) {
            Color color = separator.separatorColor;
            if (color == null || this.separatorStyleMap.containsKey(color)) continue;
            String styleName = "ls" + this.separatorStyleMap.size();
            this.separatorStyleMap.put(color, styleName);
            String htmlColor = HtmlStyleManagerKt.access$colorToHtml(color);
            this.buffer.append("." + styleName + " { height: 1px; border-width: 0; color: " + htmlColor + "; background-color:" + htmlColor + "}\n");
        }
    }

    private final void writeTextAttributes(Appendable buffer, TextAttributes attributes) {
        Color color = attributes.getForegroundColor();
        if (color == null) {
            Color color2 = this.scheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"scheme.defaultForeground");
        }
        Color foreColor = color;
        buffer.append("color: " + HtmlStyleManagerKt.access$colorToHtml(foreColor) + ";");
        if (BitUtil.isSet(attributes.getFontType(), 1)) {
            buffer.append(" font-weight: bold;");
        }
        if (BitUtil.isSet(attributes.getFontType(), 2)) {
            buffer.append(" font-style: italic;");
        }
    }

    public final void writeStyleTag(@NotNull Writer writer, boolean isUseLineNumberStyle) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write("<style type=\"text/css\">\n");
        if (isUseLineNumberStyle) {
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
            EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
            EditorColorsScheme scheme = editorColorsScheme;
            Color lineNumbers = scheme.getColor(EditorColors.LINE_NUMBERS_COLOR);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = ".ln { color: #%s; font-weight: normal; font-style: normal; }\n";
            Object[] objectArray = new Object[1];
            Color color = lineNumbers;
            if (color == null) {
                color = Gray.x00;
            }
            objectArray[0] = ColorUtil.toHex(color);
            Object[] objectArray2 = objectArray;
            String string3 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            this.buffer.append(string3);
        }
        writer.append(this.buffer);
        writer.write("</style>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDefaultAttributes(@NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (attributes.getFontType() != 0) return false;
        Color color = attributes.getForegroundColor();
        if (color == null) {
            Color color2 = this.scheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"scheme.defaultForeground");
        }
        if (!Intrinsics.areEqual((Object)color, (Object)Color.BLACK)) return false;
        return true;
    }

    public final void writeTextStyle(@NotNull Writer writer, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        writer.write("<span ");
        if (this.isInline) {
            writer.write("style=\"");
            this.writeTextAttributes(writer, attributes);
            writer.write("\">");
        } else {
            writer.write("class=\"");
            String string2 = this.styleMap.get(attributes);
            Intrinsics.checkNotNull((Object)string2);
            writer.write(string2);
            writer.write("\">");
        }
    }

    @NotNull
    public final String getSeparatorClassName(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        String string2 = this.separatorStyleMap.get(color);
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separatorStyleMap.get(color)!!");
        return string2;
    }

    public final boolean isInline() {
        return this.isInline;
    }

    public HtmlStyleManager(boolean isInline) {
        this.isInline = isInline;
        this.styleMap = new HashMap();
        this.separatorStyleMap = new HashMap();
        this.buffer = new StringBuilder();
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        this.scheme = editorColorsScheme;
    }
}

