/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.CommonBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeEditor.printing.BasePainter;
import com.intellij.codeEditor.printing.MultiFilePainter;
import com.intellij.codeEditor.printing.PageSizes;
import com.intellij.codeEditor.printing.PrintDialog;
import com.intellij.codeEditor.printing.PrintSettings;
import com.intellij.codeEditor.printing.TextPainter;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.ide.actions.PrintActionHandler;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TextPrintHandler
extends PrintActionHandler {
    private static final Logger LOG = Logger.getInstance(TextPrintHandler.class);

    @Override
    public boolean canPrint(@NotNull DataContext dataContext) {
        Project project2;
        if (dataContext == null) {
            TextPrintHandler.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return false;
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file2 != null && file2.isDirectory()) {
            return true;
        }
        return CommonDataKeys.EDITOR.getData(dataContext) != null || !TextPrintHandler.getSelectedPsiFiles(dataContext).isEmpty();
    }

    @Override
    public void print(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            TextPrintHandler.$$$reportNull$$$0(1);
        }
        TextPrintHandler.executePrint(dataContext);
    }

    public static void executePrint(DataContext dataContext) {
        BasePainter painter;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        PsiDirectory psiDirectory = null;
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement instanceof PsiDirectory) {
            psiDirectory = (PsiDirectory)psiElement;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        String shortFileName = null;
        String directoryName = null;
        if (psiFile != null || psiDirectory != null) {
            if (psiFile != null) {
                shortFileName = psiFile.getName();
                if (psiDirectory == null) {
                    psiDirectory = psiFile.getContainingDirectory();
                }
            }
            if (psiDirectory != null) {
                directoryName = psiDirectory.getVirtualFile().getPresentableUrl();
            }
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        String text2 = null;
        if (editor2 != null) {
            text2 = editor2.getSelectionModel().hasSelection() ? EditorBundle.message((String)"print.selected.text.radio", (Object[])new Object[0]) : (psiFile == null ? "Console text" : null);
        }
        List<PsiFile> psiFiles = TextPrintHandler.getSelectedPsiFiles(dataContext);
        PrintDialog printDialog = new PrintDialog(shortFileName, directoryName, text2, psiFiles.size(), project2);
        printDialog.reset();
        if (!printDialog.showAndGet()) {
            return;
        }
        printDialog.apply();
        PageFormat pageFormat = TextPrintHandler.createPageFormat();
        PrintSettings printSettings = PrintSettings.getInstance();
        if (printSettings.getPrintScope() == 1 && psiFiles.size() > 1) {
            painter = new MultiFilePainter(psiFiles, printSettings.EVEN_NUMBER_OF_PAGES);
        } else if (printSettings.getPrintScope() == 4) {
            ArrayList filesList = new ArrayList();
            boolean isRecursive = printSettings.isIncludeSubdirectories();
            TextPrintHandler.addToPsiFileList(Objects.requireNonNull(psiDirectory), filesList, isRecursive);
            painter = new MultiFilePainter(filesList, printSettings.EVEN_NUMBER_OF_PAGES);
        } else {
            if (psiFile == null && editor2 == null) {
                return;
            }
            TextPainter textPainter = psiFile != null ? TextPrintHandler.initTextPainter(psiFile) : TextPrintHandler.initTextPainter((DocumentEx)editor2.getDocument(), project2, TextPrintHandler.generateFileName(dataContext));
            if (textPainter == null) {
                return;
            }
            if (printSettings.getPrintScope() == 2 && editor2 != null && editor2.getSelectionModel().hasSelection()) {
                textPainter.setSegment(editor2.getSelectionModel().getSelectionStart(), editor2.getSelectionModel().getSelectionEnd());
            }
            painter = textPainter;
        }
        TextPrintHandler.executePrintInner(project2, pageFormat, painter);
    }

    private static void executePrintInner(Project project2, PageFormat pageFormat, final BasePainter painter) {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        try {
            printerJob.setPrintable(painter, pageFormat);
            if (!printerJob.printDialog()) {
                return;
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        ProgressManager.getInstance().run(new Task.Backgroundable(project2, EditorBundle.message((String)"print.progress", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    painter.setProgress(indicator);
                    printerJob.print();
                }
                catch (ProcessCanceledException e) {
                    LOG.info("Cancelled");
                    printerJob.cancel();
                }
                catch (PrinterException e) {
                    LOG.warn(e);
                    @NonNls String message2 = ObjectUtils.notNull(e.getMessage(), e.getClass().getName());
                    Notifications.Bus.notify((Notification)new Notification("Print", CommonBundle.getErrorTitle(), message2, NotificationType.ERROR));
                }
                catch (Exception e) {
                    LOG.error(e);
                }
                finally {
                    painter.dispose();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeEditor/printing/TextPrintHandler$1", "run"));
            }
        });
    }

    private static String generateFileName(DataContext dataContext) {
        RunProfile runProfile = (RunProfile)dataContext.getData(LangDataKeys.RUN_PROFILE);
        return runProfile == null ? "unknown" : runProfile.getName();
    }

    private static void addToPsiFileList(PsiDirectory psiDirectory, List<? super PsiFile> filesList, boolean isRecursive) {
        PsiFile[] files2 = psiDirectory.getFiles();
        Collections.addAll(filesList, files2);
        if (isRecursive) {
            for (PsiDirectory directory : psiDirectory.getSubdirectories()) {
                if (".idea".equals(directory.getName())) continue;
                TextPrintHandler.addToPsiFileList(directory, filesList, true);
            }
        }
    }

    static List<PsiFile> getSelectedPsiFiles(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return Collections.emptyList();
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles == null) {
            return Collections.emptyList();
        }
        PsiManager psiManager = PsiManager.getInstance(project2);
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>(virtualFiles.length);
        for (VirtualFile virtualFile2 : virtualFiles) {
            if (virtualFile2.isDirectory()) {
                return Collections.emptyList();
            }
            PsiFile psiFile = psiManager.findFile(virtualFile2);
            if (psiFile == null || psiFile instanceof PsiBinaryFile) {
                return Collections.emptyList();
            }
            psiFiles.add(psiFile);
        }
        return psiFiles;
    }

    private static PageFormat createPageFormat() {
        PrintSettings printSettings = PrintSettings.getInstance();
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        String paperSize = printSettings.PAPER_SIZE;
        double paperWidth = PageSizes.getWidth(paperSize) * 72.0;
        double paperHeight = PageSizes.getHeight(paperSize) * 72.0;
        double leftMargin = printSettings.LEFT_MARGIN * 72.0f;
        double rightMargin = printSettings.RIGHT_MARGIN * 72.0f;
        double topMargin = printSettings.TOP_MARGIN * 72.0f;
        double bottomMargin = printSettings.BOTTOM_MARGIN * 72.0f;
        paper.setSize(paperWidth, paperHeight);
        if (printSettings.PORTRAIT_LAYOUT) {
            pageFormat.setOrientation(1);
            paper.setImageableArea(leftMargin, topMargin, paperWidth -= leftMargin + rightMargin, paperHeight -= topMargin + bottomMargin);
        } else {
            pageFormat.setOrientation(0);
            paper.setImageableArea(rightMargin, topMargin, paperWidth -= topMargin + bottomMargin, paperHeight -= leftMargin + rightMargin);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    static TextPainter initTextPainter(PsiFile psiFile) {
        return ReadAction.compute(() -> TextPrintHandler.doInitTextPainter(psiFile));
    }

    private static TextPainter doInitTextPainter(PsiFile psiFile) {
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        DocumentEx doc = (DocumentEx)PsiDocumentManager.getInstance(psiFile.getProject()).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((VirtualFile)virtualFile2, (EditorColorsScheme)EditorColorsUtil.getColorSchemeForPrinting(), (Project)psiFile.getProject());
        return new TextPainter(doc, highlighter, virtualFile2.getPresentableUrl(), virtualFile2.getPresentableName(), psiFile.getFileType(), psiFile.getProject(), CodeStyle.getSettings((PsiFile)psiFile));
    }

    private static TextPainter initTextPainter(@NotNull DocumentEx doc, @NotNull Project project2, @NotNull String fileName) {
        if (doc == null) {
            TextPrintHandler.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            TextPrintHandler.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            TextPrintHandler.$$$reportNull$$$0(4);
        }
        TextPainter[] res = new TextPainter[1];
        ApplicationManager.getApplication().runReadAction(() -> {
            res[0] = TextPrintHandler.doInitTextPainter(doc, project2, fileName);
        });
        return res[0];
    }

    private static TextPainter doInitTextPainter(@NotNull DocumentEx doc, @NotNull Project project2, @NotNull String fileName) {
        if (doc == null) {
            TextPrintHandler.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            TextPrintHandler.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            TextPrintHandler.$$$reportNull$$$0(7);
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((EditorColorsScheme)EditorColorsUtil.getColorSchemeForPrinting(), (String)"unknown", (Project)project2);
        return new TextPainter(doc, highlighter, fileName, fileName, FileTypes.PLAIN_TEXT, null, CodeStyle.getSettings((Project)project2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeEditor/printing/TextPrintHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canPrint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initTextPainter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doInitTextPainter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

