/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public abstract class TailType {
    public static final TailType UNKNOWN = new TailType(){

        @Override
        public int processTail(Editor editor2, int tailOffset) {
            return tailOffset;
        }

        public String toString() {
            return "UNKNOWN";
        }
    };
    public static final TailType NONE = new TailType(){

        @Override
        public int processTail(Editor editor2, int tailOffset) {
            return tailOffset;
        }

        public String toString() {
            return "NONE";
        }
    };
    public static final TailType SEMICOLON = new CharTailType(';');
    public static final TailType SPACE = new CharTailType(' ');
    public static final TailType INSERT_SPACE = new CharTailType(' ', false);
    public static final TailType HUMBLE_SPACE_BEFORE_WORD = new CharTailType(' ', false){

        @Override
        public boolean isApplicable(@NotNull InsertionContext context2) {
            char ch;
            if (context2 == null) {
                3.$$$reportNull$$$0(0);
            }
            CharSequence text2 = context2.getDocument().getCharsSequence();
            int tail = context2.getTailOffset();
            if (text2.length() > tail + 1 && text2.charAt(tail) == ' ' && ((ch = text2.charAt(tail + 1)) == '@' || Character.isLetter(ch))) {
                return false;
            }
            return super.isApplicable(context2);
        }

        @Override
        public String toString() {
            return "HUMBLE_SPACE_BEFORE_WORD";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/TailType$3", "isApplicable"));
        }
    };
    public static final TailType DOT = new CharTailType('.');
    public static final TailType CASE_COLON = new CharTailType(':');
    public static final TailType COND_EXPR_COLON = new TailType(){

        @Override
        public int processTail(Editor editor2, int tailOffset) {
            Document document = editor2.getDocument();
            int textLength = document.getTextLength();
            CharSequence chars = document.getCharsSequence();
            int afterWhitespace = CharArrayUtil.shiftForward(chars, tailOffset, " \n\t");
            if (afterWhitespace < textLength && chars.charAt(afterWhitespace) == ':') {
                return 4.moveCaret(editor2, tailOffset, afterWhitespace - tailOffset + 1);
            }
            document.insertString(tailOffset, " : ");
            return 4.moveCaret(editor2, tailOffset, 3);
        }

        public String toString() {
            return "COND_EXPR_COLON";
        }
    };
    public static final TailType LPARENTH = new CharTailType('(');

    public static int insertChar(Editor editor2, int tailOffset, char c) {
        return TailType.insertChar(editor2, tailOffset, c, true);
    }

    public static int insertChar(Editor editor2, int tailOffset, char c, boolean overwrite) {
        Document document = editor2.getDocument();
        int textLength = document.getTextLength();
        CharSequence chars = document.getCharsSequence();
        if (tailOffset == textLength || !overwrite || chars.charAt(tailOffset) != c) {
            document.insertString(tailOffset, String.valueOf(c));
        }
        return TailType.moveCaret(editor2, tailOffset, 1);
    }

    protected static int moveCaret(Editor editor2, int tailOffset, int delta) {
        CaretModel model2 = editor2.getCaretModel();
        if (model2.getOffset() == tailOffset) {
            model2.moveToOffset(tailOffset + delta);
        }
        return tailOffset + delta;
    }

    protected static FileType getFileType(Editor editor2) {
        PsiFile psiFile = TailType.getFile(editor2);
        return psiFile.getFileType();
    }

    @NotNull
    private static PsiFile getFile(Editor editor2) {
        Project project2 = editor2.getProject();
        assert (project2 != null);
        PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        assert (psiFile != null);
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            TailType.$$$reportNull$$$0(0);
        }
        return psiFile2;
    }

    public abstract int processTail(Editor var1, int var2);

    public static TailType createSimpleTailType(char c) {
        return new CharTailType(c);
    }

    public boolean isApplicable(@NotNull InsertionContext context2) {
        if (context2 == null) {
            TailType.$$$reportNull$$$0(1);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/TailType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/TailType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

