/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.CodeStyleBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.CodeCleanupCodeProcessor;
import com.intellij.codeInsight.actions.DirectoryFormattingOptions;
import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.LayoutDirectoryDialog;
import com.intellij.codeInsight.actions.LayoutProjectCodeDialog;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeRunOptions;
import com.intellij.codeInsight.actions.ReformatFilesDialog;
import com.intellij.codeInsight.actions.ReformatFilesOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ReformatCodeAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(ReformatCodeAction.class);
    private static ReformatFilesOptions myTestOptions;

    public ReformatCodeAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        PsiDirectory dir;
        DataContext dataContext;
        Project project2;
        if (event == null) {
            ReformatCodeAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext = event.getDataContext())) == null) {
            return;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        PsiFile file2 = null;
        boolean hasSelection = false;
        if (editor2 != null) {
            file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
            if (file2 == null) {
                return;
            }
            dir = file2.getContainingDirectory();
            hasSelection = editor2.getSelectionModel().hasSelection();
        } else {
            if (files2 != null && ReformatCodeAction.containsOnlyFiles(files2)) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance(project2).ensureFilesWritable(Arrays.asList(files2));
                if (!operationStatus.hasReadonlyFiles()) {
                    ReformatFilesOptions selectedFlags = ReformatCodeAction.getReformatFilesOptions(project2, files2);
                    if (selectedFlags == null) {
                        return;
                    }
                    boolean processOnlyChangedText = selectedFlags.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
                    boolean shouldOptimizeImports = selectedFlags.isOptimizeImports() && !DumbService.getInstance(project2).isDumb();
                    AbstractLayoutCodeProcessor processor = new ReformatCodeProcessor(project2, ReformatCodeAction.convertToPsiFiles(files2, project2), null, processOnlyChangedText);
                    if (shouldOptimizeImports) {
                        processor = new OptimizeImportsProcessor(processor);
                    }
                    if (selectedFlags.isRearrangeCode()) {
                        processor = new RearrangeCodeProcessor(processor);
                    }
                    if (selectedFlags.isCodeCleanup()) {
                        processor = new CodeCleanupCodeProcessor(processor);
                    }
                    processor.run();
                }
                return;
            }
            if (PlatformCoreDataKeys.PROJECT_CONTEXT.getData(dataContext) != null || LangDataKeys.MODULE_CONTEXT.getData(dataContext) != null) {
                Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
                ReformatFilesOptions selectedFlags = ReformatCodeAction.getLayoutProjectOptions(project2, moduleContext);
                if (selectedFlags != null) {
                    ReformatCodeAction.reformatModule(project2, moduleContext, selectedFlags);
                }
                return;
            }
            PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element2 == null) {
                return;
            }
            if (element2 instanceof PsiDirectoryContainer) {
                dir = ArrayUtil.getFirstElement(((PsiDirectoryContainer)element2).getDirectories());
            } else if (element2 instanceof PsiDirectory) {
                dir = (PsiDirectory)element2;
            } else {
                file2 = element2.getContainingFile();
                if (file2 == null) {
                    return;
                }
                dir = file2.getContainingDirectory();
            }
        }
        if (file2 == null && dir != null) {
            DirectoryFormattingOptions options = ReformatCodeAction.getDirectoryFormattingOptions(project2, dir);
            if (options != null) {
                ReformatCodeAction.reformatDirectory(project2, dir, options);
            }
            return;
        }
        if (file2 == null || editor2 == null) {
            return;
        }
        PsiDocumentManager.getInstance(project2).commitDocument(editor2.getDocument());
        LastRunReformatCodeOptionsProvider provider2 = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
        ReformatCodeRunOptions currentRunOptions = provider2.getLastRunOptions(file2);
        TextRangeType processingScope = currentRunOptions.getTextRangeType();
        if (hasSelection) {
            processingScope = TextRangeType.SELECTED_TEXT;
        } else if (processingScope == TextRangeType.VCS_CHANGED_TEXT) {
            if (VcsFacade.getInstance().isChangeNotTrackedForFile(project2, file2)) {
                processingScope = TextRangeType.WHOLE_FILE;
            }
        } else {
            processingScope = TextRangeType.WHOLE_FILE;
        }
        currentRunOptions.setProcessingScope(processingScope);
        new FileInEditorProcessor(file2, editor2, currentRunOptions).processCode();
    }

    @Nullable
    private static DirectoryFormattingOptions getDirectoryFormattingOptions(@NotNull Project project2, @NotNull PsiDirectory dir) {
        if (project2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(1);
        }
        if (dir == null) {
            ReformatCodeAction.$$$reportNull$$$0(2);
        }
        LayoutDirectoryDialog dialog = new LayoutDirectoryDialog(project2, CodeStyleBundle.message((String)"process.reformat.code", (Object[])new Object[0]), CodeInsightBundle.message("process.scope.directory", dir.getVirtualFile().getPath()), VcsFacade.getInstance().hasChanges(dir));
        boolean enableIncludeDirectoriesCb = dir.getSubdirectories().length > 0;
        dialog.setEnabledIncludeSubdirsCb(enableIncludeDirectoriesCb);
        dialog.setSelectedIncludeSubdirsCb(enableIncludeDirectoriesCb);
        if (dialog.showAndGet()) {
            return dialog;
        }
        return null;
    }

    public static void reformatDirectory(@NotNull Project project2, @NotNull PsiDirectory dir, @NotNull DirectoryFormattingOptions options) {
        if (project2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(3);
        }
        if (dir == null) {
            ReformatCodeAction.$$$reportNull$$$0(4);
        }
        if (options == null) {
            ReformatCodeAction.$$$reportNull$$$0(5);
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        AbstractLayoutCodeProcessor processor = new ReformatCodeProcessor(project2, dir, options.isIncludeSubdirectories(), options.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT);
        ReformatCodeAction.registerScopeFilter(processor, options.getSearchScope());
        ReformatCodeAction.registerFileMaskFilter(processor, options.getFileTypeMask());
        if (options.isOptimizeImports()) {
            processor = new OptimizeImportsProcessor(processor);
        }
        if (options.isRearrangeCode()) {
            processor = new RearrangeCodeProcessor(processor);
        }
        if (options.isCodeCleanup()) {
            processor = new CodeCleanupCodeProcessor(processor);
        }
        processor.run();
    }

    private static void reformatModule(@NotNull Project project2, @Nullable Module moduleContext, @NotNull ReformatFilesOptions selectedFlags) {
        if (project2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(6);
        }
        if (selectedFlags == null) {
            ReformatCodeAction.$$$reportNull$$$0(7);
        }
        boolean shouldOptimizeImports = selectedFlags.isOptimizeImports() && !DumbService.getInstance(project2).isDumb();
        boolean processOnlyChangedText = selectedFlags.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        AbstractLayoutCodeProcessor processor = moduleContext != null ? new ReformatCodeProcessor(project2, moduleContext, processOnlyChangedText) : new ReformatCodeProcessor(project2, processOnlyChangedText);
        ReformatCodeAction.registerScopeFilter(processor, selectedFlags.getSearchScope());
        ReformatCodeAction.registerFileMaskFilter(processor, selectedFlags.getFileTypeMask());
        if (shouldOptimizeImports) {
            processor = new OptimizeImportsProcessor(processor);
        }
        if (selectedFlags.isRearrangeCode()) {
            processor = new RearrangeCodeProcessor(processor);
        }
        processor.run();
    }

    public static void registerScopeFilter(@NotNull AbstractLayoutCodeProcessor processor, @Nullable SearchScope scope) {
        if (processor == null) {
            ReformatCodeAction.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            return;
        }
        processor.addFileFilter(scope::contains);
    }

    public static void registerFileMaskFilter(@NotNull AbstractLayoutCodeProcessor processor, @Nullable String fileTypeMask) {
        if (processor == null) {
            ReformatCodeAction.$$$reportNull$$$0(9);
        }
        if (fileTypeMask == null) {
            return;
        }
        Condition<CharSequence> patternCondition = ReformatCodeAction.getFileTypeMaskPattern(fileTypeMask);
        processor.addFileFilter(file2 -> patternCondition.value(file2.getNameSequence()));
    }

    @NotNull
    private static Condition<CharSequence> getFileTypeMaskPattern(@Nullable String mask) {
        Condition<CharSequence> condition;
        try {
            condition = FindInProjectUtil.createFileMaskCondition(mask);
        }
        catch (PatternSyntaxException e) {
            LOG.info("Error while processing file mask: ", e);
            Condition<CharSequence> condition2 = Conditions.alwaysTrue();
            if (condition2 == null) {
                ReformatCodeAction.$$$reportNull$$$0(11);
            }
            return condition2;
        }
        if (condition == null) {
            ReformatCodeAction.$$$reportNull$$$0(10);
        }
        return condition;
    }

    public static PsiFile @NotNull [] convertToPsiFiles(VirtualFile @NotNull [] files2, @NotNull Project project2) {
        if (project2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(12);
        }
        if (files2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(13);
        }
        PsiManager psiManager = PsiManager.getInstance(project2);
        List<PsiFile> list2 = PsiUtilCore.toPsiFiles(psiManager, Arrays.asList(files2));
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray(list2);
        if (psiFileArray == null) {
            ReformatCodeAction.$$$reportNull$$$0(14);
        }
        return psiFileArray;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ReformatCodeAction.$$$reportNull$$$0(15);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ReformatCodeAction.$$$reportNull$$$0(16);
        }
        Presentation presentation2 = event.getPresentation();
        boolean available = ReformatCodeAction.isActionAvailable(event);
        if (event.isFromContextMenu()) {
            presentation2.setEnabledAndVisible(available);
        } else {
            presentation2.setEnabled(available);
        }
    }

    private static boolean isActionAvailable(@NotNull AnActionEvent event) {
        DataContext dataContext;
        Project project2;
        if (event == null) {
            ReformatCodeAction.$$$reportNull$$$0(17);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext = event.getDataContext())) == null) {
            return false;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (editor2 != null) {
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
            if (file2 == null || file2.getVirtualFile() == null) {
                return false;
            }
            if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
                return true;
            }
        } else if (files2 != null && ReformatCodeAction.containsOnlyFiles(files2)) {
            boolean anyFormatters = false;
            for (VirtualFile virtualFile2 : files2) {
                PsiFile psiFile = PsiManager.getInstance(project2).findFile(virtualFile2);
                if (psiFile == null) {
                    return false;
                }
                FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile);
                if (builder2 == null) continue;
                anyFormatters = true;
                break;
            }
            if (!anyFormatters) {
                return false;
            }
        } else if ((files2 == null || files2.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(dataContext) == null && PlatformCoreDataKeys.PROJECT_CONTEXT.getData(dataContext) == null) {
            PsiFile file3;
            PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element2 == null) {
                return false;
            }
            if (!(element2 instanceof PsiDirectory || (file3 = element2.getContainingFile()) != null && LanguageFormatting.INSTANCE.forContext((PsiElement)file3) != null)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static ReformatFilesOptions getReformatFilesOptions(@NotNull Project project2, VirtualFile @NotNull [] files2) {
        if (project2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(18);
        }
        if (files2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(19);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return myTestOptions;
        }
        ReformatFilesDialog dialog = new ReformatFilesDialog(project2, files2);
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog;
    }

    @Nullable
    private static ReformatFilesOptions getLayoutProjectOptions(@NotNull Project project2, @Nullable Module module) {
        if (project2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(20);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return myTestOptions;
        }
        String text2 = module != null ? CodeInsightBundle.message("process.scope.module", module.getModuleFilePath()) : CodeInsightBundle.message("process.scope.project", project2.getPresentableUrl());
        boolean enableOnlyVCSChangedRegions = module != null ? VcsFacade.getInstance().hasChanges(module) : VcsFacade.getInstance().hasChanges(project2);
        LayoutProjectCodeDialog dialog = new LayoutProjectCodeDialog(project2, CodeStyleBundle.message((String)"process.reformat.code", (Object[])new Object[0]), text2, enableOnlyVCSChangedRegions);
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog;
    }

    @TestOnly
    public static void setTestOptions(@NotNull ReformatFilesOptions options) {
        if (options == null) {
            ReformatCodeAction.$$$reportNull$$$0(21);
        }
        myTestOptions = options;
    }

    static boolean containsOnlyFiles(VirtualFile @NotNull [] files2) {
        if (files2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(22);
        }
        if (files2.length < 1) {
            return false;
        }
        for (VirtualFile virtualFile2 : files2) {
            if (!virtualFile2.isDirectory()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 12: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFlags";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/ReformatCodeAction";
                break;
            }
            case 13: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/ReformatCodeAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeMaskPattern";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPsiFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryFormattingOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reformatDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reformatModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerScopeFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerFileMaskFilter";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertToPsiFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isActionAvailable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getReformatFilesOptions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutProjectOptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setTestOptions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsOnlyFiles";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

