/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.model;

import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.EditorCodeVisionContextKt;
import com.intellij.codeInsight.codeVision.ui.RdSwingKt;
import com.intellij.codeInsight.codeVision.ui.model.AdditionalKt;
import com.intellij.codeInsight.codeVision.ui.model.CodeVisionListData;
import com.intellij.codeInsight.codeVision.ui.model.ProjectCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.model.SwingScheduler;
import com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionRenderer;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionTheme;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.AdditionalApiKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0011H\u0002J$\u0010#\u001a\u0004\u0018\u00010\u000f2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010\r2\b\u0010&\u001a\u0004\u0018\u00010\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionSelectionController;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "projectModel", "Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "hovered", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/intellij/openapi/editor/Inlay;", "hoveredEntry", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "lensPopupActive", "", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getProjectModel", "()Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;", "checkEditorMousePosition", "editorMousePosition", "Ljava/awt/Point;", "clearHovered", "", "entryPressHandler", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "showTooltip", "lt", "entry", "updateCursor", "hasHoveredEntry", "updateHovered", "hoveredInlay", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "mouseOnInlay", "Companion", "intellij.platform.lang.impl"})
public final class CodeVisionSelectionController {
    private final Property<Inlay<?>> hovered;
    private final Property<CodeVisionEntry> hoveredEntry;
    private final Property<Boolean> lensPopupActive;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final ProjectCodeVisionModel projectModel;
    @NotNull
    private static final HashMap<Editor, CodeVisionSelectionController> map;
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    private final void entryPressHandler(EditorMouseEvent event) {
        MouseEvent mouseEvent = event.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"event.mouseEvent");
        MouseEvent mouseEvent2 = mouseEvent;
        CodeVisionEntry codeVisionEntry = this.checkEditorMousePosition(mouseEvent2.getPoint());
        if (codeVisionEntry == null) {
            return;
        }
        CodeVisionEntry entry = codeVisionEntry;
        this.editor.getContentComponent().requestFocus();
        event.consume();
        Object object = (Inlay)this.hovered.getValue();
        if (object == null || (object = (CodeVisionListData)object.getUserData(CodeVisionListData.KEY)) == null || (object = ((CodeVisionListData)object).getRangeCodeVisionModel()) == null) {
            return;
        }
        Object rangeLensesModel = object;
        entry.putUserData(EditorCodeVisionContextKt.getCodeVisionEntryMouseEventKey(), mouseEvent2);
        if (SwingUtilities.isLeftMouseButton(mouseEvent2)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                String string2 = "entryPressHandler :: isLeftMouseButton";
                logger.trace(string2);
            }
            ((RangeCodeVisionModel)rangeLensesModel).handleLensClick(entry);
        } else if (SwingUtilities.isRightMouseButton(mouseEvent2)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                String string3 = "entryPressHandler :: isRightMouseButton";
                logger.trace(string3);
            }
            ((RangeCodeVisionModel)rangeLensesModel).handleLensRightClick();
        }
    }

    private final void updateCursor(boolean hasHoveredEntry) {
        Cursor cursor = hasHoveredEntry ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(0);
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"editor.contentComponent");
        if (Intrinsics.areEqual((Object)editorComponentImpl.getCursor(), (Object)cursor) ^ true) {
            UIUtil.setCursor((Component)this.editor.getContentComponent(), cursor);
        }
    }

    private final void showTooltip(Lifetime lt, CodeVisionEntry entry) {
        String text2 = AdditionalKt.tooltipText(entry);
        CharSequence charSequence = text2;
        if (charSequence.length() == 0) {
            return;
        }
        LifetimeDefinition ld = lt.createNested();
        Inlay inlay = (Inlay)this.hovered.getValue();
        if (inlay == null) {
            return;
        }
        Inlay inlay2 = inlay;
        Rectangle rectangle = inlay2.getBounds();
        if (rectangle == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"inlay.bounds ?: return");
        Rectangle inlayBounds = rectangle;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        if (editorCustomElementRenderer == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionRenderer");
        }
        CodeVisionRenderer renderer = (CodeVisionRenderer)editorCustomElementRenderer;
        Rectangle rectangle2 = renderer.entryBounds(inlay2, entry);
        if (rectangle2 == null) {
            return;
        }
        Rectangle entryBounds = rectangle2;
        int x = inlayBounds.x + entryBounds.x + entryBounds.width / 2;
        int y = inlayBounds.y + inlayBounds.height / 2;
        Editor editor2 = inlay2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlay.editor");
        JComponent jComponent = editor2.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"inlay.editor.contentComponent");
        JComponent contentComponent = jComponent;
        Editor editor3 = inlay2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"inlay.editor");
        JComponent jComponent2 = editor3.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"inlay.editor.component");
        JComponent component2 = jComponent2;
        RelativePoint relativePoint = new RelativePoint(contentComponent, new Point(x, y));
        IdeTooltip tooltip = new IdeTooltip((Component)component2, relativePoint.getPoint(component2), (JComponent)new JLabel(text2), new Object[0]);
        IdeTooltip currentTooltip = IdeTooltipManager.getInstance().show(tooltip, false, false);
        Editor editor4 = inlay2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"inlay.editor");
        ScrollingModel scrollingModel = editor4.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"inlay.editor.scrollingModel");
        RdSwingKt.visibleAreaChanged(scrollingModel).advise((Lifetime)ld, (Function1)new Function1<VisibleAreaEvent, Unit>(ld){
            final /* synthetic */ LifetimeDefinition $ld;

            public final void invoke(@NotNull VisibleAreaEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$ld, (boolean)false, (int)1, null);
            }
            {
                this.$ld = lifetimeDefinition;
                super(1);
            }
        });
        ld.onTermination((Function0)new Function0<Unit>(currentTooltip){
            final /* synthetic */ IdeTooltip $currentTooltip;

            public final void invoke() {
                this.$currentTooltip.hide();
            }
            {
                this.$currentTooltip = ideTooltip;
                super(0);
            }
        });
    }

    private final CodeVisionEntry checkEditorMousePosition(Point editorMousePosition) {
        if (editorMousePosition == null) {
            this.clearHovered();
            return null;
        }
        Inlay hoveredInlay = this.editor.getInlayModel().getElementAt(editorMousePosition);
        return this.updateHovered((Inlay<EditorCustomElementRenderer>)hoveredInlay, editorMousePosition);
    }

    private final CodeVisionEntry updateHovered(Inlay<EditorCustomElementRenderer> hoveredInlay, Point mouseOnInlay) {
        if (mouseOnInlay == null || hoveredInlay == null || !(hoveredInlay.getRenderer() instanceof CodeVisionRenderer)) {
            this.clearHovered();
            return null;
        }
        Rectangle rectangle = hoveredInlay.getBounds();
        if (rectangle == null) {
            CodeVisionSelectionController codeVisionSelectionController;
            CodeVisionSelectionController $this$run = codeVisionSelectionController = this;
            boolean bl = false;
            $this$run.clearHovered();
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"hoveredInlay.bounds ?: r\u2026)\n      return null\n    }");
        Rectangle bounds = rectangle;
        if (CodeVisionTheme.Companion.yInInlayBounds(mouseOnInlay.y, bounds)) {
            EditorCustomElementRenderer editorCustomElementRenderer = hoveredInlay.getRenderer();
            if (editorCustomElementRenderer == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionRenderer");
            }
            CodeVisionRenderer renderer = (CodeVisionRenderer)editorCustomElementRenderer;
            CodeVisionEntry entry = renderer.hoveredEntry(hoveredInlay, mouseOnInlay.x - bounds.x, mouseOnInlay.y - bounds.y);
            this.hovered.set(hoveredInlay);
            this.hoveredEntry.set((Object)entry);
            return entry;
        }
        this.clearHovered();
        return null;
    }

    private final void clearHovered() {
        this.hovered.set(null);
        this.hoveredEntry.set(null);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final ProjectCodeVisionModel getProjectModel() {
        return this.projectModel;
    }

    private CodeVisionSelectionController(Lifetime lifetime, EditorImpl editor2, ProjectCodeVisionModel projectModel) {
        this.lifetime = lifetime;
        this.editor = editor2;
        this.projectModel = projectModel;
        this.hovered = this.projectModel.getHoveredInlay();
        this.hoveredEntry = this.projectModel.getHoveredEntry();
        this.lensPopupActive = this.projectModel.getLensPopupActive();
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"editor.contentComponent");
        PropertyCombinatorsKt.map(RdSwingKt.windowAncestor((JComponent)editorComponentImpl), (Function1)1.INSTANCE).view(this.lifetime, (Function2)new Function2<Lifetime, Boolean, Unit>(){

            public final void invoke(@NotNull Lifetime ltmain, boolean inHierarchy) {
                Intrinsics.checkNotNullParameter((Object)ltmain, (String)"ltmain");
                if (inHierarchy) {
                    SourceExKt.adviseWithPrev((ISource)((ISource)hovered), (Lifetime)ltmain, (Function2)1.INSTANCE);
                    hovered.view(ltmain, new Function2<Lifetime, Inlay<?>, Unit>(){

                        public final void invoke(@NotNull Lifetime lt, @Nullable Inlay<?> $noName_1) {
                            Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                            hoveredEntry.view(lt, (Function2)new Function2<Lifetime, CodeVisionEntry, Unit>(){

                                public final void invoke(@NotNull Lifetime entryLifetime, @Nullable CodeVisionEntry $noName_1) {
                                    Intrinsics.checkNotNullParameter((Object)entryLifetime, (String)"entryLifetime");
                                    Inlay inlay = (Inlay)hovered.getValue();
                                    if (inlay != null) {
                                        inlay.repaint();
                                    }
                                    RdSwingKt.mousePressed((Editor)this.getEditor()).advise(entryLifetime, (Function1)new Function1<EditorMouseEvent, Unit>(){

                                        public final void invoke(@NotNull EditorMouseEvent it) {
                                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                            this.entryPressHandler(it);
                                        }
                                    });
                                    RdSwingKt.mouseReleased((Editor)this.getEditor()).advise(entryLifetime, (Function1)new Function1<EditorMouseEvent, Unit>(){

                                        public final void invoke(@NotNull EditorMouseEvent it) {
                                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                            MouseEvent mouseEvent = it.getMouseEvent();
                                            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"it.mouseEvent");
                                            MouseEvent mouseEvent2 = mouseEvent;
                                            if (this.checkEditorMousePosition(mouseEvent2.getPoint()) == null) {
                                                return;
                                            }
                                            if (mouseEvent2.isPopupTrigger()) {
                                                it.consume();
                                            }
                                        }
                                    });
                                }
                            });
                            lensPopupActive.view(lt, (Function2)new Function2<Lifetime, Boolean, Unit>(){

                                public final void invoke(@NotNull Lifetime activePopupLifetime, boolean popupActive) {
                                    Intrinsics.checkNotNullParameter((Object)activePopupLifetime, (String)"activePopupLifetime");
                                    if (!popupActive) {
                                        IPropertyView iPropertyView = (IPropertyView)hoveredEntry;
                                        Duration duration = Duration.ofMillis(1000L);
                                        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofMillis(1000)");
                                        InterfacesKt.viewNotNull((IViewable)((IViewable)AdditionalApiKt.asProperty((ISource)AdditionalApiKt.debounceNotNull((IPropertyView)iPropertyView, (Duration)duration, (IScheduler)SwingScheduler.INSTANCE), null)), (Lifetime)activePopupLifetime, (Function2)((Function2)new Function2<Lifetime, CodeVisionEntry, Unit>(){

                                            public final void invoke(@NotNull Lifetime lt1, @NotNull CodeVisionEntry it) {
                                                Intrinsics.checkNotNullParameter((Object)lt1, (String)"lt1");
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                this.showTooltip(lt1, it);
                                            }
                                        }));
                                    }
                                }
                            });
                        }
                    });
                    PropertyCombinatorsKt.map((IPropertyView)((IPropertyView)hoveredEntry), (Function1)3.INSTANCE).advise(ltmain, (Function1)new Function1<Boolean, Unit>(){

                        public final void invoke(boolean hasHoveredEntry) {
                            this.updateCursor(hasHoveredEntry);
                        }
                    });
                    RdSwingKt.mousePoint((Editor)this.getEditor()).advise(ltmain, (Function1)new Function1<Point, Unit>(){

                        public final void invoke(@Nullable Point it) {
                            this.checkEditorMousePosition(it);
                        }
                    });
                } else {
                    Inlay inlay = (Inlay)hovered.getValue();
                    if (Intrinsics.areEqual((Object)(inlay != null ? inlay.getEditor() : null), (Object)this.getEditor())) {
                        this.clearHovered();
                    }
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        map = new HashMap();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeVisionSelectionController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        CodeVisionSelectionController.logger = logger;
    }

    public /* synthetic */ CodeVisionSelectionController(Lifetime lifetime, EditorImpl editor2, ProjectCodeVisionModel projectModel, DefaultConstructorMarker $constructor_marker) {
        this(lifetime, editor2, projectModel);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionSelectionController$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "map", "Ljava/util/HashMap;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionSelectionController;", "Lkotlin/collections/HashMap;", "getMap", "()Ljava/util/HashMap;", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "projectModel", "Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final HashMap<Editor, CodeVisionSelectionController> getMap() {
            return map;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final void install(@NotNull EditorImpl editor2, @NotNull ProjectCodeVisionModel projectModel) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)projectModel, (String)"projectModel");
            CodeVisionSelectionController controller = this.getMap().get(editor2);
            if (controller != null) {
                return;
            }
            Disposable disposable = editor2.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"editor.disposable");
            Lifetime lifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
            controller = new CodeVisionSelectionController(lifetime, editor2, projectModel, null);
            ((Map)this.getMap()).put(editor2, controller);
            lifetime.onTermination((Function0)new Function0<Unit>(editor2){
                final /* synthetic */ EditorImpl $editor;

                public final void invoke() {
                    CodeVisionSelectionController.Companion.getMap().remove(this.$editor);
                }
                {
                    this.$editor = editorImpl;
                    super(0);
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

