/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.renderers.painters;

import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.model.richText.RichString;
import com.intellij.codeInsight.codeVision.ui.model.richText.RichText;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionTheme;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionThemeInfoProvider;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.ICodeVisionEntryBasePainter;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.paint.EffectPainter2D;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001&B%\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJE\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0%H\u0082\bR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionRichTextPainter;", "T", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/ICodeVisionEntryBasePainter;", "printer", "Lkotlin/Function1;", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;", "theme", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;)V", "getPrinter", "()Lkotlin/jvm/functions/Function1;", "getTheme", "()Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "g", "Ljava/awt/Graphics;", "value", "point", "Ljava/awt/Point;", "state", "Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;", "hovered", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/TextAttributes;Ljava/awt/Graphics;Ljava/lang/Object;Ljava/awt/Point;Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;Z)V", "size", "Ljava/awt/Dimension;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;Ljava/lang/Object;)Ljava/awt/Dimension;", "withColor", "Ljava/awt/Graphics2D;", "targetColor", "Ljava/awt/Color;", "block", "Lkotlin/Function0;", "Companion", "intellij.platform.lang.impl"})
public final class CodeVisionRichTextPainter<T>
implements ICodeVisionEntryBasePainter<T> {
    @NotNull
    private final CodeVisionTheme theme;
    @NotNull
    private final Function1<T, RichText> printer;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final CodeVisionTheme getTheme() {
        return this.theme;
    }

    @Override
    public void paint(@NotNull Editor editor2, @NotNull TextAttributes textAttributes, @NotNull Graphics g, T value, @NotNull Point point, @NotNull RangeCodeVisionModel.InlayState state, boolean hovered2) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        List<RichString> richSegments = ((RichText)this.printer.invoke(value)).getParts();
        boolean $i$f$service = false;
        Class<CodeVisionThemeInfoProvider> serviceClass$iv = CodeVisionThemeInfoProvider.class;
        CodeVisionThemeInfoProvider codeVisionThemeInfoProvider = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (codeVisionThemeInfoProvider == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        CodeVisionThemeInfoProvider themeInfoProvider = codeVisionThemeInfoProvider;
        Color color2 = textAttributes.getBackgroundColor();
        SelectionModel selectionModel = editor2.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
        TextAttributes textAttributes2 = selectionModel.getTextAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"editor.selectionModel.textAttributes");
        boolean inSelectedBlock = Intrinsics.areEqual((Object)color2, (Object)textAttributes2.getBackgroundColor());
        Graphics2D graphics2D = (Graphics2D)g;
        if (inSelectedBlock) {
            SelectionModel selectionModel2 = editor2.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel2, (String)"editor.selectionModel");
            TextAttributes textAttributes3 = selectionModel2.getTextAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes3, (String)"editor.selectionModel.textAttributes");
            color = textAttributes3.getForegroundColor();
            if (color == null) {
                EditorColorsScheme editorColorsScheme = editor2.getColorsScheme();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
                Color color3 = editorColorsScheme.getDefaultForeground();
                color = color3;
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"editor.colorsScheme.defaultForeground");
            }
        } else {
            color = themeInfoProvider.foregroundColor(editor2, hovered2);
        }
        graphics2D.setColor(color);
        int x = point.x + this.theme.getLeft();
        int y = point.y + this.theme.getTop();
        int xOffset = x;
        Color underlineColor = null;
        Iterable $this$forEach$iv = richSegments;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            RichString it = (RichString)element$iv;
            boolean bl = false;
            if (it.getAttributes().getBgColor() != null) {
                logger.error("Rich text renderer doesn't support background colors currently");
            }
            if (it.getAttributes().getWaveColor() != null) {
                logger.error("Rich text renderer doesn't support effect colors currently");
            }
            Color foregroundColor = it.getAttributes().getFgColor();
            if (underlineColor == null) {
                underlineColor = foregroundColor;
            } else if (Intrinsics.areEqual((Object)underlineColor, (Object)foregroundColor) ^ true) {
                underlineColor = ((Graphics2D)g).getColor();
            }
            Font font = themeInfoProvider.font(editor2, it.getAttributes().getFontStyle());
            ((Graphics2D)g).setFont(font);
            CodeVisionRichTextPainter codeVisionRichTextPainter = this;
            Object g$iv = (Graphics2D)g;
            boolean $i$f$withColor = false;
            Color curColor$iv = ((Graphics)g$iv).getColor();
            Color color4 = foregroundColor;
            if (color4 == null) {
                color4 = ((Graphics)g$iv).getColor();
            }
            ((Graphics)g$iv).setColor(color4);
            boolean bl2 = false;
            g.drawString(it.getText(), xOffset, y);
            ((Graphics)g$iv).setColor(curColor$iv);
            FontMetrics metrics = ((Graphics2D)g).getFontMetrics();
            if (it.getAttributes().isStrikeout()) {
                g$iv = this;
                Graphics2D g$iv2 = (Graphics2D)g;
                boolean $i$f$withColor2 = false;
                Color curColor$iv2 = g$iv2.getColor();
                Color color5 = foregroundColor;
                if (color5 == null) {
                    color5 = g$iv2.getColor();
                }
                g$iv2.setColor(color5);
                boolean bl3 = false;
                EffectPainter2D.STRIKE_THROUGH.paint((Graphics2D)g, (double)xOffset, (double)(y + JBUI.scale(1)), (double)metrics.stringWidth(it.getText()), 5.0, (Object)((Graphics2D)g).getFont());
                g$iv2.setColor(curColor$iv2);
            }
            xOffset += metrics.stringWidth(it.getText());
        }
        if (hovered2) {
            Dimension size = this.size(editor2, state, value);
            CodeVisionRichTextPainter $i$f$forEach2 = this;
            Color targetColor$iv = underlineColor;
            boolean $i$f$withColor = false;
            Color curColor$iv = ((Graphics2D)g).getColor();
            Graphics2D graphics2D2 = (Graphics2D)g;
            Color color6 = targetColor$iv;
            if (color6 == null) {
                color6 = ((Graphics2D)g).getColor();
            }
            graphics2D2.setColor(color6);
            boolean bl = false;
            EffectPainter2D.LINE_UNDERSCORE.paint((Graphics2D)g, (double)x, (double)(y + JBUI.scale(1)), (double)size.width, 5.0, (Object)((Graphics2D)g).getFont());
            ((Graphics2D)g).setColor(curColor$iv);
        }
    }

    private final void withColor(Graphics2D g, Color targetColor, Function0<Unit> block) {
        int $i$f$withColor = 0;
        Color curColor = g.getColor();
        Color color = targetColor;
        if (color == null) {
            color = g.getColor();
        }
        g.setColor(color);
        block.invoke();
        g.setColor(curColor);
    }

    @Override
    @NotNull
    public Dimension size(@NotNull Editor editor2, @NotNull RangeCodeVisionModel.InlayState state, T value) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        List<RichString> richSegments = ((RichText)this.printer.invoke(value)).getParts();
        int width = this.theme.getLeft();
        int height = this.theme.getTop();
        boolean $i$f$service = false;
        Class<CodeVisionThemeInfoProvider> serviceClass$iv = CodeVisionThemeInfoProvider.class;
        CodeVisionThemeInfoProvider codeVisionThemeInfoProvider = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (codeVisionThemeInfoProvider == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        CodeVisionThemeInfoProvider themeInfoProvider = codeVisionThemeInfoProvider;
        Iterable $this$forEach$iv = richSegments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RichString it = (RichString)element$iv;
            boolean bl = false;
            Font font = themeInfoProvider.font(editor2, it.getAttributes().getFontStyle());
            FontMetrics metrics = editor2.getComponent().getFontMetrics(font);
            width += metrics.stringWidth(it.getText());
            int n = height;
            FontMetrics fontMetrics = metrics;
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"metrics");
            int n2 = fontMetrics.getHeight();
            height = Math.max(n, n2);
        }
        return new Dimension(width + this.theme.getRight(), height + this.theme.getBottom());
    }

    @NotNull
    public final Function1<T, RichText> getPrinter() {
        return this.printer;
    }

    public CodeVisionRichTextPainter(@NotNull Function1<? super T, ? extends RichText> printer, @Nullable CodeVisionTheme theme) {
        Intrinsics.checkNotNullParameter(printer, (String)"printer");
        this.printer = printer;
        CodeVisionTheme codeVisionTheme = theme;
        if (codeVisionTheme == null) {
            codeVisionTheme = new CodeVisionTheme(0, 0, 0, 0, 0, 31, null);
        }
        this.theme = codeVisionTheme;
    }

    public /* synthetic */ CodeVisionRichTextPainter(Function1 function1, CodeVisionTheme codeVisionTheme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            codeVisionTheme = null;
        }
        this(function1, codeVisionTheme);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(CodeVisionRichTextPainter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(CodeV\u2026hTextPainter::class.java)");
        CodeVisionRichTextPainter.logger = logger;
    }

    @Override
    @NotNull
    public Icon toIcon(@NotNull Editor editor2, @NotNull TextAttributes textAttributes, T value, @NotNull RangeCodeVisionModel.InlayState state, boolean hovered2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return ICodeVisionEntryBasePainter.DefaultImpls.toIcon(this, editor2, textAttributes, value, state, hovered2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionRichTextPainter$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

