/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.RangeMarkerSpy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.ImmutableCharSequence;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;

final class CompletionAssertions {
    CompletionAssertions() {
    }

    static void assertCommitSuccessful(Editor editor2, PsiFile psiFile) {
        FileASTNode node2;
        boolean committed;
        Document document = editor2.getDocument();
        int docLength = document.getTextLength();
        int psiLength = psiFile.getTextLength();
        PsiDocumentManager manager = PsiDocumentManager.getInstance(psiFile.getProject());
        boolean bl = committed = !manager.isUncommited(document);
        if (docLength == psiLength && committed) {
            return;
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        Object message2 = "unsuccessful commit:";
        message2 = (String)message2 + "\nmatching=" + (psiFile == manager.getPsiFile(document));
        message2 = (String)message2 + "\ninjectedEditor=" + (editor2 instanceof EditorWindow);
        message2 = (String)message2 + "\ninjectedFile=" + InjectedLanguageManager.getInstance(psiFile.getProject()).isInjectedFragment(psiFile);
        message2 = (String)message2 + "\ncommitted=" + committed;
        message2 = (String)message2 + "\nfile=" + psiFile.getName();
        message2 = (String)message2 + "\nfile class=" + psiFile.getClass();
        message2 = (String)message2 + "\nfile.valid=" + psiFile.isValid();
        message2 = (String)message2 + "\nfile.physical=" + psiFile.isPhysical();
        message2 = (String)message2 + "\nfile.eventSystemEnabled=" + viewProvider.isEventSystemEnabled();
        message2 = (String)message2 + "\nlanguage=" + psiFile.getLanguage();
        message2 = (String)message2 + "\ndoc.length=" + docLength;
        message2 = (String)message2 + "\npsiFile.length=" + psiLength;
        String fileText = psiFile.getText();
        if (fileText != null) {
            message2 = (String)message2 + "\npsiFile.text.length=" + fileText.length();
        }
        if ((node2 = psiFile.getNode()) != null) {
            message2 = (String)message2 + "\nnode.length=" + node2.getTextLength();
            String nodeText = node2.getText();
            message2 = (String)message2 + "\nnode.text.length=" + nodeText.length();
        }
        VirtualFile virtualFile2 = viewProvider.getVirtualFile();
        message2 = (String)message2 + "\nvirtualFile=" + virtualFile2;
        message2 = (String)message2 + "\nvirtualFile.class=" + virtualFile2.getClass();
        message2 = (String)message2 + "\n" + DebugUtil.currentStackTrace();
        throw new RuntimeExceptionWithAttachments("Commit unsuccessful", (String)message2, new Attachment(virtualFile2.getPath() + "_file.txt", StringUtil.notNullize(fileText)), CompletionAssertions.createAstAttachment(psiFile, psiFile), new Attachment("docText.txt", document.getText()));
    }

    static void checkEditorValid(Editor editor2) {
        if (!CompletionAssertions.isEditorValid(editor2)) {
            throw new AssertionError();
        }
    }

    static boolean isEditorValid(Editor editor2) {
        return !(editor2 instanceof EditorWindow) || ((EditorWindow)editor2).isValid();
    }

    private static Attachment createAstAttachment(PsiFile fileCopy, PsiFile originalFile) {
        return new Attachment(originalFile.getViewProvider().getVirtualFile().getPath() + " syntactic tree.txt", DebugUtil.psiToString(fileCopy, true, true));
    }

    private static Attachment createFileTextAttachment(PsiFile fileCopy, PsiFile originalFile) {
        return new Attachment(originalFile.getViewProvider().getVirtualFile().getPath(), fileCopy.getText());
    }

    static void assertInjectedOffsets(int hostStartOffset, PsiFile injected, DocumentWindow documentWindow) {
        assert (documentWindow != null) : "no DocumentWindow for an injected fragment";
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(injected.getProject());
        TextRange injectedRange = injected.getTextRange();
        int hostMinOffset = injectedLanguageManager.injectedToHost(injected, injectedRange.getStartOffset(), true);
        int hostMaxOffset = injectedLanguageManager.injectedToHost(injected, injectedRange.getEndOffset(), false);
        assert (hostStartOffset >= hostMinOffset) : "startOffset before injected";
        assert (hostStartOffset <= hostMaxOffset) : "startOffset after injected";
    }

    static void assertHostInfo(PsiFile hostCopy, OffsetMap hostMap) {
        PsiUtilCore.ensureValid(hostCopy);
        if (hostMap.getOffset(CompletionInitializationContext.START_OFFSET) > hostCopy.getTextLength()) {
            throw new AssertionError((Object)("startOffset outside the host file: " + hostMap.getOffset(CompletionInitializationContext.START_OFFSET) + "; " + hostCopy));
        }
    }

    @Contract(value="_,_,_,null->fail")
    static void assertCompletionPositionPsiConsistent(OffsetsInFile offsets2, int offset, PsiFile originalFile, PsiElement insertedElement) {
        PsiFile fileCopy = offsets2.getFile();
        if (insertedElement == null) {
            throw new RuntimeExceptionWithAttachments("No element at insertion offset", "offset=" + offset, CompletionAssertions.createFileTextAttachment(fileCopy, originalFile), CompletionAssertions.createAstAttachment(fileCopy, originalFile));
        }
        TextRange range = insertedElement.getTextRange();
        CharSequence fileCopyText = fileCopy.getViewProvider().getContents();
        if (range.getEndOffset() > fileCopyText.length() || !CompletionAssertions.isEquals(fileCopyText.subSequence(range.getStartOffset(), range.getEndOffset()), insertedElement.getNode().getChars())) {
            throw new RuntimeExceptionWithAttachments("Inconsistent completion tree", "range=" + range, CompletionAssertions.createFileTextAttachment(fileCopy, originalFile), CompletionAssertions.createAstAttachment(fileCopy, originalFile), new Attachment("Element at caret.txt", insertedElement.getText()));
        }
    }

    private static boolean isEquals(CharSequence left, CharSequence right) {
        if (left == right) {
            return true;
        }
        if (left instanceof ImmutableCharSequence && right instanceof ImmutableCharSequence) {
            return left.equals(right);
        }
        return left.toString().equals(right.toString());
    }

    static void assertCorrectOriginalFile(@NonNls String prefix, PsiFile file2, PsiFile copy) {
        if (copy.getOriginalFile() != file2) {
            throw new AssertionError((Object)(prefix + " copied file doesn't have correct original: noOriginal=" + (copy.getOriginalFile() == copy) + "\n file " + CompletionAssertions.fileInfo(file2) + "\n copy " + CompletionAssertions.fileInfo(copy)));
        }
    }

    @NonNls
    private static String fileInfo(PsiFile file2) {
        return file2 + " of " + file2.getClass() + " in " + file2.getViewProvider() + ", languages=" + file2.getViewProvider().getLanguages() + ", physical=" + file2.isPhysical();
    }

    static class WatchingInsertionContext
    extends InsertionContext
    implements Disposable {
        private RangeMarkerEx tailWatcher;
        Throwable invalidateTrace;
        DocumentEvent killer;
        private RangeMarkerSpy spy;

        WatchingInsertionContext(OffsetMap offsetMap, PsiFile file2, char completionChar, List<LookupElement> items, Editor editor2) {
            super(offsetMap, completionChar, items.toArray(LookupElement.EMPTY_ARRAY), file2, editor2, WatchingInsertionContext.shouldAddCompletionChar(completionChar));
        }

        @Override
        public void setTailOffset(int offset) {
            super.setTailOffset(offset);
            this.watchTail(offset);
        }

        private void watchTail(int offset) {
            this.stopWatching();
            this.tailWatcher = (RangeMarkerEx)this.getDocument().createRangeMarker(offset, offset);
            if (!this.tailWatcher.isValid()) {
                throw new AssertionError((Object)(this.getDocument() + "; offset=" + offset));
            }
            this.tailWatcher.setGreedyToRight(true);
            this.spy = new RangeMarkerSpy(this.tailWatcher){

                @Override
                protected void invalidated(DocumentEvent e) {
                    if (invalidateTrace == null) {
                        invalidateTrace = new Throwable();
                        killer = e;
                    }
                }
            };
            this.getDocument().addDocumentListener(this.spy);
        }

        void stopWatching() {
            if (this.tailWatcher != null) {
                this.getDocument().removeDocumentListener(this.spy);
                this.tailWatcher.dispose();
            }
        }

        @Override
        public int getTailOffset() {
            if (!this.getOffsetMap().containsOffset(TAIL_OFFSET) && this.invalidateTrace != null) {
                throw new RuntimeExceptionWithAttachments("Tail offset invalid", new Attachment("invalidated", this.invalidateTrace));
            }
            int offset = super.getTailOffset();
            if (this.tailWatcher.getStartOffset() != this.tailWatcher.getEndOffset() && offset > 0) {
                this.watchTail(offset);
            }
            return offset;
        }

        @Override
        public void dispose() {
            this.stopWatching();
        }
    }
}

