/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.ActionTracker;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionConfidenceEP;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.event.FocusEvent;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionPhase
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CompletionPhase.class);
    public static final CompletionPhase NoCompletion = new CompletionPhase(null){

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            return time;
        }

        public String toString() {
            return "NoCompletion";
        }
    };
    public final CompletionProgressIndicator indicator;

    protected CompletionPhase(@Nullable CompletionProgressIndicator indicator) {
        this.indicator = indicator;
    }

    @Override
    public void dispose() {
    }

    public abstract int newCompletionStarted(int var1, boolean var2);

    public static class EmptyAutoPopup
    extends ZombiePhase {
        private final ActionTracker myTracker;
        private final Editor myEditor;
        private final Set<Pair<Integer, ElementPattern<String>>> myRestartingPrefixConditions;

        EmptyAutoPopup(Editor editor2, Set<Pair<Integer, ElementPattern<String>>> restartingPrefixConditions) {
            super(null);
            this.myTracker = new ActionTracker(editor2, this);
            this.myEditor = editor2;
            this.myRestartingPrefixConditions = restartingPrefixConditions;
        }

        public boolean allowsSkippingNewAutoPopup(@NotNull Editor editor2, char toType) {
            if (editor2 == null) {
                EmptyAutoPopup.$$$reportNull$$$0(0);
            }
            if (this.myEditor == editor2 && !this.myTracker.hasAnythingHappened() && !CompletionProgressIndicator.shouldRestartCompletion(editor2, this.myRestartingPrefixConditions, String.valueOf(toType))) {
                this.myTracker.ignoreCurrentDocumentChange();
                return true;
            }
            return false;
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            return time;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CompletionPhase$EmptyAutoPopup", "allowsSkippingNewAutoPopup"));
        }
    }

    public static class NoSuggestionsHint
    extends ZombiePhase {
        NoSuggestionsHint(@Nullable LightweightHint hint, CompletionProgressIndicator indicator) {
            super(indicator);
            this.expireOnAnyEditorChange(indicator.getEditor());
            if (hint != null) {
                HintListener hintListener = event -> CompletionServiceImpl.setCompletionPhase(NoCompletion);
                hint.addHintListener(hintListener);
                Disposer.register(this, () -> hint.removeHintListener(hintListener));
            }
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static class InsertedSingleItem
    extends ZombiePhase {
        public final Runnable restorePrefix;

        InsertedSingleItem(CompletionProgressIndicator indicator, Runnable restorePrefix) {
            super(indicator);
            this.restorePrefix = restorePrefix;
            this.expireOnAnyEditorChange(indicator.getEditor());
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            if (repeated) {
                this.indicator.restorePrefix(this.restorePrefix);
            }
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static abstract class ZombiePhase
    extends CompletionPhase {
        ZombiePhase(CompletionProgressIndicator indicator) {
            super(indicator);
        }

        void expireOnAnyEditorChange(@NotNull Editor editor2) {
            if (editor2 == null) {
                ZombiePhase.$$$reportNull$$$0(0);
            }
            editor2.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void beforeDocumentChange(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/completion/CompletionPhase$ZombiePhase$1", "beforeDocumentChange"));
                }
            }, this);
            editor2.getSelectionModel().addSelectionListener(new SelectionListener(){

                public void selectionChanged(@NotNull SelectionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/completion/CompletionPhase$ZombiePhase$2", "selectionChanged"));
                }
            }, (Disposable)this);
            editor2.getCaretModel().addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/completion/CompletionPhase$ZombiePhase$3", "caretPositionChanged"));
                }
            }, (Disposable)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CompletionPhase$ZombiePhase", "expireOnAnyEditorChange"));
        }
    }

    public static class ItemsCalculated
    extends CompletionPhase {
        public ItemsCalculated(CompletionProgressIndicator indicator) {
            super(indicator);
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            this.indicator.closeAndFinish(false);
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static class BgCalculation
    extends CompletionPhase {
        boolean modifiersChanged = false;
        @NotNull
        private final ClientId ownerId = ClientId.getCurrent();

        public BgCalculation(final CompletionProgressIndicator indicator) {
            super(indicator);
            ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

                @Override
                public void beforeWriteActionStart(@NotNull Object action2) {
                    if (action2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!indicator.getLookup().isLookupDisposed() && !indicator.isCanceled() && ownerId.equals(ClientId.getCurrent())) {
                        indicator.scheduleRestart();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/completion/CompletionPhase$BgCalculation$1", "beforeWriteActionStart"));
                }
            }, this);
            if (indicator.isAutopopupCompletion()) {
                ((EditorEx)indicator.getEditor()).addFocusListener(new FocusChangeListener(){

                    public void focusLost(@NotNull Editor editor2, @NotNull FocusEvent event) {
                        if (editor2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (event == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (ScreenReader.isActive() && event.getOppositeComponent() != null && indicator.getLookup().getComponent() != null && SwingUtilities.getWindowAncestor(event.getOppositeComponent()) == SwingUtilities.getWindowAncestor(indicator.getLookup().getComponent())) {
                            return;
                        }
                        indicator.closeAndFinish(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "editor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/codeInsight/completion/CompletionPhase$BgCalculation$2";
                        objectArray[2] = "focusLost";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, (Disposable)this);
            }
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            this.indicator.closeAndFinish(false);
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static class Synchronous
    extends CompletionPhase {
        public Synchronous(CompletionProgressIndicator indicator) {
            super(indicator);
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.assertPhase(NoCompletion.getClass());
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            return time;
        }
    }

    public static class CommittingDocuments
    extends CompletionPhase {
        private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor("Completion Preparation", 1);
        boolean replaced;
        private final ActionTracker myTracker;

        CommittingDocuments(@Nullable CompletionProgressIndicator prevIndicator, @NotNull Editor editor2) {
            if (editor2 == null) {
                CommittingDocuments.$$$reportNull$$$0(0);
            }
            super(prevIndicator);
            this.myTracker = new ActionTracker(editor2, this);
        }

        public void ignoreCurrentDocumentChange() {
            this.myTracker.ignoreCurrentDocumentChange();
        }

        private boolean isExpired() {
            return this.myTracker.hasAnythingHappened();
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            return time;
        }

        @Override
        public void dispose() {
            if (!this.replaced && this.indicator != null) {
                this.indicator.closeAndFinish(true);
            }
        }

        public String toString() {
            return "CommittingDocuments{hasIndicator=" + (this.indicator != null) + "}";
        }

        @ApiStatus.Internal
        public static void scheduleAsyncCompletion(@NotNull Editor _editor, @NotNull CompletionType completionType, @Nullable Condition<? super PsiFile> condition, @NotNull Project project2, @Nullable CompletionProgressIndicator prevIndicator) {
            if (_editor == null) {
                CommittingDocuments.$$$reportNull$$$0(1);
            }
            if (completionType == null) {
                CommittingDocuments.$$$reportNull$$$0(2);
            }
            if (project2 == null) {
                CommittingDocuments.$$$reportNull$$$0(3);
            }
            Editor topLevelEditor = InjectedLanguageEditorUtil.getTopLevelEditor(_editor);
            int offset = topLevelEditor.getCaretModel().getOffset();
            CommittingDocuments phase = new CommittingDocuments(prevIndicator, topLevelEditor);
            CompletionServiceImpl.setCompletionPhase(phase);
            phase.ignoreCurrentDocumentChange();
            boolean autopopup = prevIndicator == null || prevIndicator.isAutopopupCompletion();
            ReadAction.nonBlocking(() -> {
                if (phase.isExpired()) {
                    return null;
                }
                PsiFile topLevelFile = PsiDocumentManager.getInstance(project2).getPsiFile(topLevelEditor.getDocument());
                Editor completionEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(topLevelEditor, topLevelFile, offset);
                PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(completionEditor.getDocument());
                if (file2 == null || autopopup && CommittingDocuments.shouldSkipAutoPopup(completionEditor, file2) || condition != null && !condition.value(file2)) {
                    return null;
                }
                CommittingDocuments.loadContributorsOutsideEdt(completionEditor, file2);
                return completionEditor;
            }).withDocumentsCommitted(project2).expireWith(phase).finishOnUiThread(ModalityState.current(), completionEditor -> {
                if (completionEditor != null && !phase.isExpired()) {
                    int time = prevIndicator == null ? 0 : prevIndicator.getInvocationCount();
                    CodeCompletionHandlerBase handler = CodeCompletionHandlerBase.createHandler(completionType, false, autopopup, false);
                    handler.invokeCompletion(project2, (Editor)completionEditor, time, false);
                } else if (phase == CompletionServiceImpl.getCompletionPhase()) {
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }
            }).submit(ourExecutor);
        }

        @ApiStatus.Internal
        public static void loadContributorsOutsideEdt(Editor editor2, PsiFile file2) {
            CompletionContributor.forLanguage(PsiUtilCore.getLanguageAtOffset(file2, editor2.getCaretModel().getOffset()));
        }

        @ApiStatus.Internal
        public static boolean shouldSkipAutoPopup(Editor editor2, PsiFile psiFile) {
            int offset = editor2.getCaretModel().getOffset();
            int psiOffset = Math.max(0, offset - 1);
            PsiElement elementAt2 = psiFile.findElementAt(psiOffset);
            if (elementAt2 == null) {
                return true;
            }
            Language language = PsiUtilCore.findLanguageFromElement(elementAt2);
            for (CompletionConfidence confidence : CompletionConfidenceEP.forLanguage(language)) {
                try {
                    ThreeState result2 = confidence.shouldSkipAutopopup(elementAt2, psiFile, offset);
                    if (result2 == ThreeState.UNSURE) continue;
                    LOG.debug(confidence + " has returned shouldSkipAutopopup=" + result2);
                    return result2 == ThreeState.YES;
                }
                catch (IndexNotReadyException e) {
                    LOG.debug(e);
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/completion/CompletionPhase$CommittingDocuments";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "scheduleAsyncCompletion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

