/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CamelHumpMatcher
extends PrefixMatcher {
    private final MinusculeMatcher myMatcher;
    private final MinusculeMatcher myCaseInsensitiveMatcher;
    private final boolean myCaseSensitive;
    private static boolean ourForceStartMatching;
    private final boolean myTypoTolerant;

    public CamelHumpMatcher(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(0);
        }
        this(prefix, true);
    }

    public CamelHumpMatcher(String prefix, boolean caseSensitive) {
        this(prefix, caseSensitive, false);
    }

    @ApiStatus.Internal
    public CamelHumpMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        super(prefix);
        this.myCaseSensitive = caseSensitive;
        this.myTypoTolerant = typoTolerant;
        this.myMatcher = this.createMatcher(this.myCaseSensitive);
        this.myCaseInsensitiveMatcher = this.createMatcher(false);
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    @Override
    public boolean isStartMatch(String name2) {
        return this.myMatcher.isStartMatch(name2);
    }

    @Override
    public boolean isStartMatch(LookupElement element2) {
        for (String s : CompletionUtil.iterateLookupStrings(element2)) {
            FList ranges2 = this.myCaseInsensitiveMatcher.matchingFragments(s);
            if (ranges2 == null || !ranges2.isEmpty() && CamelHumpMatcher.skipUnderscores(s) < ((TextRange)ranges2.get(0)).getStartOffset()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean isTypoTolerant() {
        return this.myTypoTolerant;
    }

    private static int skipUnderscores(@NotNull String name2) {
        if (name2 == null) {
            CamelHumpMatcher.$$$reportNull$$$0(1);
        }
        return CharArrayUtil.shiftForward(name2, 0, "_");
    }

    @Override
    public boolean prefixMatches(@NotNull String name2) {
        if (name2 == null) {
            CamelHumpMatcher.$$$reportNull$$$0(2);
        }
        if (name2.startsWith("_") && CodeInsightSettings.getInstance().getCompletionCaseSensitive() == 3 && this.firstLetterCaseDiffers(name2)) {
            return false;
        }
        return this.myMatcher.matches(name2);
    }

    private boolean firstLetterCaseDiffers(String name2) {
        int nameFirst = CamelHumpMatcher.skipUnderscores(name2);
        int prefixFirst = CamelHumpMatcher.skipUnderscores(this.myPrefix);
        return nameFirst < name2.length() && prefixFirst < this.myPrefix.length() && CamelHumpMatcher.caseDiffers(name2.charAt(nameFirst), this.myPrefix.charAt(prefixFirst));
    }

    private static boolean caseDiffers(char c1, char c2) {
        return Character.isLowerCase(c1) != Character.isLowerCase(c2) || Character.isUpperCase(c1) != Character.isUpperCase(c2);
    }

    @Override
    public boolean prefixMatches(@NotNull LookupElement element2) {
        if (element2 == null) {
            CamelHumpMatcher.$$$reportNull$$$0(3);
        }
        return this.prefixMatchersInternal(element2, !element2.isCaseSensitive());
    }

    private boolean prefixMatchersInternal(LookupElement element2, boolean itemCaseInsensitive) {
        for (String name2 : element2.getAllLookupStrings()) {
            if (itemCaseInsensitive && StringUtil.startsWithIgnoreCase(name2, this.myPrefix) || this.prefixMatches(name2)) {
                return true;
            }
            if (!itemCaseInsensitive || 1 == CodeInsightSettings.getInstance().getCompletionCaseSensitive() || !this.myCaseInsensitiveMatcher.matches(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(4);
        }
        if (prefix.equals(this.myPrefix)) {
            CamelHumpMatcher camelHumpMatcher = this;
            if (camelHumpMatcher == null) {
                CamelHumpMatcher.$$$reportNull$$$0(5);
            }
            return camelHumpMatcher;
        }
        return new CamelHumpMatcher(prefix, this.myCaseSensitive, this.myTypoTolerant);
    }

    private MinusculeMatcher createMatcher(boolean caseSensitive) {
        String prefix = CamelHumpMatcher.applyMiddleMatching(this.myPrefix);
        NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)prefix);
        if (caseSensitive) {
            int setting = CodeInsightSettings.getInstance().getCompletionCaseSensitive();
            if (setting == 3) {
                builder2 = builder2.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.FIRST_LETTER);
            } else if (setting == 1) {
                builder2 = builder2.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.ALL);
            }
        }
        if (this.myTypoTolerant) {
            builder2 = builder2.typoTolerant();
        }
        return builder2.build();
    }

    public static String applyMiddleMatching(String prefix) {
        if (Registry.is("ide.completion.middle.matching") && !prefix.isEmpty() && !ourForceStartMatching) {
            return "*" + StringUtil.replace(prefix, ".", ". ").trim();
        }
        return prefix;
    }

    public String toString() {
        return this.myPrefix;
    }

    @Deprecated
    @TestOnly
    public static void forceStartMatching(Disposable parent) {
        ourForceStartMatching = true;
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                ourForceStartMatching = false;
            }
        });
    }

    @Override
    public int matchingDegree(String string2) {
        return this.matchingDegree(string2, this.matchingFragments(string2));
    }

    @Nullable
    public FList<TextRange> matchingFragments(String string2) {
        return this.myMatcher.matchingFragments(string2);
    }

    public int matchingDegree(String string2, @Nullable FList<? extends TextRange> fragments) {
        int matchStart;
        FList ciRanges;
        int underscoreEnd = CamelHumpMatcher.skipUnderscores(string2);
        if (underscoreEnd > 0 && (ciRanges = this.myCaseInsensitiveMatcher.matchingFragments(string2)) != null && !ciRanges.isEmpty() && (matchStart = ((TextRange)ciRanges.get(0)).getStartOffset()) > 0 && matchStart <= underscoreEnd) {
            return this.myCaseInsensitiveMatcher.matchingDegree(string2.substring(matchStart), true) - 1;
        }
        return this.myMatcher.matchingDegree(string2, true, fragments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipUnderscores";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

