/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class AnnotatorStatisticsCollector {
    private final Map<Annotator, DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics> myAnnotatorStats = new ConcurrentHashMap<Annotator, DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics>();

    public void reportAnnotationProduced(@NotNull Annotator annotator, @NotNull Annotation annotation) {
        if (annotator == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(1);
        }
        DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics stat = this.myAnnotatorStats.computeIfAbsent(annotator, __ -> new DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics(annotator));
        if (stat.firstAnnotation == null) {
            stat.firstAnnotation = annotation;
            stat.firstAnnotationStamp = System.nanoTime();
        }
        stat.lastAnnotation = annotation;
        stat.lastAnnotationStamp = System.nanoTime();
    }

    public void reportAnalysisFinished(@NotNull Project project2, @NotNull AnnotationSession session, @NotNull PsiFile file2) {
        if (project2 == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(2);
        }
        if (session == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(4);
        }
        for (DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics stat : this.myAnnotatorStats.values()) {
            stat.annotatorFinishStamp = System.nanoTime();
        }
        project2.getMessageBus().syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC).daemonAnnotatorStatisticsGenerated(session, this.myAnnotatorStats.values(), file2);
        this.myAnnotatorStats.clear();
    }

    public void reportNewAnnotatorCreated(@NotNull Annotator annotator) {
        if (annotator == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(5);
        }
        DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics stat = this.myAnnotatorStats.computeIfAbsent(annotator, __ -> new DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics(annotator));
        stat.annotatorStartStamp = System.nanoTime();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/AnnotatorStatisticsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reportAnnotationProduced";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportAnalysisFinished";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportNewAnnotatorCreated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

