/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class DaemonCodeAnalyzer {
    public static final Topic<DaemonListener> DAEMON_EVENT_TOPIC = new Topic<DaemonListener>(DaemonListener.class, Topic.BroadcastDirection.NONE, true);

    public static DaemonCodeAnalyzer getInstance(Project project2) {
        return project2.getComponent(DaemonCodeAnalyzer.class);
    }

    public abstract void settingsChanged();

    public abstract void setUpdateByTimerEnabled(boolean var1);

    public abstract void disableUpdateByTimer(@NotNull Disposable var1);

    public abstract boolean isHighlightingAvailable(@NotNull PsiFile var1);

    public abstract void setImportHintsEnabled(@NotNull PsiFile var1, boolean var2);

    public abstract void resetImportHintsEnabledForProject();

    public abstract void setHighlightingEnabled(@NotNull PsiFile var1, boolean var2);

    public abstract boolean isImportHintsEnabled(@NotNull PsiFile var1);

    public abstract boolean isAutohintsAvailable(@NotNull PsiFile var1);

    public abstract void restart();

    public abstract void restart(@NotNull PsiFile var1);

    public abstract void autoImportReferenceAtCursor(@NotNull Editor var1, @NotNull PsiFile var2);

    public static interface DaemonListener {
        default public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
            if (fileEditors == null) {
                DaemonListener.$$$reportNull$$$0(0);
            }
        }

        default public void daemonFinished() {
        }

        default public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
            if (fileEditors == null) {
                DaemonListener.$$$reportNull$$$0(1);
            }
            this.daemonFinished();
        }

        default public void daemonCancelEventOccurred(@NotNull String reason) {
            if (reason == null) {
                DaemonListener.$$$reportNull$$$0(2);
            }
        }

        @ApiStatus.Internal
        default public void daemonAnnotatorStatisticsGenerated(@NotNull AnnotationSession session, @NotNull Collection<? extends AnnotatorStatistics> statistics, @NotNull PsiFile file2) {
            if (session == null) {
                DaemonListener.$$$reportNull$$$0(3);
            }
            if (statistics == null) {
                DaemonListener.$$$reportNull$$$0(4);
            }
            if (file2 == null) {
                DaemonListener.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statistics";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "daemonStarting";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "daemonFinished";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "daemonCancelEventOccurred";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "daemonAnnotatorStatisticsGenerated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        @ApiStatus.Internal
        public static class AnnotatorStatistics {
            public final Annotator annotator;
            public long annotatorStartStamp;
            public long firstAnnotationStamp;
            public Annotation firstAnnotation;
            public long lastAnnotationStamp;
            public Annotation lastAnnotation;
            public long annotatorFinishStamp;

            AnnotatorStatistics(@NotNull Annotator annotator) {
                if (annotator == null) {
                    AnnotatorStatistics.$$$reportNull$$$0(0);
                }
                this.annotator = annotator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener$AnnotatorStatistics", "<init>"));
            }
        }
    }
}

