/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Function;
import java.awt.Color;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkerInfo<T extends PsiElement> {
    private static final Logger LOG = Logger.getInstance(LineMarkerInfo.class);
    protected final Icon myIcon;
    @NotNull
    private final SmartPsiElementPointer<? extends T> elementRef;
    public final int startOffset;
    public final int endOffset;
    public Color separatorColor;
    public SeparatorPlacement separatorPlacement;
    public RangeHighlighter highlighter;
    public int updatePass;
    private final Function<? super T, @NlsContexts.Tooltip String> myTooltipProvider;
    private final Supplier<@Nls @NotNull String> myAccessibleNameProvider;
    private AnAction myNavigateAction;
    @NotNull
    private final GutterIconRenderer.Alignment myIconAlignment;
    private final GutterIconNavigationHandler<T> myNavigationHandler;

    public LineMarkerInfo(@NotNull T element2, @NotNull TextRange range, @NotNull Icon icon2, @Nullable Function<? super T, @NlsContexts.Tooltip String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment, @NotNull @NotNull Supplier<@NotNull @Nls String> accessibleNameProvider) {
        if (element2 == null) {
            LineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(1);
        }
        if (icon2 == null) {
            LineMarkerInfo.$$$reportNull$$$0(2);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(3);
        }
        if (accessibleNameProvider == null) {
            LineMarkerInfo.$$$reportNull$$$0(4);
        }
        this((T)element2, range, icon2, accessibleNameProvider, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
    }

    public LineMarkerInfo(@NotNull T element2, @NotNull TextRange range) {
        if (element2 == null) {
            LineMarkerInfo.$$$reportNull$$$0(5);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(6);
        }
        this(element2, range, null, null, null, null, GutterIconRenderer.Alignment.RIGHT);
    }

    @Deprecated
    public LineMarkerInfo(@NotNull T element2, @NotNull TextRange range, @Nullable Icon icon2, @Nullable Function<? super T, @NlsContexts.Tooltip String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element2 == null) {
            LineMarkerInfo.$$$reportNull$$$0(7);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(8);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(9);
        }
        this((T)element2, range, icon2, null, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
    }

    @NotNull
    private static <T extends PsiElement> SmartPsiElementPointer<T> createElementRef(@NotNull T element2, @NotNull TextRange range) {
        PsiElement firstChild;
        PsiFile containingFile;
        Project project2;
        TextRange topLevelRange;
        if (element2 == null) {
            LineMarkerInfo.$$$reportNull$$$0(10);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(11);
        }
        if (!(topLevelRange = InjectedLanguageManager.getInstance(project2 = (containingFile = element2.getContainingFile()).getProject()).getTopLevelFile(containingFile).getTextRange()).contains(range)) {
            throw new IllegalArgumentException("Range must be inside file offsets " + topLevelRange + " but got: " + range);
        }
        if (!(element2 instanceof PsiFile) && (firstChild = element2.getFirstChild()) != null) {
            String msg = "Performance warning: LineMarker is supposed to be registered for leaf elements only, but got: " + element2 + " (" + element2.getClass() + ") instead. First child: " + firstChild + " (" + firstChild.getClass() + ")\nPlease see LineMarkerProvider#getLineMarkerInfo(PsiElement) javadoc for detailed explanations.";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(msg);
            } else {
                LOG.warn(msg);
            }
        }
        SmartPsiElementPointer<T> smartPsiElementPointer = SmartPointerManager.getInstance(project2).createSmartPsiElementPointer(element2, containingFile);
        if (smartPsiElementPointer == null) {
            LineMarkerInfo.$$$reportNull$$$0(12);
        }
        return smartPsiElementPointer;
    }

    LineMarkerInfo(@NotNull T element2, @NotNull TextRange range, @Nullable Icon icon2, @Nullable Supplier<@Nls @NotNull String> accessibleNameProvider, @Nullable Function<? super T, @NlsContexts.Tooltip String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element2 == null) {
            LineMarkerInfo.$$$reportNull$$$0(13);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(14);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(15);
        }
        this(LineMarkerInfo.createElementRef(element2, range), range, icon2, accessibleNameProvider, tooltipProvider, navHandler, alignment);
    }

    protected LineMarkerInfo(@NotNull SmartPsiElementPointer<? extends T> elementRef, @NotNull TextRange range, @Nullable Icon icon2, @Nullable Supplier<@Nls @NotNull String> accessibleNameProvider, @Nullable Function<? super T, @NlsContexts.Tooltip String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (elementRef == null) {
            LineMarkerInfo.$$$reportNull$$$0(16);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(17);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(18);
        }
        this.myNavigateAction = new NavigateAction(this);
        this.myIcon = icon2;
        this.myAccessibleNameProvider = accessibleNameProvider;
        this.myTooltipProvider = tooltipProvider;
        this.myIconAlignment = alignment;
        this.elementRef = elementRef;
        this.myNavigationHandler = navHandler;
        this.startOffset = range.getStartOffset();
        this.endOffset = range.getEndOffset();
        this.updatePass = 11;
    }

    @Deprecated(forRemoval=true)
    public LineMarkerInfo(@NotNull T element2, @NotNull TextRange range, Icon icon2, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element2 == null) {
            LineMarkerInfo.$$$reportNull$$$0(19);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(20);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(21);
        }
        this((T)element2, range, icon2, null, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
        PluginException.reportDeprecatedUsage("#LineMarkerInfo(T, TextRange, Icon, int, Function, GutterIconNavigationHandler, Alignment)", "Please use `LineMarkerInfo(T, TextRange, Icon, Function, GutterIconNavigationHandler, Alignment, Supplier)` instead");
    }

    @Deprecated(forRemoval=true)
    public LineMarkerInfo(@NotNull T element2, int startOffset, Icon icon2, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler) {
        if (element2 == null) {
            LineMarkerInfo.$$$reportNull$$$0(22);
        }
        this((T)element2, new TextRange(startOffset, startOffset), icon2, null, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, GutterIconRenderer.Alignment.RIGHT);
        PluginException.reportDeprecatedUsage("#LineMarkerInfo(T, int, Icon, int, Function, GutterIconNavigationHandler)", "Please use `LineMarkerInfo(T, TextRange, Icon, Function, GutterIconNavigationHandler, Alignment, Supplier)` instead");
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public GutterIconRenderer createGutterRenderer() {
        return this.myIcon == null ? null : new LineMarkerGutterIconRenderer(this);
    }

    @NlsContexts.Tooltip
    public String getLineMarkerTooltip() {
        if (this.myTooltipProvider == null) {
            return null;
        }
        T element2 = this.getElement();
        return element2 == null || !element2.isValid() ? null : this.myTooltipProvider.fun(element2);
    }

    @Nullable
    public T getElement() {
        return this.elementRef.getElement();
    }

    void setNavigateAction(@NotNull AnAction navigateAction) {
        if (navigateAction == null) {
            LineMarkerInfo.$$$reportNull$$$0(23);
        }
        this.myNavigateAction = navigateAction;
    }

    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = MarkupEditorFilter.EMPTY;
        if (markupEditorFilter == null) {
            LineMarkerInfo.$$$reportNull$$$0(24);
        }
        return markupEditorFilter;
    }

    public GutterIconNavigationHandler<T> getNavigationHandler() {
        return this.myNavigationHandler;
    }

    @Nullable Supplier<@NotNull @Nls String> getAccessibleNameProvider() {
        return this.myAccessibleNameProvider;
    }

    public String toString() {
        return "(" + this.startOffset + "," + this.endOffset + ") -> " + this.elementRef + " (icon: " + this.myIcon + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessibleNameProvider";
                break;
            }
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/LineMarkerInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRef";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/LineMarkerInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementRef";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createElementRef";
                break;
            }
            case 12: 
            case 24: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setNavigateAction";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineMarkerGutterIconRenderer<T extends PsiElement>
    extends GutterIconRenderer {
        private final LineMarkerInfo<T> myInfo;

        public LineMarkerGutterIconRenderer(@NotNull LineMarkerInfo<T> info) {
            if (info == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(0);
            }
            if (info.myIcon == null) {
                throw new IllegalArgumentException("Must supply not-null icon for the gutter, but got: " + info);
            }
            this.myInfo = info;
        }

        @NotNull
        public LineMarkerInfo<T> getLineMarkerInfo() {
            LineMarkerInfo<T> lineMarkerInfo = this.myInfo;
            if (lineMarkerInfo == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return lineMarkerInfo;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = this.myInfo.myIcon;
            if (icon2 == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return icon2;
        }

        @NotNull
        public String getAccessibleName() {
            Supplier<@Nls String> provider2 = this.myInfo.myAccessibleNameProvider;
            String string2 = provider2 == null ? super.getAccessibleName() : provider2.get();
            if (string2 == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(3);
            }
            return string2;
        }

        public AnAction getClickAction() {
            return this.myInfo.myNavigateAction;
        }

        public boolean isNavigateAction() {
            return this.myInfo.myNavigationHandler != null;
        }

        public String getTooltipText() {
            try {
                return this.myInfo.getLineMarkerTooltip();
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = this.myInfo.myIconAlignment;
            if (alignment == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(4);
            }
            return alignment;
        }

        protected boolean looksTheSameAs(@NotNull LineMarkerGutterIconRenderer<?> renderer) {
            if (renderer == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(5);
            }
            return this.myInfo.getElement() != null && renderer.myInfo.getElement() != null && this.myInfo.getElement() == renderer.myInfo.getElement() && Comparing.equal(this.myInfo.myTooltipProvider, renderer.myInfo.myTooltipProvider) && Comparing.equal(this.myInfo.myIcon, renderer.myInfo.myIcon);
        }

        public boolean equals(Object obj) {
            return obj instanceof LineMarkerGutterIconRenderer && this.looksTheSameAs((LineMarkerGutterIconRenderer)((Object)obj));
        }

        public int hashCode() {
            T element2 = this.myInfo.getElement();
            return element2 == null ? 0 : element2.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/LineMarkerInfo$LineMarkerGutterIconRenderer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/LineMarkerInfo$LineMarkerGutterIconRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineMarkerInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "looksTheSameAs";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

