/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class UsedColors {
    private static final Key<Object> USED_COLOR = Key.create("USED_COLOR");
    public static final AtomicInteger counter = new AtomicInteger();

    public static int getOrAddColorIndex(@NotNull UserDataHolderEx context2, @NotNull String name2, int colorsCount) {
        int colorIndex;
        Object data2;
        UsedColor[] newColors;
        if (context2 == null) {
            UsedColors.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            UsedColors.$$$reportNull$$$0(1);
        }
        do {
            UsedColor[] usedColors;
            if ((data2 = context2.getUserData(USED_COLOR)) == null) {
                colorIndex = UsedColors.hashColor(name2, colorsCount);
                newColors = new UsedColor(name2, colorIndex);
                continue;
            }
            if (data2 instanceof UsedColor) {
                UsedColor usedColor = (UsedColor)data2;
                if (usedColor.name.equals(name2)) {
                    colorIndex = usedColor.index;
                    newColors = null;
                    continue;
                }
                int hashedIndex = UsedColors.hashColor(name2, colorsCount);
                if (hashedIndex == usedColor.index) {
                    hashedIndex = (hashedIndex + 1) % colorsCount;
                }
                colorIndex = hashedIndex;
                UsedColor newColor = new UsedColor(name2, colorIndex);
                newColors = new UsedColor[]{usedColor, newColor};
                continue;
            }
            colorIndex = -1;
            int hashedIndex = UsedColors.hashColor(name2, colorsCount);
            int[] index2usage = new int[colorsCount];
            for (UsedColor usedColor : usedColors = (UsedColor[])data2) {
                int index;
                int n = index = usedColor.index;
                index2usage[n] = index2usage[n] + 1;
                if (!usedColor.name.equals(name2)) continue;
                colorIndex = index;
                break;
            }
            if (colorIndex == -1) {
                int minIndex2;
                int minIndex1 = UsedColors.indexOfMin(index2usage, hashedIndex, colorsCount);
                colorIndex = index2usage[minIndex1] <= index2usage[minIndex2 = UsedColors.indexOfMin(index2usage, 0, hashedIndex)] ? minIndex1 : minIndex2;
                UsedColor newColor = new UsedColor(name2, colorIndex);
                newColors = ArrayUtil.append(usedColors, newColor);
                continue;
            }
            newColors = null;
        } while (newColors != null && !context2.replace(USED_COLOR, data2, newColors));
        return colorIndex;
    }

    private static int hashColor(@NotNull String name2, int colorsCount) {
        if (name2 == null) {
            UsedColors.$$$reportNull$$$0(2);
        }
        return Math.abs(StringHash.murmur(name2, 21930) % colorsCount);
    }

    @Contract(pure=true)
    private static int indexOfMin(int @NotNull [] values2, int start2, int end) {
        if (values2 == null) {
            UsedColors.$$$reportNull$$$0(3);
        }
        int min = Integer.MAX_VALUE;
        int minIndex = start2;
        for (int i = start2; i < end; ++i) {
            int value = values2[i];
            if (value >= min) continue;
            min = value;
            minIndex = i;
        }
        return minIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/UsedColors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrAddColorIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hashColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "indexOfMin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UsedColor {
        @NotNull
        final String name;
        final int index;

        UsedColor(@NotNull String name2, int index) {
            if (name2 == null) {
                UsedColor.$$$reportNull$$$0(0);
            }
            this.name = name2;
            this.index = index;
            counter.incrementAndGet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/UsedColors$UsedColor", "<init>"));
        }
    }
}

