/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.SilentChangeVetoer;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class CanISilentlyChange {
    private static boolean canUndo(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
        FileEditor[] editors2;
        if (virtualFile2 == null) {
            CanISilentlyChange.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            CanISilentlyChange.$$$reportNull$$$0(1);
        }
        if ((editors2 = FileEditorManager.getInstance(project2).getEditors(virtualFile2)).length == 0) {
            return false;
        }
        UndoManager undoManager = UndoManager.getInstance(project2);
        for (FileEditor editor2 : editors2) {
            if (!undoManager.isUndoAvailable(editor2)) continue;
            return true;
        }
        return false;
    }

    public static boolean thisFile(@NotNull PsiFileSystemItem file2) {
        if (file2 == null) {
            CanISilentlyChange.$$$reportNull$$$0(2);
        }
        Project project2 = file2.getProject();
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return false;
        }
        if (file2 instanceof PsiCodeFragment) {
            return true;
        }
        if (ScratchUtil.isScratch(virtualFile2)) {
            return CanISilentlyChange.canUndo(virtualFile2, project2);
        }
        if (!ModuleUtilCore.projectContainsFile(project2, virtualFile2, false)) {
            return false;
        }
        for (SilentChangeVetoer extension2 : SilentChangeVetoer.EP_NAME.getExtensionList()) {
            ThreeState result2 = extension2.canChangeFileSilently(project2, virtualFile2);
            if (result2 == ThreeState.UNSURE) continue;
            return result2.toBoolean();
        }
        return CanISilentlyChange.canUndo(virtualFile2, project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/CanISilentlyChange";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canUndo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "thisFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

