/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

class CodeFoldingPass
extends EditorBoundHighlightingPass
implements PossiblyDumbAware {
    private static final Key<Boolean> THE_FIRST_TIME = Key.create("FirstFoldingPass");
    private volatile Runnable myRunnable;

    CodeFoldingPass(@NotNull Editor editor2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            CodeFoldingPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CodeFoldingPass.$$$reportNull$$$0(1);
        }
        super(editor2, file2, false);
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CodeFoldingPass.$$$reportNull$$$0(2);
        }
        boolean firstTime = CodeFoldingPass.isFirstTime(this.myFile, this.myEditor, THE_FIRST_TIME);
        this.myRunnable = CodeFoldingManager.getInstance(this.myProject).updateFoldRegionsAsync(this.myEditor, firstTime);
    }

    static boolean isFirstTime(PsiFile file2, Editor editor2, Key<Boolean> key) {
        return file2.getUserData(key) == null || editor2.getUserData(key) == null;
    }

    static void clearFirstTimeFlag(PsiFile file2, Editor editor2, Key<? super Boolean> key) {
        file2.putUserData(key, Boolean.FALSE);
        editor2.putUserData(key, (Object)Boolean.FALSE);
    }

    @Override
    public void doApplyInformationToEditor() {
        Runnable runnable = this.myRunnable;
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (InjectedLanguageManager.getInstance(this.myFile.getProject()).getTopLevelFile(this.myFile) == this.myFile) {
            CodeFoldingPass.clearFirstTimeFlag(this.myFile, this.myEditor, THE_FIRST_TIME);
        }
    }

    @Override
    public boolean isDumbAware() {
        return FoldingUpdate.supportsDumbModeFolding(this.myEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/CodeFoldingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

