/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.ConfigureInspectionsAction;
import com.intellij.codeInsight.daemon.impl.LevelAction;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"getConfigureHighlightingLevelPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.platform.lang.impl"})
public final class ConfigureHighlightingLevelKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JBPopup getConfigureHighlightingLevelPopup(@NotNull DataContext context2) {
        void $this$forEach$iv;
        PsiFile psi;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                PsiFile psiFile = (PsiFile)context2.getData(CommonDataKeys.PSI_FILE);
                if (psiFile == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"context.getData(PSI_FILE) ?: return null");
                psi = psiFile;
                if (!psi.isValid()) break block9;
                Project project2 = psi.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psi.project");
                if (!project2.isDisposed()) break block10;
            }
            return null;
        }
        FileViewProvider fileViewProvider = psi.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"psi.viewProvider");
        FileViewProvider provider2 = fileViewProvider;
        Set<Language> set2 = provider2.getLanguages();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"provider.languages");
        Set<Language> languages = set2;
        if (languages.isEmpty()) {
            return null;
        }
        VirtualFile virtualFile2 = psi.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(psi.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(psi.project)");
        ProjectFileIndex index = projectFileIndex;
        boolean isAllInspectionsEnabled = index.isInContent(file2) || !index.isInLibrary(file2);
        DefaultActionGroup group = new DefaultActionGroup();
        Iterable $this$sortedBy$iv = languages;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Language it = (Language)a;
                boolean bl = false;
                Language language = it;
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"it");
                it = (Language)b;
                Comparable comparable = (Comparable)((Object)language.getDisplayName());
                bl = false;
                Language language2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"it");
                String string2 = language2.getDisplayName();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Language it = (Language)element$iv;
            boolean bl = false;
            Collection collection = languages;
            if (collection.size() > 1) {
                Language language = it;
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"it");
                group.add((AnAction)Separator.create((String)language.getDisplayName()));
            }
            Language language = it;
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"it");
            group.add((AnAction)new LevelAction(InspectionsLevel.NONE, provider2, language));
            group.add((AnAction)new LevelAction(InspectionsLevel.SYNTAX, provider2, it));
            if (!isAllInspectionsEnabled) continue;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isInternal()) {
                group.add((AnAction)new LevelAction(InspectionsLevel.ESSENTIAL, provider2, it));
            }
            group.add((AnAction)new LevelAction(InspectionsLevel.ALL, provider2, it));
        }
        group.add((AnAction)Separator.create());
        group.add((AnAction)new ConfigureInspectionsAction());
        Object[] objectArray = new Object[1];
        VirtualFile virtualFile3 = psi.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"psi.virtualFile");
        objectArray[0] = virtualFile3.getPresentableName();
        String string2 = DaemonBundle.message("popup.title.configure.highlighting.level", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"popup.title.con\u2026tualFile.presentableName)");
        String title = string2;
        return (JBPopup)JBPopupFactory.getInstance().createActionGroupPopup(title, (ActionGroup)group, context2, true, null, 100);
    }
}

