/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsImpl;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.IntentionsUIImpl;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.PassExecutorService;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.StatusBarUpdater;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.impl.FileLevelIntentionComponent;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="DaemonCodeAnalyzer", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class DaemonCodeAnalyzerImpl
extends DaemonCodeAnalyzerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(DaemonCodeAnalyzerImpl.class);
    private static final Key<List<HighlightInfo>> FILE_LEVEL_HIGHLIGHTS = Key.create("FILE_LEVEL_HIGHLIGHTS");
    @NotNull
    private static final Key<Boolean> COMPLETE_ESSENTIAL_HIGHLIGHTING_KEY = Key.create("COMPLETE_ESSENTIAL_HIGHLIGHTING");
    private final Project myProject;
    private final DaemonCodeAnalyzerSettings mySettings;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    private final FileEditorManagerEx myFileEditorManager;
    private final EditorTracker myEditorTracker;
    private DaemonProgressIndicator myUpdateProgress;
    private final UpdateRunnable myUpdateRunnable;
    @NotNull
    private volatile Future<?> myUpdateRunnableFuture;
    private boolean myUpdateByTimerEnabled;
    private final Collection<VirtualFile> myDisabledHintsFiles;
    private final Collection<VirtualFile> myDisabledHighlightingFiles;
    private final FileStatusMap myFileStatusMap;
    private DaemonCodeAnalyzerSettings myLastSettings;
    private volatile boolean myDisposed;
    private volatile boolean myInitialized;
    @NonNls
    private static final String DISABLE_HINTS_TAG = "disable_hints";
    @NonNls
    private static final String FILE_TAG = "file";
    @NonNls
    private static final String URL_ATT = "url";
    private final PassExecutorService myPassExecutorService;
    private long myScheduledUpdateTimestamp;
    private volatile boolean completeEssentialHighlightingRequested;
    private final AtomicInteger daemonCancelEventCount;
    private final DaemonCodeAnalyzer.DaemonListener myDaemonListenerPublisher;
    private static final int ANY_GROUP = -409423948;
    private volatile boolean mustWaitForSmartMode;
    private final AtomicInteger myDisableCount;

    public DaemonCodeAnalyzerImpl(@NotNull Project project2) {
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(0);
        }
        this.myUpdateProgress = new DaemonProgressIndicator();
        this.myUpdateRunnableFuture = CompletableFuture.completedFuture(null);
        this.myUpdateByTimerEnabled = true;
        this.myDisabledHintsFiles = new HashSet<VirtualFile>();
        this.myDisabledHighlightingFiles = new HashSet<VirtualFile>();
        this.daemonCancelEventCount = new AtomicInteger();
        this.mustWaitForSmartMode = true;
        this.myDisableCount = new AtomicInteger();
        DependencyValidationManager.getInstance(project2);
        this.myProject = project2;
        this.mySettings = DaemonCodeAnalyzerSettings.getInstance();
        this.myPsiDocumentManager = PsiDocumentManager.getInstance(project2);
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)this.mySettings).clone();
        this.myFileStatusMap = new FileStatusMap(project2);
        this.myPassExecutorService = new PassExecutorService(project2);
        Disposer.register(this, this.myPassExecutorService);
        Disposer.register(this, this.myFileStatusMap);
        DaemonProgressIndicator.setDebug(LOG.isDebugEnabled());
        assert (!this.myInitialized) : "Double Initializing";
        Disposer.register(this, new StatusBarUpdater(project2));
        this.myInitialized = true;
        this.myDisposed = false;
        this.myFileStatusMap.markAllFilesDirty("DaemonCodeAnalyzer init");
        this.myUpdateRunnable = new UpdateRunnable(project2);
        Disposer.register(this, () -> {
            assert (this.myInitialized) : "Disposing not initialized component";
            assert (!this.myDisposed) : "Double dispose";
            this.myUpdateRunnable.clearFieldsOnDispose();
            this.stopProcess(false, "Dispose " + project2);
            this.myDisposed = true;
            this.myLastSettings = null;
        });
        this.myFileEditorManager = FileEditorManagerEx.getInstanceEx((Project)project2);
        if (this.myFileEditorManager == null && !project2.isDefault()) {
            throw new IllegalStateException("FileEditorManagerEx.getInstanceEx(myProject) = null; myProject=" + project2);
        }
        this.myEditorTracker = EditorTracker.getInstance(project2);
        this.myDaemonListenerPublisher = (DaemonCodeAnalyzer.DaemonListener)project2.getMessageBus().syncPublisher(DAEMON_EVENT_TOPIC);
    }

    @Override
    public synchronized void dispose() {
        this.clearReferences();
    }

    private synchronized void clearReferences() {
        this.myUpdateProgress = new DaemonProgressIndicator();
        this.myUpdateProgress.cancel();
        this.myUpdateRunnableFuture.cancel(true);
    }

    synchronized void clearProgressIndicator() {
        HighlightingSessionImpl.clearProgressIndicator(this.myUpdateProgress);
    }

    public synchronized boolean isCompleteEssentialHighlightingSession() {
        return this.myUpdateProgress.getUserData(COMPLETE_ESSENTIAL_HIGHLIGHTING_KEY) == Boolean.TRUE;
    }

    @NotNull
    @TestOnly
    public static List<HighlightInfo> getHighlights(@NotNull Document document, @Nullable HighlightSeverity minSeverity, @NotNull Project project2) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(2);
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerImpl.processHighlights(document, project2, minSeverity, 0, document.getTextLength(), Processors.cancelableCollectProcessor(infos));
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    @TestOnly
    public List<HighlightInfo> getFileLevelHighlights(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(5);
        }
        this.assertMyFile(file2.getProject(), file2);
        this.assertMyFile(project2, file2);
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        List<HighlightInfo> list2 = Arrays.stream(this.myFileEditorManager.getAllEditors(vFile)).map(fileEditor -> (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        if (list2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private void assertMyFile(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(8);
        }
        if (project2 != this.myProject) {
            throw new IllegalStateException("my project is " + this.myProject + " but I was called with " + project2);
        }
        if (file2.getProject() != this.myProject) {
            throw new IllegalStateException("my project is " + this.myProject + " but I was called with file " + file2 + " from " + file2.getProject());
        }
    }

    @Override
    public void cleanFileLevelHighlights(int group, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(9);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        VirtualFile vFile = BackedVirtualFile.getOriginFileIfBacked(psiFile.getViewProvider().getVirtualFile());
        for (FileEditor fileEditor : this.myFileEditorManager.getAllEditors(vFile)) {
            this.cleanFileLevelHighlights(fileEditor, group);
        }
    }

    void cleanAllFileLevelHighlights() {
        for (FileEditor fileEditor : this.myFileEditorManager.getAllEditors()) {
            this.cleanFileLevelHighlights(fileEditor, -409423948);
        }
    }

    private void cleanFileLevelHighlights(@NotNull FileEditor fileEditor, int group) {
        List infos;
        if (fileEditor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(10);
        }
        if ((infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS)) == null) {
            return;
        }
        ArrayList<HighlightInfo> infosToRemove = new ArrayList<HighlightInfo>(infos.size());
        for (HighlightInfo info : infos) {
            if (info.getGroup() != group && group != -409423948) continue;
            JComponent component2 = info.getFileLevelComponent(fileEditor);
            if (component2 != null) {
                this.myFileEditorManager.removeTopComponent(fileEditor, component2);
                info.removeFileLeverComponent(fileEditor);
            }
            infosToRemove.add(info);
        }
        infos.removeAll(infosToRemove);
    }

    @Override
    public void addFileLevelHighlight(int group, @NotNull HighlightInfo info, @NotNull PsiFile psiFile) {
        if (info == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(11);
        }
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(12);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        VirtualFile vFile = BackedVirtualFile.getOriginFileIfBacked(psiFile.getViewProvider().getVirtualFile());
        for (FileEditor fileEditor : this.myFileEditorManager.getAllEditors(vFile)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            FileLevelIntentionComponent component2 = new FileLevelIntentionComponent(info.getDescription(), info.getSeverity(), info.getGutterIconRenderer(), info.quickFixActionRanges, psiFile, ((TextEditor)fileEditor).getEditor(), info.getToolTip());
            this.myFileEditorManager.addTopComponent(fileEditor, (JComponent)((Object)component2));
            ArrayList<HighlightInfo> fileLevelInfos = (ArrayList<HighlightInfo>)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (fileLevelInfos == null) {
                fileLevelInfos = new ArrayList<HighlightInfo>();
                fileEditor.putUserData(FILE_LEVEL_HIGHLIGHTS, fileLevelInfos);
            }
            info.addFileLeverComponent(fileEditor, (JComponent)((Object)component2));
            info.setGroup(group);
            fileLevelInfos.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<HighlightInfo> runMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull ProgressIndicator progress) {
        ArrayList<HighlightInfo> result2;
        block12: {
            if (psiFile == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(13);
            }
            if (document == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(14);
            }
            if (progress == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(15);
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new IllegalStateException("Must not run highlighting from under EDT");
            }
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                throw new IllegalStateException("Must run highlighting outside read action, external annotators do not support checkCanceled");
            }
            this.assertMyFile(psiFile.getProject(), psiFile);
            GlobalInspectionContextBase.assertUnderDaemonProgress();
            this.myFileStatusMap.markAllFilesDirty("prepare to run main passes");
            this.stopProcess(false, "disable background daemon");
            this.myPassExecutorService.cancelAll(true);
            try {
                result2 = new ArrayList<HighlightInfo>();
                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                if (virtualFile2 == null || virtualFile2.getFileType().isBinary()) break block12;
                List passes = DumbService.getInstance(this.myProject).runReadActionInSmartMode(() -> {
                    List<TextEditorHighlightingPass> mainPasses = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject).instantiateMainPasses(psiFile, document, HighlightInfoProcessor.getEmpty());
                    mainPasses.sort((o1, o2) -> {
                        if (o1 instanceof GeneralHighlightingPass) {
                            return -1;
                        }
                        if (o2 instanceof GeneralHighlightingPass) {
                            return 1;
                        }
                        return 0;
                    });
                    try {
                        for (TextEditorHighlightingPass pass2 : mainPasses) {
                            pass2.doCollectInformation(progress);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        LOG.debug("Canceled: " + progress);
                        throw e;
                    }
                    return mainPasses;
                });
                try {
                    for (TextEditorHighlightingPass pass2 : passes) {
                        result2.addAll(pass2.getInfos());
                    }
                }
                catch (ProcessCanceledException e) {
                    LOG.debug("Canceled: " + progress);
                    throw e;
                }
            }
            finally {
                this.stopProcess(true, "re-enable background daemon after main passes run");
            }
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @TestOnly
    public void mustWaitForSmartMode(boolean mustWait, @NotNull Disposable parent) {
        if (parent == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(17);
        }
        boolean old = this.mustWaitForSmartMode;
        this.mustWaitForSmartMode = mustWait;
        Disposer.register(parent, () -> {
            this.mustWaitForSmartMode = old;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void runPasses(@NotNull PsiFile file2, @NotNull Document document, @NotNull List<? extends TextEditor> textEditors, int @NotNull [] passesToIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(18);
        }
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(19);
        }
        if (textEditors == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(20);
        }
        if (passesToIgnore == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(21);
        }
        assert (this.myInitialized);
        assert (!this.myDisposed);
        this.assertMyFile(file2.getProject(), file2);
        for (TextEditor textEditor : textEditors) {
            assert (textEditor.getEditor().getDocument() == document) : "Expected document " + document + " but one of the passed TextEditors points to a different document: " + textEditor.getEditor().getDocument();
        }
        Document associatedDocument = PsiDocumentManager.getInstance(this.myProject).getDocument(file2);
        assert (associatedDocument == document) : "Expected document " + document + " but the passed PsiFile points to a different document: " + associatedDocument;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not start highlighting from within write action, or deadlock is imminent");
        }
        DaemonProgressIndicator.setDebug(!ApplicationManagerEx.isInStressTest());
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        do {
            UIUtil.dispatchAllInvocationEvents();
        } while (RefreshQueueImpl.isRefreshInProgress() || DaemonCodeAnalyzerImpl.heavyProcessIsRunning());
        long l = System.currentTimeMillis();
        while (this.mustWaitForSmartMode && DumbService.getInstance(this.myProject).isDumb()) {
            if (System.currentTimeMillis() > l + 100000L) {
                throw new IllegalStateException("Timeout waiting for smart mode. If you absolutely want to be dumb, please use DaemonCodeAnalyzerImpl.mustWaitForSmartMode(false).");
            }
            UIUtil.dispatchAllInvocationEvents();
        }
        ((GistManagerImpl)GistManager.getInstance()).clearQueueInTests();
        UIUtil.dispatchAllInvocationEvents();
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        this.myUpdateRunnableFuture.cancel(false);
        this.myPassExecutorService.cancelAll(false);
        FileStatusMap fileStatusMap = this.getFileStatusMap();
        fileStatusMap.allowDirt(canChangeDocument);
        for (int ignoreId : passesToIgnore) {
            fileStatusMap.markFileUpToDate(document, ignoreId);
        }
        HighlightingSession session = this.queuePassesCreation(textEditors, passesToIgnore);
        DaemonProgressIndicator progress = this.getUpdateProgress();
        progress.checkCanceled();
        try {
            long start2 = System.currentTimeMillis();
            while (progress.isRunning() && System.currentTimeMillis() < start2 + 600000L) {
                progress.checkCanceled();
                if (callbackWhileWaiting != null) {
                    callbackWhileWaiting.run();
                }
                this.waitInOtherThread(50, canChangeDocument);
                UIUtil.dispatchAllInvocationEvents();
                Throwable savedException = PassExecutorService.getSavedException(progress);
                if (savedException == null) continue;
                throw savedException;
            }
            if (progress.isRunning() && !progress.isCanceled()) {
                throw new RuntimeException("Highlighting still running after " + (System.currentTimeMillis() - start2) / 1000L + " seconds. Still submitted passes: " + this.myPassExecutorService.getAllSubmittedPasses() + " ForkJoinPool.commonPool(): " + ForkJoinPool.commonPool() + "\n, ForkJoinPool.commonPool() active thread count: " + ForkJoinPool.commonPool().getActiveThreadCount() + ", ForkJoinPool.commonPool() has queued submissions: " + ForkJoinPool.commonPool().hasQueuedSubmissions() + "\n" + ThreadDumper.dumpThreadsToString());
            }
            if (!this.waitInOtherThread(60000, canChangeDocument)) {
                throw new TimeoutException("Unable to complete in 60s. Thread dump:\n" + ThreadDumper.dumpThreadsToString());
            }
            ((HighlightingSessionImpl)session).waitForHighlightInfosApplied();
            UIUtil.dispatchAllInvocationEvents();
            UIUtil.dispatchAllInvocationEvents();
            assert (progress.isCanceled() && progress.isDisposed());
        }
        catch (Throwable e) {
            Throwable unwrapped = ExceptionUtilRt.unwrapException(e, ExecutionException.class);
            if (progress.isCanceled() && progress.isRunning()) {
                unwrapped.addSuppressed(new RuntimeException("Daemon progress was canceled unexpectedly: " + progress));
            }
            ExceptionUtil.rethrow(unwrapped);
        }
        finally {
            DaemonProgressIndicator.setDebug(false);
            fileStatusMap.allowDirt(true);
            progress.cancel();
            this.waitForTermination();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    private boolean waitInOtherThread(int millis, boolean canChangeDocument) throws Throwable {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposable disposable = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable).subscribe(PsiModificationTracker.TOPIC, () -> {
            throw new IllegalStateException("You must not perform PSI modifications from inside highlighting");
        });
        if (!canChangeDocument) {
            this.myProject.getMessageBus().connect(disposable).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, new DaemonCodeAnalyzer.DaemonListener(){

                @Override
                public void daemonCancelEventOccurred(@NotNull String reason) {
                    if (reason == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    throw new IllegalStateException("You must not cancel daemon inside highlighting test: " + reason);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$1", "daemonCancelEventOccurred"));
                }
            });
        }
        try {
            Future<Boolean> future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    return this.myPassExecutorService.waitFor(millis);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
            boolean bl = future2.get();
            return bl;
        }
        catch (InterruptedException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            Disposer.dispose(disposable);
        }
    }

    @TestOnly
    public void prepareForTest() {
        this.setUpdateByTimerEnabled(false);
        this.waitForTermination();
        this.clearReferences();
    }

    @TestOnly
    public void cleanupAfterTest() {
        if (this.myProject.isOpen()) {
            this.prepareForTest();
        }
    }

    @TestOnly
    public void waitForTermination() {
        this.myPassExecutorService.cancelAll(true);
    }

    @Override
    public void settingsChanged() {
        if (this.mySettings.isCodeHighlightingChanged(this.myLastSettings)) {
            this.restart();
        }
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)this.mySettings).clone();
    }

    @Override
    public synchronized void setUpdateByTimerEnabled(boolean value) {
        this.myUpdateByTimerEnabled = value;
        this.stopProcess(value, "Update by timer change");
    }

    @Override
    public void disableUpdateByTimer(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(22);
        }
        this.setUpdateByTimerEnabled(false);
        this.myDisableCount.incrementAndGet();
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.register(parentDisposable, () -> {
            if (this.myDisableCount.decrementAndGet() == 0) {
                this.setUpdateByTimerEnabled(true);
            }
        });
    }

    synchronized boolean isUpdateByTimerEnabled() {
        return this.myUpdateByTimerEnabled;
    }

    @Override
    public void setImportHintsEnabled(@NotNull PsiFile file2, boolean value) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(23);
        }
        this.assertMyFile(file2.getProject(), file2);
        VirtualFile vFile = file2.getVirtualFile();
        if (value) {
            this.myDisabledHintsFiles.remove(vFile);
            this.stopProcess(true, "Import hints change");
        } else {
            this.myDisabledHintsFiles.add(vFile);
            HintManager.getInstance().hideAllHints();
        }
    }

    @Override
    public void resetImportHintsEnabledForProject() {
        this.myDisabledHintsFiles.clear();
    }

    @Override
    public void setHighlightingEnabled(@NotNull PsiFile psiFile, boolean value) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(24);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(psiFile);
        if (value) {
            this.myDisabledHighlightingFiles.remove(virtualFile2);
        } else {
            this.myDisabledHighlightingFiles.add(virtualFile2);
        }
    }

    @Override
    public boolean isHighlightingAvailable(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(25);
        }
        if (!psiFile.isPhysical()) {
            return false;
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        if (this.myDisabledHighlightingFiles.contains(PsiUtilCore.getVirtualFile(psiFile))) {
            return false;
        }
        if (psiFile instanceof PsiCompiledElement) {
            return false;
        }
        FileType fileType = psiFile.getFileType();
        return !fileType.isBinary();
    }

    @Override
    public boolean isImportHintsEnabled(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(26);
        }
        return this.isAutohintsAvailable(psiFile) && !this.myDisabledHintsFiles.contains(psiFile.getVirtualFile());
    }

    @Override
    public boolean isAutohintsAvailable(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(27);
        }
        return this.isHighlightingAvailable(psiFile) && !(psiFile instanceof PsiCompiledElement);
    }

    @Override
    public void restart() {
        this.stopProcessAndRestartAllFiles("Global restart");
    }

    void stopProcessAndRestartAllFiles(@NotNull String reason) {
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(28);
        }
        this.myFileStatusMap.markAllFilesDirty(reason);
        this.stopProcess(true, reason);
    }

    @Override
    public void restart(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(29);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        Document document = this.myPsiDocumentManager.getCachedDocument(psiFile);
        if (document == null) {
            return;
        }
        String reason = "Psi file restart: " + psiFile.getName();
        this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, document.getTextLength()), psiFile.getTextLength(), reason);
        this.stopProcess(true, reason);
    }

    @NotNull
    public List<ProgressableTextEditorHighlightingPass> getPassesToShowProgressFor(@NotNull Document document) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(30);
        }
        List<HighlightingPass> allPasses = this.myPassExecutorService.getAllSubmittedPasses();
        List<ProgressableTextEditorHighlightingPass> list2 = allPasses.stream().map(p -> p instanceof ProgressableTextEditorHighlightingPass ? (ProgressableTextEditorHighlightingPass)p : null).filter(p -> p != null && p.getDocument() == document).sorted(Comparator.comparingInt(p -> p.getId())).collect(Collectors.toList());
        if (list2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(31);
        }
        return list2;
    }

    boolean isAllAnalysisFinished(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(32);
        }
        if (this.myDisposed) {
            return false;
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        Document document = this.myPsiDocumentManager.getCachedDocument(psiFile);
        return document != null && document.getModificationStamp() == psiFile.getViewProvider().getModificationStamp() && this.myFileStatusMap.allDirtyScopesAreNull(document);
    }

    @Override
    public boolean isErrorAnalyzingFinished(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(33);
        }
        if (this.myDisposed) {
            return false;
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        Document document = this.myPsiDocumentManager.getCachedDocument(psiFile);
        return document != null && document.getModificationStamp() == psiFile.getViewProvider().getModificationStamp() && this.myFileStatusMap.getFileDirtyScope(document, 4) == null;
    }

    @Override
    @NotNull
    public FileStatusMap getFileStatusMap() {
        FileStatusMap fileStatusMap = this.myFileStatusMap;
        if (fileStatusMap == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(34);
        }
        return fileStatusMap;
    }

    public synchronized boolean isRunning() {
        return !this.myUpdateProgress.isCanceled();
    }

    @TestOnly
    public boolean isRunningOrPending() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.isRunning() || !this.myUpdateRunnableFuture.isDone() || GeneralHighlightingPass.isRestartPending();
    }

    synchronized void stopProcess(boolean toRestartAlarm, @NotNull @NonNls String reason) {
        boolean restart;
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(35);
        }
        this.cancelUpdateProgress(toRestartAlarm, reason);
        boolean bl = restart = toRestartAlarm && !this.myDisposed && this.myInitialized;
        if (restart) {
            this.myScheduledUpdateTimestamp = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.mySettings.getAutoReparseDelay());
        }
        boolean isDone = this.myUpdateRunnableFuture.isDone();
        if (restart && isDone) {
            this.scheduleUpdateRunnable(TimeUnit.MILLISECONDS.toNanos(this.mySettings.getAutoReparseDelay()));
        }
    }

    private void scheduleUpdateRunnable(long delayNanos) {
        Future<?> oldFuture = this.myUpdateRunnableFuture;
        if (oldFuture.isDone()) {
            ConcurrencyUtil.manifestExceptionsIn(oldFuture);
        }
        this.myUpdateRunnableFuture = EdtExecutorService.getScheduledExecutorInstance().schedule(this.myUpdateRunnable, delayNanos, TimeUnit.NANOSECONDS);
    }

    synchronized void cancelUpdateProgress(boolean toRestartAlarm, @NotNull @NonNls String reason) {
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(36);
        }
        DaemonProgressIndicator updateProgress = this.myUpdateProgress;
        if (this.myDisposed || this.myProject.isDisposed() || this.myProject.getMessageBus().isDisposed()) {
            return;
        }
        if (!updateProgress.isCanceled()) {
            PassExecutorService.log(updateProgress, null, "Cancel", reason, toRestartAlarm);
            updateProgress.cancel();
            this.myPassExecutorService.cancelAll(false);
            ApplicationManager.getApplication().invokeLater(() -> this.myDaemonListenerPublisher.daemonCancelEventOccurred(reason), __ -> this.myDisposed || this.myProject.isDisposed() || this.myProject.getMessageBus().isDisposed());
        }
        this.daemonCancelEventCount.incrementAndGet();
    }

    static boolean processHighlightsNearOffset(@NotNull Document document, @NotNull Project project2, @NotNull HighlightSeverity minSeverity, int offset, boolean includeFixRange, @NotNull Processor<? super HighlightInfo> processor) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(37);
        }
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(38);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(40);
        }
        return DaemonCodeAnalyzerImpl.processHighlights(document, project2, null, 0, document.getTextLength(), (? super HighlightInfo info) -> {
            if (!DaemonCodeAnalyzerImpl.isOffsetInsideHighlightInfo(offset, info, includeFixRange)) {
                return true;
            }
            int compare = info.getSeverity().compareTo(minSeverity);
            return compare < 0 || processor.process((HighlightInfo)info);
        });
    }

    @Nullable
    public HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(41);
        }
        return this.findHighlightByOffset(document, offset, includeFixRange, HighlightSeverity.INFORMATION);
    }

    @Nullable
    HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange, @NotNull HighlightSeverity minSeverity) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(42);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(43);
        }
        return this.findHighlightsByOffset(document, offset, includeFixRange, true, minSeverity);
    }

    @Nullable
    public HighlightInfo findHighlightsByOffset(@NotNull Document document, int offset, boolean includeFixRange, boolean highestPriorityOnly, @NotNull HighlightSeverity minSeverity) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(44);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(45);
        }
        HighlightByOffsetProcessor processor = new HighlightByOffsetProcessor(highestPriorityOnly);
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(document, this.myProject, minSeverity, offset, includeFixRange, processor);
        return processor.getResult();
    }

    private static boolean isOffsetInsideHighlightInfo(int offset, @NotNull HighlightInfo info, boolean includeFixRange) {
        RangeHighlighterEx highlighter;
        if (info == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(46);
        }
        if ((highlighter = info.getHighlighter()) == null || !highlighter.isValid()) {
            return false;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (startOffset <= offset && offset <= endOffset) {
            return true;
        }
        if (!includeFixRange) {
            return false;
        }
        RangeMarker fixMarker = info.fixMarker;
        if (fixMarker != null) {
            if (!fixMarker.isValid()) {
                return false;
            }
            startOffset = fixMarker.getStartOffset();
            endOffset = fixMarker.getEndOffset();
            return startOffset <= offset && offset <= endOffset;
        }
        return false;
    }

    @NotNull
    public static List<LineMarkerInfo<?>> getLineMarkers(@NotNull Document document, @NotNull Project project2) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(47);
        }
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(48);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList result2 = new ArrayList();
        LineMarkersUtil.processLineMarkers(project2, document, new TextRange(0, document.getTextLength()), -1, new CommonProcessors.CollectProcessor(result2));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(49);
        }
        return arrayList;
    }

    @Nullable
    IntentionHintComponent getLastIntentionHint() {
        return ((IntentionsUIImpl)IntentionsUI.getInstance(this.myProject)).getLastIntentionHint();
    }

    @Override
    public boolean hasVisibleLightBulbOrPopup() {
        IntentionHintComponent hint = this.getLastIntentionHint();
        return hint != null && hint.hasVisibleLightBulbOrPopup();
    }

    @Override
    @NotNull
    public Element getState() {
        Element state = new Element("state");
        if (this.myDisabledHintsFiles.isEmpty()) {
            Element element2 = state;
            if (element2 == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(50);
            }
            return element2;
        }
        ArrayList<String> array = new ArrayList<String>(this.myDisabledHintsFiles.size());
        for (VirtualFile file2 : this.myDisabledHintsFiles) {
            if (!file2.isValid()) continue;
            array.add(file2.getUrl());
        }
        if (!array.isEmpty()) {
            Collections.sort(array);
            Element disableHintsElement = new Element(DISABLE_HINTS_TAG);
            state.addContent(disableHintsElement);
            for (String url : array) {
                disableHintsElement.addContent(new Element(FILE_TAG).setAttribute(URL_ATT, url));
            }
        }
        Element element3 = state;
        if (element3 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(51);
        }
        return element3;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(52);
        }
        this.myDisabledHintsFiles.clear();
        Element element2 = state.getChild(DISABLE_HINTS_TAG);
        if (element2 != null) {
            for (Element e : element2.getChildren(FILE_TAG)) {
                VirtualFile file2;
                String url = e.getAttributeValue(URL_ATT);
                if (url == null || (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
                this.myDisabledHintsFiles.add(file2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private HighlightingSession queuePassesCreation(@NotNull Collection<? extends FileEditor> fileEditors, int @NotNull [] passesToIgnore) {
        void var6_8;
        if (fileEditors == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(53);
        }
        if (passesToIgnore == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(54);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (fileEditors.isEmpty()) {
            throw new IllegalArgumentException("no file editors to highlight");
        }
        int modificationCountBefore = this.daemonCancelEventCount.get();
        HashMap<FileEditor, BackgroundEditorHighlighter> highlighters = new HashMap<FileEditor, BackgroundEditorHighlighter>(fileEditors.size());
        for (FileEditor fileEditor : fileEditors) {
            BackgroundEditorHighlighter highlighter = fileEditor.getBackgroundHighlighter();
            if (highlighter == null) continue;
            highlighters.put(fileEditor, highlighter);
        }
        DaemonProgressIndicator progress = this.createUpdateProgress(highlighters.keySet());
        Object var6_7 = null;
        for (FileEditor fileEditor : fileEditors) {
            Editor editor2;
            VirtualFile virtualFile2;
            PsiFile psiFile;
            if (!highlighters.containsKey(fileEditor) || (psiFile = DaemonCodeAnalyzerImpl.findFileToHighlight(this.myProject, virtualFile2 = fileEditor.getFile())) == null) continue;
            Editor editor3 = editor2 = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
            if (editor2 != null && editor2.getDocument().isInBulkUpdate()) {
                this.stopProcess(false, editor2.getDocument() + " is in bulk state");
                return null;
            }
            EditorColorsScheme scheme = editor2 == null ? null : editor2.getColorsScheme();
            HighlightingSession highlightingSession = HighlightingSessionImpl.createHighlightingSession(psiFile, editor2, scheme, progress);
        }
        if (var6_8 == null) {
            this.stopProcess(true, "Couldn't create session for " + fileEditors);
            return null;
        }
        List<FileEditorInfo> preferredFileEditorMap = this.createPreferredFileEditorMap(fileEditors, highlighters);
        JobLauncher.getInstance().submitToJobThread(() -> this.submitInBackground(preferredFileEditorMap, passesToIgnore, modificationCountBefore, progress), task2 -> ApplicationManager.getApplication().invokeLater(() -> ConcurrencyUtil.manifestExceptionsIn(task2)));
        return var6_8;
    }

    static PsiFile findFileToHighlight(@NotNull Project project2, @Nullable VirtualFile virtualFile2) {
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(55);
        }
        PsiFile psiFile = virtualFile2 == null ? null : PsiManager.getInstance(project2).findFile(virtualFile2);
        psiFile = psiFile instanceof PsiCompiledFile ? ((PsiCompiledFile)psiFile).getDecompiledPsiFile() : psiFile;
        return psiFile;
    }

    private void submitInBackground(@NotNull List<? extends FileEditorInfo> preferredFileEditorMap, int @NotNull [] passesToIgnore, int modificationCountBefore, @NotNull DaemonProgressIndicator progress) {
        if (preferredFileEditorMap == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(56);
        }
        if (progress == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(57);
        }
        if (passesToIgnore == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(58);
        }
        if (this.myProject.isDisposed()) {
            this.stopProcess(false, "project disposed");
            return;
        }
        if (progress.isCanceled()) {
            this.stopProcess(true, "canceled in queuePassesCreation: " + progress.getCancellationTrace());
            return;
        }
        try {
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                boolean heavyProcessIsRunning = ReadAction.compute(() -> DaemonCodeAnalyzerImpl.heavyProcessIsRunning());
                boolean hasPasses = false;
                for (FileEditorInfo entry : preferredFileEditorMap) {
                    for (FileEditorInfo.FileEditorHighlightingInfo fileEditorHighlightingInfo : entry.myFileEditors) {
                        BackgroundEditorHighlighter highlighter = fileEditorHighlightingInfo.myBackgroundEditorHighlighter;
                        FileEditor fileEditor = fileEditorHighlightingInfo.myFileEditor;
                        HighlightingPass[] passes = ReadAction.compute(() -> {
                            HighlightingPass[] result2;
                            if (this.myProject.isDisposed() || !fileEditor.isValid()) {
                                return HighlightingPass.EMPTY_ARRAY;
                            }
                            if (this.daemonCancelEventCount.get() != modificationCountBefore) {
                                throw new ProcessCanceledException();
                            }
                            HighlightingPass[] highlightingPassArray = result2 = highlighter instanceof TextEditorBackgroundHighlighter ? ((TextEditorBackgroundHighlighter)highlighter).getPasses(passesToIgnore).toArray(HighlightingPass.EMPTY_ARRAY) : highlighter.createPassesForEditor();
                            if (heavyProcessIsRunning) {
                                result2 = ContainerUtil.findAllAsArray(result2, DumbService::isDumbAware);
                            }
                            return result2;
                        });
                        fileEditorHighlightingInfo.myHighlightingPasses = passes;
                        hasPasses |= passes.length != 0;
                    }
                }
                if (!hasPasses) {
                    return;
                }
                TextEditorHighlightingPassRegistrar textEditorHighlightingPassRegistrar = TextEditorHighlightingPassRegistrar.getInstance(this.myProject);
                synchronized (textEditorHighlightingPassRegistrar) {
                    this.myPassExecutorService.submitPasses(preferredFileEditorMap, progress);
                }
            }, progress);
        }
        catch (ProcessCanceledException e) {
            this.stopProcess(true, "PCE in queuePassesCreation");
        }
        catch (Throwable e) {
            PassExecutorService.saveException(e, progress);
            throw e;
        }
    }

    @NotNull
    private List<FileEditorInfo> createPreferredFileEditorMap(@NotNull Collection<? extends FileEditor> fileEditors, @NotNull Map<FileEditor, BackgroundEditorHighlighter> highlighters) {
        if (fileEditors == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(59);
        }
        if (highlighters == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(60);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FileEditorInfo> result2 = new ArrayList<FileEditorInfo>(fileEditors.size());
        MultiMap<Pair, FileEditor> map2 = ContainerUtil.groupBy(fileEditors, fileEditor -> {
            VirtualFile virtualFile2 = fileEditor.getFile();
            if (virtualFile2 == null) {
                return null;
            }
            Document document = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor().getDocument() : FileDocumentManager.getInstance().getDocument(virtualFile2);
            return document == null ? null : Pair.create(document, virtualFile2);
        });
        for (Map.Entry<Pair, Collection<FileEditor>> entry : map2.entrySet()) {
            Document document = (Document)entry.getKey().getFirst();
            VirtualFile virtualFile2 = (VirtualFile)entry.getKey().getSecond();
            List<FileEditorInfo.FileEditorHighlightingInfo> infos = ContainerUtil.mapNotNull(entry.getValue(), fileEditor -> {
                BackgroundEditorHighlighter highlighter = (BackgroundEditorHighlighter)highlighters.get(fileEditor);
                return highlighter == null ? null : new FileEditorInfo.FileEditorHighlightingInfo((FileEditor)fileEditor, highlighter);
            });
            if (infos.isEmpty()) continue;
            this.putPreferredFileEditorFirst(virtualFile2, infos);
            result2.add(new FileEditorInfo(document, virtualFile2, infos));
        }
        ArrayList<FileEditorInfo> arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    private void putPreferredFileEditorFirst(@NotNull VirtualFile virtualFile2, @NotNull List<FileEditorInfo.FileEditorHighlightingInfo> fileEditors) {
        FileEditor selected;
        if (virtualFile2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(62);
        }
        if (fileEditors == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(63);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!fileEditors.isEmpty());
        int focusedIndex = ContainerUtil.indexOf(fileEditors, info -> info.myFileEditor instanceof TextEditor && ((TextEditor)info.myFileEditor).getEditor().getContentComponent().isFocusOwner());
        if (focusedIndex == -1 && (selected = this.myFileEditorManager.getSelectedEditor(virtualFile2)) != null) {
            focusedIndex = ContainerUtil.indexOf(fileEditors, info -> info.myFileEditor.equals(selected));
        }
        if (focusedIndex == -1) {
            focusedIndex = 0;
        }
        Collections.swap(fileEditors, 0, focusedIndex);
    }

    private static boolean heavyProcessIsRunning() {
        if (DumbServiceImpl.ALWAYS_SMART) {
            return false;
        }
        return HeavyProcessLatch.INSTANCE.isRunningAnythingBut(HeavyProcessLatch.Type.Syncing);
    }

    @NotNull
    private synchronized DaemonProgressIndicator createUpdateProgress(@NotNull Collection<? extends FileEditor> fileEditors) {
        DaemonProgressIndicator old;
        if (fileEditors == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(64);
        }
        if (!(old = this.myUpdateProgress).isCanceled()) {
            old.cancel();
        }
        MyDaemonProgressIndicator progress = new MyDaemonProgressIndicator(this.myProject, fileEditors);
        progress.setModalityProgress(null);
        progress.start();
        this.myDaemonListenerPublisher.daemonStarting(fileEditors);
        if (this.isRestartToCompleteEssentialHighlightingRequested()) {
            progress.putUserData(COMPLETE_ESSENTIAL_HIGHLIGHTING_KEY, true);
        }
        this.myUpdateProgress = progress;
        MyDaemonProgressIndicator myDaemonProgressIndicator = progress;
        if (myDaemonProgressIndicator == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(65);
        }
        return myDaemonProgressIndicator;
    }

    @Override
    public void autoImportReferenceAtCursor(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        ReferenceImporter importer;
        if (editor2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(66);
        }
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(67);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        Iterator<ReferenceImporter> iterator = ReferenceImporter.EP_NAME.getExtensionList().iterator();
        while (!(!iterator.hasNext() || (importer = iterator.next()).isAddUnambiguousImportsOnTheFlyEnabled(psiFile) && importer.autoImportReferenceAtCursor(editor2, psiFile))) {
        }
    }

    @TestOnly
    @NotNull
    synchronized DaemonProgressIndicator getUpdateProgress() {
        DaemonProgressIndicator daemonProgressIndicator = this.myUpdateProgress;
        if (daemonProgressIndicator == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(68);
        }
        return daemonProgressIndicator;
    }

    @NotNull
    private Collection<FileEditor> getSelectedEditors() {
        List<FileEditor> activeTextEditors;
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        List<? extends Editor> editors2 = this.myEditorTracker.getActiveEditors();
        if (editors2.isEmpty()) {
            activeTextEditors = Collections.emptyList();
        } else {
            activeTextEditors = new HashSet(editors2.size());
            for (Editor editor2 : editors2) {
                if (editor2.isDisposed()) continue;
                TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor2);
                activeTextEditors.add((FileEditor)textEditor);
            }
        }
        if (application.getCurrentModalityState() != ModalityState.NON_MODAL) {
            List<FileEditor> list2 = activeTextEditors;
            if (list2 == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(69);
            }
            return list2;
        }
        HashSet<FileEditor> result2 = new HashSet<FileEditor>(activeTextEditors.size());
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(activeTextEditors.size());
        if (!application.isUnitTestMode()) {
            for (FileEditor tabEditor : this.myFileEditorManager.getSelectedEditorWithRemotes()) {
                if (!tabEditor.isValid()) continue;
                VirtualFile file2 = tabEditor.getFile();
                if (file2 != null) {
                    hashSet.add(file2);
                }
                result2.add(tabEditor);
            }
        }
        if (!activeTextEditors.isEmpty()) {
            for (FileEditor fileEditor : activeTextEditors) {
                VirtualFile file3 = fileEditor.getFile();
                if (file3 != null && (hashSet.contains(file3) || !file3.isValid())) continue;
                result2.add(fileEditor);
            }
        }
        HashSet<FileEditor> hashSet2 = result2;
        if (hashSet2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(70);
        }
        return hashSet2;
    }

    @ApiStatus.Internal
    public void serializeCodeInsightPasses(boolean flag) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setUpdateByTimerEnabled(false);
        try {
            this.cancelUpdateProgress(false, "serializeCodeInsightPasses");
            TextEditorHighlightingPassRegistrarImpl registrar = (TextEditorHighlightingPassRegistrarImpl)TextEditorHighlightingPassRegistrar.getInstance(this.myProject);
            registrar.serializeCodeInsightPasses(flag);
        }
        finally {
            this.setUpdateByTimerEnabled(true);
        }
    }

    void restartToCompleteEssentialHighlighting() {
        this.restart();
        this.completeEssentialHighlightingRequested = true;
    }

    public boolean isRestartToCompleteEssentialHighlightingRequested() {
        return this.completeEssentialHighlightingRequested;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 68: 
            case 69: 
            case 70: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 68: 
            case 69: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: 
            case 19: 
            case 30: 
            case 37: 
            case 41: 
            case 42: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl";
                break;
            }
            case 5: 
            case 8: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_TAG;
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 33: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 11: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditors";
                break;
            }
            case 21: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesToIgnore";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 28: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 39: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSeverity";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 53: 
            case 59: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditors";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredFileEditorMap";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlights";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileLevelHighlights";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "runMainPasses";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassesToShowProgressFor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatusMap";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMarkers";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreferredFileEditorMap";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateProgress";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateProgress";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHighlights";
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 68: 
            case 69: 
            case 70: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelHighlights";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assertMyFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cleanFileLevelHighlights";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFileLevelHighlight";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runMainPasses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mustWaitForSmartMode";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runPasses";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "disableUpdateByTimer";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setImportHintsEnabled";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightingEnabled";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isHighlightingAvailable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isImportHintsEnabled";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAutohintsAvailable";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "stopProcessAndRestartAllFiles";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPassesToShowProgressFor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isAllAnalysisFinished";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isErrorAnalyzingFinished";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "stopProcess";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "cancelUpdateProgress";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processHighlightsNearOffset";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findHighlightByOffset";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findHighlightsByOffset";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetInsideHighlightInfo";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkers";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "queuePassesCreation";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findFileToHighlight";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "submitInBackground";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createPreferredFileEditorMap";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "putPreferredFileEditorFirst";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateProgress";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "autoImportReferenceAtCursor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 31: 
            case 34: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 68: 
            case 69: 
            case 70: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyDaemonProgressIndicator
    extends DaemonProgressIndicator {
        private final Project myProject;
        private final Collection<? extends FileEditor> myFileEditors;

        MyDaemonProgressIndicator(@NotNull Project project2, @NotNull Collection<? extends FileEditor> fileEditors) {
            if (project2 == null) {
                MyDaemonProgressIndicator.$$$reportNull$$$0(0);
            }
            if (fileEditors == null) {
                MyDaemonProgressIndicator.$$$reportNull$$$0(1);
            }
            this.myFileEditors = ContainerUtil.createConcurrentList(fileEditors);
            this.myProject = project2;
        }

        @Override
        boolean stopIfRunning() {
            boolean wasStopped = super.stopIfRunning();
            if (wasStopped) {
                DaemonCodeAnalyzerImpl daemon = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(this.myProject);
                daemon.myDaemonListenerPublisher.daemonFinished(this.myFileEditors);
                this.myFileEditors.clear();
                HighlightingSessionImpl.clearProgressIndicator(this);
                daemon.completeEssentialHighlightingRequested = false;
            }
            return wasStopped;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileEditors";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$MyDaemonProgressIndicator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class FileEditorInfo {
        final Document myDocument;
        final VirtualFile myVirtualFile;
        final List<? extends FileEditorHighlightingInfo> myFileEditors;

        FileEditorInfo(@NotNull Document document, @NotNull VirtualFile virtualFile2, @NotNull List<? extends FileEditorHighlightingInfo> fileEditorHighlightingInfos) {
            if (document == null) {
                FileEditorInfo.$$$reportNull$$$0(0);
            }
            if (virtualFile2 == null) {
                FileEditorInfo.$$$reportNull$$$0(1);
            }
            if (fileEditorHighlightingInfos == null) {
                FileEditorInfo.$$$reportNull$$$0(2);
            }
            if (fileEditorHighlightingInfos.isEmpty()) {
                throw new IllegalArgumentException("fileEditorHighlightingInfos is empty for " + virtualFile2 + "; " + document);
            }
            this.myDocument = document;
            this.myVirtualFile = virtualFile2;
            this.myFileEditors = fileEditorHighlightingInfos;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileEditorHighlightingInfos";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$FileEditorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class FileEditorHighlightingInfo {
            @NotNull
            final FileEditor myFileEditor;
            @NotNull
            final BackgroundEditorHighlighter myBackgroundEditorHighlighter;
            HighlightingPass[] myHighlightingPasses;

            FileEditorHighlightingInfo(@NotNull FileEditor fileEditor, @NotNull BackgroundEditorHighlighter backgroundEditorHighlighter) {
                if (fileEditor == null) {
                    FileEditorHighlightingInfo.$$$reportNull$$$0(0);
                }
                if (backgroundEditorHighlighter == null) {
                    FileEditorHighlightingInfo.$$$reportNull$$$0(1);
                }
                this.myFileEditor = fileEditor;
                this.myBackgroundEditorHighlighter = backgroundEditorHighlighter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fileEditor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "backgroundEditorHighlighter";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$FileEditorInfo$FileEditorHighlightingInfo";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class UpdateRunnable
    implements Runnable {
        private Project myProject;

        private UpdateRunnable(@NotNull Project project2) {
            if (project2 == null) {
                UpdateRunnable.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DaemonCodeAnalyzerImpl dca;
            block13: {
                block12: {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    Project project2 = this.myProject;
                    if (project2 == null || project2.isDefault() || !project2.isInitialized() || project2.isDisposed() || PowerSaveMode.isEnabled() || LightEdit.owns((Project)project2)) break block12;
                    dca = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2);
                    if (!dca.myDisposed) break block13;
                }
                return;
            }
            DaemonCodeAnalyzerImpl daemonCodeAnalyzerImpl = dca;
            synchronized (daemonCodeAnalyzerImpl) {
                long actualDelay = dca.myScheduledUpdateTimestamp - System.nanoTime();
                if (actualDelay > 0L) {
                    dca.scheduleUpdateRunnable(actualDelay);
                    return;
                }
            }
            Collection<FileEditor> activeEditors = dca.getSelectedEditors();
            boolean updateByTimerEnabled = dca.isUpdateByTimerEnabled();
            if (PassExecutorService.LOG.isDebugEnabled()) {
                PassExecutorService.log(dca.getUpdateProgress(), null, "Update Runnable. myUpdateByTimerEnabled:", updateByTimerEnabled, " something disposed:", PowerSaveMode.isEnabled() || !this.myProject.isInitialized(), " activeEditors:", activeEditors);
            }
            if (!updateByTimerEnabled) {
                return;
            }
            if (activeEditors.isEmpty()) {
                return;
            }
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                return;
            }
            if (dca.myPsiDocumentManager.hasEventSystemEnabledUncommittedDocuments()) {
                dca.myPsiDocumentManager.performLaterWhenAllCommitted(this);
                return;
            }
            dca.queuePassesCreation(activeEditors, ArrayUtil.EMPTY_INT_ARRAY);
        }

        private void clearFieldsOnDispose() {
            this.myProject = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$UpdateRunnable", "<init>"));
        }
    }

    static class HighlightByOffsetProcessor
    implements Processor<HighlightInfo> {
        private final List<HighlightInfo> foundInfoList = new SmartList<HighlightInfo>();
        private final boolean highestPriorityOnly;

        HighlightByOffsetProcessor(boolean highestPriorityOnly) {
            this.highestPriorityOnly = highestPriorityOnly;
        }

        @Override
        public boolean process(@NotNull HighlightInfo info) {
            if (info == null) {
                HighlightByOffsetProcessor.$$$reportNull$$$0(0);
            }
            if (info.getSeverity() == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY || info.type == HighlightInfoType.TODO) {
                return true;
            }
            if (!this.foundInfoList.isEmpty() && this.highestPriorityOnly) {
                HighlightInfo foundInfo = this.foundInfoList.get(0);
                int compare = foundInfo.getSeverity().compareTo(info.getSeverity());
                if (compare < 0) {
                    this.foundInfoList.clear();
                } else if (compare > 0) {
                    return true;
                }
            }
            this.foundInfoList.add(info);
            return true;
        }

        @Nullable
        HighlightInfo getResult() {
            if (this.foundInfoList.isEmpty()) {
                return null;
            }
            if (this.foundInfoList.size() == 1) {
                return this.foundInfoList.get(0);
            }
            this.foundInfoList.sort(Comparator.comparing(HighlightInfo::getSeverity).reversed());
            return HighlightInfoComposite.create(this.foundInfoList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$HighlightByOffsetProcessor", "process"));
        }
    }
}

