/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.impl.CanISilentlyChange;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.GotoNextErrorHandler;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.PsiChangeHandler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DaemonListeners
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DaemonListeners.class);
    private final Project myProject;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private boolean myEscPressed;
    private volatile boolean cutOperationJustHappened;
    private List<Editor> myActiveEditors;
    private static final Key<Boolean> DAEMON_INITIALIZED = Key.create("DAEMON_INITIALIZED");
    private static String CUT_ACTION_NAME;

    public static DaemonListeners getInstance(@NotNull Project project2) {
        if (project2 == null) {
            DaemonListeners.$$$reportNull$$$0(0);
        }
        return project2.getService(DaemonListeners.class);
    }

    public DaemonListeners(final @NotNull Project project2) {
        if (project2 == null) {
            DaemonListeners.$$$reportNull$$$0(1);
        }
        this.myActiveEditors = Collections.emptyList();
        this.myProject = project2;
        this.myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(this.myProject);
        boolean replaced = ((UserDataHolderEx)((Object)this.myProject)).replace(DAEMON_INITIALIZED, null, Boolean.TRUE);
        if (!replaced) {
            LOG.error("Daemon listeners already initialized for the project " + this.myProject);
        }
        MessageBus messageBus = this.myProject.getMessageBus();
        if (project2.isDefault()) {
            return;
        }
        MessageBusConnection connection = messageBus.connect();
        connection.subscribe(AppLifecycleListener.TOPIC, new AppLifecycleListener(){

            public void appClosing() {
                DaemonListeners.this.stopDaemon(false, "App closing");
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        EditorEventMulticasterEx eventMulticaster = (EditorEventMulticasterEx)editorFactory.getEventMulticaster();
        eventMulticaster.addDocumentListener(new DocumentListener(){

            @Override
            public void beforeDocumentChange(@NotNull DocumentEvent e) {
                Project project2;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                Document document = e.getDocument();
                VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
                Project project3 = project2 = virtualFile2 == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile2);
                if (!DaemonListeners.this.myProject.isDisposed() && ApplicationManager.getApplication().isDispatchThread() && DaemonListeners.this.worthBothering(document, project2)) {
                    DaemonListeners.this.stopDaemon(true, "Document change");
                    UpdateHighlightersUtil.updateHighlightersByTyping(DaemonListeners.this.myProject, e);
                }
            }

            @Override
            public void bulkUpdateStarting(@NotNull Document document) {
                if (document == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (DaemonListeners.this.worthBothering(document, DaemonListeners.this.myProject)) {
                    DaemonListeners.this.stopDaemon(false, "Document bulk modifications started");
                }
            }

            @Override
            public void bulkUpdateFinished(@NotNull Document document) {
                if (document == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (DaemonListeners.this.worthBothering(document, DaemonListeners.this.myProject)) {
                    DaemonListeners.this.stopDaemon(true, "Document bulk modifications finished");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeDocumentChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bulkUpdateStarting";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bulkUpdateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DaemonListeners.this.myEscPressed = false;
                Editor editor2 = e.getEditor();
                if (UIUtil.isShowing(editor2.getContentComponent()) && DaemonListeners.this.worthBothering(editor2.getDocument(), editor2.getProject())) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!DaemonListeners.this.myProject.isDisposed() && UIUtil.isShowing(editor2.getContentComponent())) {
                            IntentionsUI.getInstance(DaemonListeners.this.myProject).invalidate();
                        }
                    }, ModalityState.current(), DaemonListeners.this.myProject.getDisposed());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/DaemonListeners$3", "caretPositionChanged"));
            }
        }, (Disposable)this);
        connection.subscribe(EditorTrackerListener.TOPIC, activeEditors -> {
            if (this.myActiveEditors.equals(activeEditors)) {
                return;
            }
            this.myActiveEditors = new ArrayList<Editor>(activeEditors);
            this.stopDaemon(true, "Active editor change");
            if (ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext()) {
                this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(true);
            }
            ErrorStripeUpdateManager errorStripeUpdateManager = ErrorStripeUpdateManager.getInstance(this.myProject);
            for (Editor editor2 : activeEditors) {
                errorStripeUpdateManager.repaintErrorStripePanel(editor2);
            }
        });
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (DaemonListeners.this.myProject.isDisposed()) {
                    return;
                }
                Editor editor2 = event.getEditor();
                Document document = editor2.getDocument();
                Project editorProject = editor2.getProject();
                PsiFile file2 = editorProject == null ? null : PsiDocumentManager.getInstance(editorProject).getPsiFile(document);
                boolean showing = UIUtil.isShowing(editor2.getContentComponent());
                boolean worthBothering = DaemonListeners.this.worthBothering(document, editorProject);
                if (!showing || !worthBothering) {
                    LOG.debug("Not worth bothering about editor created for : " + file2 + " because editor isShowing(): " + showing + "; project is open and file is mine: " + worthBothering);
                    return;
                }
                ErrorStripeUpdateManager.getInstance(DaemonListeners.this.myProject).repaintErrorStripePanel(editor2);
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                DaemonListeners.this.myActiveEditors.remove(event.getEditor());
                if (DaemonListeners.this.myActiveEditors.isEmpty()) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        IntentionsUI intentionUI = DaemonListeners.this.myProject.getServiceIfCreated(IntentionsUI.class);
                        if (intentionUI != null) {
                            intentionUI.invalidate();
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        PsiManager.getInstance(this.myProject).addPsiTreeChangeListener(new PsiChangeHandler(this.myProject, connection, this), this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

            @Override
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Project roots changed");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/DaemonListeners$5", "rootsChanged"));
            }
        });
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (_1, _2, _3, _4) -> this.stopDaemonAndRestartAllFiles("Additional libraries changed"));
        connection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode started");
            }

            @Override
            public void exitDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode finished");
            }
        });
        connection.subscribe(PowerSaveMode.TOPIC, () -> this.stopDaemon(true, "Power save mode change"));
        connection.subscribe(EditorColorsManager.TOPIC, __ -> this.stopDaemonAndRestartAllFiles("Editor color scheme changed"));
        connection.subscribe(CommandListener.TOPIC, new MyCommandListener());
        connection.subscribe(ProfileChangeAdapter.TOPIC, new MyProfileChangeListener());
        ApplicationManager.getApplication().addApplicationListener(new MyApplicationListener(), project2);
        connection.subscribe(TodoConfiguration.PROPERTY_CHANGE, new MyTodoListener());
        connection.subscribe(AnActionListener.TOPIC, new MyAnActionListener());
        connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    7.$$$reportNull$$$0(0);
                }
                boolean isDaemonShouldBeStopped = false;
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
                    VFilePropertyChangeEvent e = (VFilePropertyChangeEvent)vFileEvent;
                    String propertyName = e.getPropertyName();
                    if ("name".equals(propertyName)) {
                        this.fileRenamed(e);
                    }
                    if (isDaemonShouldBeStopped || propertyName.equals("writable")) continue;
                    isDaemonShouldBeStopped = true;
                }
                if (isDaemonShouldBeStopped) {
                    DaemonListeners.this.stopDaemon(true, "Virtual file property change");
                }
            }

            private void fileRenamed(@NotNull VFilePropertyChangeEvent event) {
                PsiFile psiFile;
                if (event == null) {
                    7.$$$reportNull$$$0(1);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Virtual file name changed");
                VirtualFile virtualFile2 = event.getFile();
                PsiFile psiFile2 = psiFile = !virtualFile2.isValid() ? null : PsiManagerEx.getInstanceEx(DaemonListeners.this.myProject).getFileManager().getCachedPsiFile(virtualFile2);
                if (psiFile == null || DaemonListeners.this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile)) {
                    return;
                }
                Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile2);
                if (document == null) {
                    return;
                }
                UpdateHighlightersUtil.setHighlightersToEditor(DaemonListeners.this.myProject, document, 0, document.getTextLength(), Collections.emptyList(), null, 4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "events";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                IntentionsUI.getInstance(project2).invalidate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/DaemonListeners$8", "fileTypesChanged"));
            }
        });
        eventMulticaster.addErrorStripeListener(new ErrorStripeListener(){

            public void errorMarkerClicked(@NotNull ErrorStripeEvent e) {
                RangeHighlighter highlighter;
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (!(highlighter = e.getHighlighter()).isValid()) {
                    return;
                }
                HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
                if (info != null) {
                    GotoNextErrorHandler.navigateToError(DaemonListeners.this.myProject, e.getEditor(), info, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/DaemonListeners$9", "errorMarkerClicked"));
            }
        }, (Disposable)this);
        LaterInvocator.addModalityStateListener(new ModalityStateListener(){

            @Override
            public void beforeModalityStateChanged(boolean entering, @NotNull Object modalEntity) {
                if (modalEntity == null) {
                    10.$$$reportNull$$$0(0);
                }
                boolean inModalContext = Registry.is("ide.perProjectModality") || LaterInvocator.isInModalContext();
                DaemonListeners.this.stopDaemon(inModalContext, "Modality change. Was modal: " + inModalContext);
                DaemonListeners.this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(inModalContext);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalEntity", "com/intellij/codeInsight/daemon/impl/DaemonListeners$10", "beforeModalityStateChanged"));
            }
        }, this);
        connection.subscribe(SeverityRegistrar.SEVERITIES_CHANGED_TOPIC, () -> this.stopDaemonAndRestartAllFiles("Severities changed"));
        connection.subscribe(FacetManager.FACETS_TOPIC, new FacetManagerListener(){

            public void facetRenamed(@NotNull Facet facet, @NotNull String oldName) {
                if (facet == null) {
                    11.$$$reportNull$$$0(0);
                }
                if (oldName == null) {
                    11.$$$reportNull$$$0(1);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet renamed: " + oldName + " -> " + facet.getName());
            }

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    11.$$$reportNull$$$0(2);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet added: " + facet.getName());
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    11.$$$reportNull$$$0(3);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet removed: " + facet.getName());
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    11.$$$reportNull$$$0(4);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet changed: " + facet.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "facet";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRenamed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.restartOnExtensionChange(LanguageAnnotators.EP_NAME, "annotators list changed");
        this.restartOnExtensionChange(LineMarkerProviders.EP_NAME, "line marker providers list changed");
        this.restartOnExtensionChange(ExternalLanguageAnnotators.EP_NAME, "external annotators list changed");
        connection.subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    12.$$$reportNull$$$0(0);
                }
                PsiManager.getInstance(DaemonListeners.this.myProject).dropPsiCaches();
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Plugin installed");
            }

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    12.$$$reportNull$$$0(1);
                }
                PsiManager.getInstance(DaemonListeners.this.myProject).dropPsiCaches();
                DaemonListeners.this.myDaemonCodeAnalyzer.cancelUpdateProgress(false, "plugin unload: " + pluginDescriptor);
                DaemonListeners.this.removeHighlightersOnPluginUnload(pluginDescriptor);
                DaemonListeners.this.myDaemonCodeAnalyzer.clearProgressIndicator();
                DaemonListeners.this.myDaemonCodeAnalyzer.cleanAllFileLevelHighlights();
                IntentionsUI.getInstance(project2).invalidate();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    12.$$$reportNull$$$0(2);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Plugin unloaded");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$12";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileHighlightingSettingListener.SETTING_CHANGE, (root, setting) -> WriteAction.run(() -> {
            PsiFile file2 = root.getContainingFile();
            if (file2 != null) {
                PsiManager.getInstance(this.myProject).dropPsiCaches();
            }
        }));
        HeavyProcessLatch.INSTANCE.addListener(this, __ -> this.stopDaemon(true, "re-scheduled to execute after heavy processing finished"));
    }

    private <T, U extends KeyedLazyInstance<T>> void restartOnExtensionChange(@NotNull ExtensionPointName<U> name2, @NotNull String message2) {
        if (name2 == null) {
            DaemonListeners.$$$reportNull$$$0(2);
        }
        if (message2 == null) {
            DaemonListeners.$$$reportNull$$$0(3);
        }
        name2.addChangeListener(() -> this.stopDaemonAndRestartAllFiles(message2), this);
    }

    private boolean worthBothering(@Nullable Document document, Project project2) {
        if (document == null) {
            return true;
        }
        if (project2 != null && project2 != this.myProject) {
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(this.myProject).getCachedPsiFile(document);
        return psiFile != null && psiFile.isPhysical() && psiFile.getOriginalFile() == psiFile;
    }

    @Override
    public void dispose() {
        this.stopDaemonAndRestartAllFiles("Project closed");
        boolean replaced = ((UserDataHolderEx)((Object)this.myProject)).replace(DAEMON_INITIALIZED, Boolean.TRUE, Boolean.FALSE);
        LOG.assertTrue(replaced, "Daemon listeners already disposed for the project " + this.myProject);
    }

    public static boolean canChangeFileSilently(@NotNull PsiFileSystemItem file2) {
        Project project2;
        DaemonListeners listeners2;
        if (file2 == null) {
            DaemonListeners.$$$reportNull$$$0(4);
        }
        if ((listeners2 = DaemonListeners.getInstance(project2 = file2.getProject())) == null) {
            return true;
        }
        if (listeners2.cutOperationJustHappened) {
            return false;
        }
        return CanISilentlyChange.thisFile(file2);
    }

    private void stopDaemon(boolean toRestartAlarm, @NonNls @NotNull String reason) {
        if (reason == null) {
            DaemonListeners.$$$reportNull$$$0(5);
        }
        this.myDaemonCodeAnalyzer.stopProcess(toRestartAlarm, reason);
    }

    private void stopDaemonAndRestartAllFiles(@NotNull String reason) {
        if (reason == null) {
            DaemonListeners.$$$reportNull$$$0(6);
        }
        this.myDaemonCodeAnalyzer.stopProcessAndRestartAllFiles(reason);
    }

    private void removeHighlightersOnPluginUnload(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            DaemonListeners.$$$reportNull$$$0(7);
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance(this.myProject).getAllEditors()) {
            ClassLoader classLoader;
            if (!(fileEditor instanceof TextEditor)) continue;
            boolean clearAll = false;
            VirtualFile file2 = fileEditor.getFile();
            if (file2 != null && (classLoader = file2.getFileType().getClass().getClassLoader()) instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)((Object)classLoader)).getPluginId().equals(pluginDescriptor.getPluginId())) {
                clearAll = true;
            }
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            if (clearAll) {
                editor2.getMarkupModel().removeAllHighlighters();
            } else {
                DaemonListeners.removeHighlightersOnPluginUnload(editor2.getMarkupModel(), pluginDescriptor);
            }
            MarkupModel documentMarkupModel = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)this.myProject, (boolean)false);
            if (documentMarkupModel == null) continue;
            if (clearAll) {
                documentMarkupModel.removeAllHighlighters();
                continue;
            }
            DaemonListeners.removeHighlightersOnPluginUnload(documentMarkupModel, pluginDescriptor);
        }
    }

    private static void removeHighlightersOnPluginUnload(@NotNull MarkupModel model2, @NotNull PluginDescriptor pluginDescriptor) {
        if (model2 == null) {
            DaemonListeners.$$$reportNull$$$0(8);
        }
        if (pluginDescriptor == null) {
            DaemonListeners.$$$reportNull$$$0(9);
        }
        for (RangeHighlighter highlighter : model2.getAllHighlighters()) {
            if (!(highlighter instanceof RangeHighlighterEx) || !((RangeHighlighterEx)highlighter).isPersistent()) {
                model2.removeHighlighter(highlighter);
                continue;
            }
            ClassLoader pluginClassLoader = pluginDescriptor.getPluginClassLoader();
            if (!(pluginClassLoader instanceof PluginAwareClassLoader) || !DaemonListeners.isHighlighterFromPlugin(highlighter, pluginClassLoader)) continue;
            model2.removeHighlighter(highlighter);
        }
    }

    private static boolean isHighlighterFromPlugin(@NotNull RangeHighlighter highlighter, @NotNull ClassLoader pluginClassLoader) {
        LineMarkerInfo<?> info;
        CustomHighlighterRenderer renderer;
        if (highlighter == null) {
            DaemonListeners.$$$reportNull$$$0(10);
        }
        if (pluginClassLoader == null) {
            DaemonListeners.$$$reportNull$$$0(11);
        }
        if ((renderer = highlighter.getCustomRenderer()) != null && renderer.getClass().getClassLoader() == pluginClassLoader) {
            return true;
        }
        Object errorStripeTooltip = highlighter.getErrorStripeTooltip();
        if (errorStripeTooltip instanceof HighlightInfo && ((HighlightInfo)errorStripeTooltip).quickFixActionMarkers != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> marker : ((HighlightInfo)errorStripeTooltip).quickFixActionMarkers) {
                IntentionAction intentionAction = IntentionActionDelegate.unwrap(((HighlightInfo.IntentionActionDescriptor)marker.first).getAction());
                if (intentionAction.getClass().getClassLoader() != pluginClassLoader && (!(intentionAction instanceof QuickFixWrapper) || ((QuickFixWrapper)intentionAction).getFix().getClass().getClassLoader() != pluginClassLoader)) continue;
                return true;
            }
        }
        return (info = LineMarkersUtil.getLineMarkerInfo(highlighter)) != null && info.getClass().getClassLoader() == pluginClassLoader;
    }

    boolean isEscapeJustPressed() {
        return this.myEscPressed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClassLoader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "restartOnExtensionChange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canChangeFileSilently";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "stopDaemon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "stopDaemonAndRestartAllFiles";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeHighlightersOnPluginUnload";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isHighlighterFromPlugin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyAnActionListener
    implements AnActionListener {
        private AnAction cachedEscapeAction;

        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            if (this.cachedEscapeAction == null) {
                DaemonListeners.this.myEscPressed = "EditorEscape".equals(event.getActionManager().getId(action2));
                if (DaemonListeners.this.myEscPressed) {
                    this.cachedEscapeAction = action2;
                }
            } else {
                DaemonListeners.this.myEscPressed = this.cachedEscapeAction == action2;
            }
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            Editor editor2;
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            if ((editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null && !DaemonListeners.this.worthBothering(editor2.getDocument(), editor2.getProject())) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Editor typing");
        }

        public void beforeShortcutTriggered(@NotNull Shortcut shortcut, @NotNull List<AnAction> actions2, @NotNull DataContext dataContext) {
            if (shortcut == null) {
                MyAnActionListener.$$$reportNull$$$0(3);
            }
            if (actions2 == null) {
                MyAnActionListener.$$$reportNull$$$0(4);
            }
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(5);
            }
            DaemonListeners.this.stopDaemon(true, "Shortcut triggered");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortcut";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeShortcutTriggered";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyProfileChangeListener
    implements ProfileChangeAdapter {
        private MyProfileChangeListener() {
        }

        @Override
        public void profileChanged(@NotNull InspectionProfile profile) {
            if (profile == null) {
                MyProfileChangeListener.$$$reportNull$$$0(0);
            }
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile changed");
        }

        @Override
        public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile activated");
        }

        @Override
        public void profilesInitialized() {
            AppUIUtil.invokeLaterIfProjectAlive((Project)DaemonListeners.this.myProject, () -> DaemonListeners.this.stopDaemonAndRestartAllFiles("Inspection profiles activated"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyProfileChangeListener", "profileChanged"));
        }
    }

    private final class MyTodoListener
    implements PropertyChangeListener {
        private MyTodoListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            if (evt == null) {
                MyTodoListener.$$$reportNull$$$0(0);
            }
            if ("todoPatterns".equals(evt.getPropertyName())) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Todo patterns changed");
            } else if ("multiLine".equals(evt.getPropertyName())) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Todo multi-line detection changed");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyTodoListener", "propertyChange"));
        }
    }

    private final class MyCommandListener
    implements CommandListener {
        private MyCommandListener() {
        }

        @Override
        public void commandStarted(@NotNull CommandEvent event) {
            ActionManager actionManager;
            Document affectedDocument;
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(0);
            }
            if (!DaemonListeners.this.worthBothering(affectedDocument = this.extractDocumentFromCommand(event), event.getProject())) {
                return;
            }
            String commandName2 = event.getCommandName();
            String cutActionName = CUT_ACTION_NAME;
            if (cutActionName == null && (actionManager = ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class)) != null) {
                CUT_ACTION_NAME = cutActionName = actionManager.getAction("EditorCut").getTemplatePresentation().getText();
            }
            boolean bl = DaemonListeners.this.cutOperationJustHappened = commandName2 != null && !commandName2.isEmpty() && !commandName2.startsWith("Editor") && commandName2.equals(cutActionName);
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelling code highlighting by command: " + event.getCommand());
            }
            DaemonListeners.this.stopDaemon(false, "Command start");
        }

        private Document extractDocumentFromCommand(@NotNull CommandEvent event) {
            Document affectedDocument;
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(1);
            }
            if ((affectedDocument = event.getDocument()) != null) {
                return affectedDocument;
            }
            Object id2 = event.getCommandGroupId();
            if (id2 instanceof Document) {
                affectedDocument = (Document)id2;
            } else if (id2 instanceof DocCommandGroupId) {
                affectedDocument = ((DocCommandGroupId)id2).getDocument();
            }
            return affectedDocument;
        }

        @Override
        public void commandFinished(@NotNull CommandEvent event) {
            Document affectedDocument;
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(2);
            }
            if (!DaemonListeners.this.worthBothering(affectedDocument = this.extractDocumentFromCommand(event), event.getProject())) {
                return;
            }
            if (DaemonListeners.this.myEscPressed) {
                if (affectedDocument != null && !DaemonListeners.this.myDaemonCodeAnalyzer.getFileStatusMap().allDirtyScopesAreNull(affectedDocument)) {
                    DaemonListeners.this.stopDaemon(true, "Command finish");
                }
            } else if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                DaemonListeners.this.stopDaemon(true, "Command finish");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyCommandListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractDocumentFromCommand";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyApplicationListener
    implements ApplicationListener {
        private MyApplicationListener() {
        }

        @Override
        public void beforeWriteActionStart(@NotNull Object action2) {
            if (action2 == null) {
                MyApplicationListener.$$$reportNull$$$0(0);
            }
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Write action start");
        }

        @Override
        public void writeActionFinished(@NotNull Object action2) {
            if (action2 == null) {
                MyApplicationListener.$$$reportNull$$$0(1);
            }
            DaemonListeners.this.stopDaemon(true, "Write action finish");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "action";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyApplicationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeWriteActionStart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeActionFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

