/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipRenderer;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipWithActionRenderer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonTooltipRendererProvider
implements ErrorStripTooltipRendererProvider {
    private final Project myProject;
    private final Editor myEditor;

    DaemonTooltipRendererProvider(Project project2, Editor editor2) {
        this.myProject = project2;
        this.myEditor = editor2;
    }

    public TooltipRenderer calcTooltipRenderer(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        if (highlighters == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(0);
        }
        DaemonTooltipRenderer bigRenderer = null;
        SmartList<HighlightInfo> infos = new SmartList<HighlightInfo>();
        HashSet<String> tooltips = new HashSet<String>();
        for (RangeHighlighter rangeHighlighter : highlighters) {
            Object tooltipObject = rangeHighlighter.getErrorStripeTooltip();
            if (tooltipObject == null) continue;
            if (tooltipObject instanceof HighlightInfo) {
                HighlightInfo info = (HighlightInfo)tooltipObject;
                if (info.getToolTip() == null || !tooltips.add(info.getToolTip())) continue;
                infos.add(info);
                continue;
            }
            @NlsContexts.Tooltip String text2 = tooltipObject.toString();
            if (!tooltips.add(text2)) continue;
            if (bigRenderer == null) {
                bigRenderer = new DaemonTooltipRenderer(text2, new Object[]{highlighters});
                continue;
            }
            bigRenderer.addBelow(text2);
        }
        if (!infos.isEmpty()) {
            Object[] objectArray;
            ContainerUtil.quickSort(infos, (o1, o2) -> {
                int i = SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(o2.getSeverity(), o1.getSeverity());
                if (i != 0) {
                    return i;
                }
                return o1.getToolTip().compareTo(o2.getToolTip());
            });
            HighlightInfoComposite composite2 = HighlightInfoComposite.create(infos);
            String string2 = composite2.getToolTip();
            TooltipAction action2 = TooltipActionProvider.calcTooltipAction(composite2, this.myEditor);
            if (action2 == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = string2;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = string2;
                objectArray = objectArray3;
                objectArray3[1] = action2;
            }
            DaemonTooltipWithActionRenderer myRenderer2 = new DaemonTooltipWithActionRenderer(string2, action2, 0, objectArray);
            if (bigRenderer != null) {
                myRenderer2.addBelow(bigRenderer.getText());
            }
            bigRenderer = myRenderer2;
        }
        return bigRenderer;
    }

    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(1);
        }
        return new DaemonTooltipRenderer(text2, new Object[]{text2});
    }

    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, int width) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(2);
        }
        return new DaemonTooltipRenderer(text2, width, new Object[]{text2});
    }

    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, @Nullable TooltipAction action2, int width) {
        Object[] objectArray;
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = text2;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = text2;
            objectArray = objectArray3;
            objectArray3[1] = action2;
        }
        return new DaemonTooltipWithActionRenderer(text2, action2, width, objectArray);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "highlighters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider";
        objectArray[2] = "calcTooltipRenderer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

