/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPassFactory;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightInfoProcessor
extends HighlightInfoProcessor {
    private final Alarm repaintIconAlarm = new Alarm();

    @Override
    public void highlightsInsideVisiblePartAreProduced(@NotNull HighlightingSession session, @Nullable Editor editor2, @NotNull List<? extends HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictRange, int groupId) {
        PsiFile psiFile;
        Project project2;
        Document document;
        if (session == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(2);
        }
        if (restrictRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(3);
        }
        if ((document = PsiDocumentManager.getInstance(project2 = (psiFile = session.getPsiFile()).getProject()).getDocument(psiFile)) == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        TextRange priorityIntersection = priorityRange.intersection(restrictRange);
        ArrayList<? extends HighlightInfo> infoCopy = new ArrayList<HighlightInfo>(infos);
        ((HighlightingSessionImpl)session).applyInEDT(() -> {
            if (modificationStamp != document.getModificationStamp()) {
                return;
            }
            if (priorityIntersection != null) {
                MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
                EditorColorsScheme scheme = session.getColorsScheme();
                UpdateHighlightersUtil.setHighlightersInRange(project2, psiFile, document, priorityIntersection, scheme, infoCopy, (MarkupModelEx)markupModel, groupId);
            }
            if (editor2 != null && !editor2.isDisposed()) {
                if (!DumbService.isDumb(project2)) {
                    ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                        ShowAutoImportPassFactory siFactory = TextEditorHighlightingPassRegistrarImpl.EP_NAME.findExtensionOrFail(ShowAutoImportPassFactory.class);
                        TextEditorHighlightingPass highlightingPass = siFactory.createHighlightingPass(psiFile, editor2);
                        if (highlightingPass != null) {
                            highlightingPass.doApplyInformationToEditor();
                        }
                    }, session.getProgressIndicator());
                }
                DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(editor2, project2);
            }
        });
    }

    static void repaintErrorStripeAndIcon(@NotNull Editor editor2, @NotNull Project project2) {
        MarkupModel markup;
        if (editor2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(5);
        }
        if ((markup = editor2.getMarkupModel()) instanceof EditorMarkupModelImpl) {
            ((EditorMarkupModelImpl)markup).repaintTrafficLightIcon();
        }
        ErrorStripeUpdateManager.getInstance(project2).repaintErrorStripePanel(editor2);
    }

    @Override
    public void highlightsOutsideVisiblePartAreProduced(@NotNull HighlightingSession session, @Nullable Editor editor2, @NotNull List<? extends HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        PsiFile psiFile;
        Project project2;
        Document document;
        if (session == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(6);
        }
        if (infos == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(7);
        }
        if (priorityRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(8);
        }
        if (restrictedRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(9);
        }
        if ((document = PsiDocumentManager.getInstance(project2 = (psiFile = session.getPsiFile()).getProject()).getDocument(psiFile)) == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        ((HighlightingSessionImpl)session).applyInEDT(() -> {
            if (project2.isDisposed() || modificationStamp != document.getModificationStamp()) {
                return;
            }
            EditorColorsScheme scheme = session.getColorsScheme();
            UpdateHighlightersUtil.setHighlightersOutsideRange(project2, document, psiFile, infos, scheme, restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), ProperTextRange.create(priorityRange), groupId);
            if (editor2 != null) {
                DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(editor2, project2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void allHighlightsForRangeAreProduced(@NotNull HighlightingSession session, long elementRange, @Nullable List<? extends HighlightInfo> list2) {
        void infos;
        if (session == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(10);
        }
        DefaultHighlightInfoProcessor.killAbandonedHighlightsUnder(session.getProject(), session.getDocument(), elementRange, (List<? extends HighlightInfo>)infos, session);
    }

    /*
     * WARNING - void declaration
     */
    private static void killAbandonedHighlightsUnder(@NotNull Project project2, @NotNull Document document, long range, @Nullable List<? extends HighlightInfo> infos, @NotNull HighlightingSession highlightingSession) {
        void highlightingSession2;
        if (project2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(11);
        }
        if (document == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(12);
        }
        if (highlightingSession == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(13);
        }
        DaemonCodeAnalyzerEx.processHighlights(document, project2, null, TextRange.startOffset(range), TextRange.endOffset(range), arg_0 -> DefaultHighlightInfoProcessor.lambda$killAbandonedHighlightsUnder$3(range, infos, (HighlightingSession)highlightingSession2, arg_0));
    }

    @Override
    public void infoIsAvailable(@NotNull HighlightingSession session, @NotNull HighlightInfo info, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        if (session == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(14);
        }
        if (info == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(15);
        }
        if (priorityRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(16);
        }
        if (restrictedRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(17);
        }
        ((HighlightingSessionImpl)session).queueHighlightInfo(info, restrictedRange, groupId);
    }

    @Override
    public void progressIsAdvanced(@NotNull HighlightingSession highlightingSession, @Nullable Editor editor2, double progress) {
        if (highlightingSession == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(18);
        }
        PsiFile file2 = highlightingSession.getPsiFile();
        this.repaintTrafficIcon(file2, editor2, progress);
    }

    private void repaintTrafficIcon(@NotNull PsiFile file2, @Nullable Editor editor2, double progress) {
        if (file2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(19);
        }
        if (ApplicationManager.getApplication().isCommandLine()) {
            return;
        }
        if (this.repaintIconAlarm.isEmpty() || progress >= 1.0) {
            this.repaintIconAlarm.addRequest(() -> {
                Project myProject = file2.getProject();
                if (myProject.isDisposed()) {
                    return;
                }
                Editor myeditor = editor2;
                if (myeditor == null) {
                    myeditor = PsiEditorUtil.findEditor((PsiElement)file2);
                }
                if (myeditor != null && !myeditor.isDisposed()) {
                    DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(myeditor, myProject);
                }
            }, 50, null);
        }
    }

    private static /* synthetic */ boolean lambda$killAbandonedHighlightsUnder$3(long range, List infos, HighlightingSession highlightingSession, HighlightInfo existing) {
        if (existing.getGroup() == 4 && range == existing.getVisitingTextRange()) {
            RangeHighlighterEx highlighter;
            if (infos != null) {
                for (HighlightInfo created : infos) {
                    if (!existing.equalsByActualOffset(created)) continue;
                    return true;
                }
            }
            if ((highlighter = existing.highlighter) != null && UpdateHighlightersUtil.shouldRemoveHighlighter(highlightingSession.getPsiFile(), (RangeHighlighter)highlighter)) {
                ((HighlightingSessionImpl)highlightingSession).queueDisposeHighlighter(existing);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictedRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSession";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightsInsideVisiblePartAreProduced";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "repaintErrorStripeAndIcon";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightsOutsideVisiblePartAreProduced";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "allHighlightsForRangeAreProduced";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "killAbandonedHighlightsUnder";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "infoIsAvailable";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "progressIsAdvanced";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "repaintTrafficIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

