/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.highlighting.CodeBlockSupportHandler;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesKt;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.highlighting.UsageRanges;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.Symbol;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class IdentifierHighlighterPass {
    private static final Logger LOG = Logger.getInstance(IdentifierHighlighterPass.class);
    private final PsiFile myFile;
    private final Editor myEditor;
    private final Collection<TextRange> myReadAccessRanges;
    private final Collection<TextRange> myWriteAccessRanges;
    private final Collection<TextRange> myCodeBlockMarkerRanges;
    private final int myCaretOffset;
    private final ProperTextRange myVisibleRange;
    private static int id;

    IdentifierHighlighterPass(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull TextRange visibleRange) {
        if (file2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(1);
        }
        if (visibleRange == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(2);
        }
        this.myReadAccessRanges = Collections.synchronizedList(new ArrayList());
        this.myWriteAccessRanges = Collections.synchronizedList(new ArrayList());
        this.myCodeBlockMarkerRanges = Collections.synchronizedList(new ArrayList());
        this.myFile = file2;
        this.myEditor = editor2;
        this.myCaretOffset = this.myEditor.getCaretModel().getOffset();
        this.myVisibleRange = new ProperTextRange(visibleRange);
    }

    public void doCollectInformation() {
        HighlightUsagesHandlerBase highlightUsagesHandler = HighlightUsagesHandler.createCustomHandler(this.myEditor, this.myFile, this.myVisibleRange);
        if (highlightUsagesHandler != null) {
            List targets2 = highlightUsagesHandler.getTargets();
            highlightUsagesHandler.computeUsages(targets2);
            List<TextRange> readUsages = highlightUsagesHandler.getReadUsages();
            for (TextRange readUsage : readUsages) {
                LOG.assertTrue(readUsage != null, "null text range from " + highlightUsagesHandler);
            }
            this.myReadAccessRanges.addAll(readUsages);
            List<TextRange> writeUsages = highlightUsagesHandler.getWriteUsages();
            for (TextRange writeUsage : writeUsages) {
                LOG.assertTrue(writeUsage != null, "null text range from " + highlightUsagesHandler);
            }
            this.myWriteAccessRanges.addAll(writeUsages);
            if (!highlightUsagesHandler.highlightReferences()) {
                return;
            }
        }
        this.collectCodeBlockMarkerRanges();
        this.highlightReferencesAndDeclarations();
    }

    @ApiStatus.Internal
    public Collection<TextRange> getReadAccessRange() {
        return this.myReadAccessRanges;
    }

    @ApiStatus.Internal
    public Collection<TextRange> getWriteAccessRange() {
        return this.myWriteAccessRanges;
    }

    @ApiStatus.Internal
    public Collection<TextRange> getCodeBlockMarkerRanges() {
        return this.myCodeBlockMarkerRanges;
    }

    private void collectCodeBlockMarkerRanges() {
        PsiElement contextElement = this.myFile.findElementAt(TargetElementUtil.adjustOffset(this.myFile, this.myEditor.getDocument(), this.myEditor.getCaretModel().getOffset()));
        this.myCodeBlockMarkerRanges.addAll(CodeBlockSupportHandler.findMarkersRanges(contextElement));
    }

    public static void getHighlightUsages(@NotNull PsiElement target2, @NotNull PsiElement psiElement, boolean withDeclarations, @NotNull Collection<? super TextRange> readRanges, @NotNull Collection<? super TextRange> writeRanges) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(3);
        }
        if (psiElement == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(4);
        }
        if (readRanges == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(5);
        }
        if (writeRanges == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(6);
        }
        IdentifierHighlighterPass.getUsages(target2, psiElement, withDeclarations, true, readRanges, writeRanges);
    }

    @NotNull
    public static Collection<TextRange> getUsages(@NotNull PsiElement target2, PsiElement psiElement, boolean withDeclarations) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(7);
        }
        ArrayList<TextRange> ranges2 = new ArrayList<TextRange>();
        IdentifierHighlighterPass.getUsages(target2, psiElement, withDeclarations, false, ranges2, ranges2);
        ArrayList<TextRange> arrayList = ranges2;
        if (arrayList == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void getUsages(@NotNull PsiElement target2, @NotNull PsiElement scopeElement, boolean withDeclarations, boolean detectAccess, @NotNull Collection<? super TextRange> readRanges, @NotNull Collection<? super TextRange> writeRanges) {
        TextRange declRange;
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(9);
        }
        if (scopeElement == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(10);
        }
        if (readRanges == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(11);
        }
        if (writeRanges == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(12);
        }
        ReadWriteAccessDetector detector = detectAccess ? ReadWriteAccessDetector.findDetector(target2) : null;
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)target2.getProject())).getFindUsagesManager();
        FindUsagesHandler findUsagesHandler = findUsagesManager.getFindUsagesHandler(target2, true);
        LocalSearchScope scope = new LocalSearchScope(scopeElement);
        Collection<Object> refs = findUsagesHandler == null ? ReferencesSearch.search((PsiElement)target2, (SearchScope)scope).findAll() : findUsagesHandler.findReferencesToHighlight(target2, scope);
        for (PsiReference psiReference : refs) {
            if (psiReference == null) {
                LOG.error("Null reference returned, findUsagesHandler=" + findUsagesHandler + "; target=" + target2 + " of " + target2.getClass());
                continue;
            }
            Collection<? super TextRange> destination = detector == null || detector.getReferenceAccess(target2, psiReference) == ReadWriteAccessDetector.Access.Read ? readRanges : writeRanges;
            HighlightUsagesHandler.collectHighlightRanges(psiReference, destination);
        }
        if (withDeclarations && (declRange = HighlightUsagesHandler.getNameIdentifierRange(scopeElement.getContainingFile(), target2)) != null) {
            if (detector != null && detector.isDeclarationWriteAccess(target2)) {
                writeRanges.add(declRange);
            } else {
                readRanges.add(declRange);
            }
        }
    }

    private void highlightReferencesAndDeclarations() {
        Collection<Symbol> targetSymbols = this.getTargetSymbols();
        for (Symbol symbol : targetSymbols) {
            this.highlightTargetUsages(symbol);
        }
    }

    @NotNull
    private @NotNull Collection<@NotNull Symbol> getTargetSymbols() {
        block6: {
            Collection<Symbol> collection;
            try {
                Collection<Symbol> fromHostFile = TargetsKt.targetSymbols(this.myFile, this.myCaretOffset);
                if (fromHostFile.isEmpty()) break block6;
                collection = fromHostFile;
            }
            catch (IndexNotReadyException fromHostFile) {
                // empty catch block
            }
            if (collection == null) {
                IdentifierHighlighterPass.$$$reportNull$$$0(13);
            }
            return collection;
        }
        Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile, this.myCaretOffset);
        PsiFile injectedFile = PsiDocumentManager.getInstance(this.myFile.getProject()).getPsiFile(injectedEditor.getDocument());
        if (injectedFile == null) {
            List<Symbol> list2 = Collections.emptyList();
            if (list2 == null) {
                IdentifierHighlighterPass.$$$reportNull$$$0(14);
            }
            return list2;
        }
        int injectedOffset = injectedEditor.getCaretModel().getOffset();
        Collection<Symbol> collection = TargetsKt.targetSymbols(injectedFile, injectedOffset);
        if (collection == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(15);
        }
        return collection;
    }

    private void highlightTargetUsages(@NotNull Symbol target2) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(16);
        }
        AstLoadingFilter.disallowTreeLoading(() -> {
            UsageRanges ranges2 = HighlightUsagesKt.getUsageRanges(this.myFile, target2);
            if (ranges2 == null) {
                return;
            }
            this.myReadAccessRanges.addAll(ranges2.getReadRanges());
            this.myReadAccessRanges.addAll(ranges2.getReadDeclarationRanges());
            this.myWriteAccessRanges.addAll(ranges2.getWriteRanges());
            this.myWriteAccessRanges.addAll(ranges2.getWriteDeclarationRanges());
        }, () -> "Currently highlighted file: \npsi file: " + this.myFile + ";\nvirtual file: " + this.myFile.getVirtualFile());
    }

    private int getId() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int id2 = id;
        if (id2 == 0) {
            id = id2 = ((TextEditorHighlightingPassRegistrarImpl)TextEditorHighlightingPassRegistrar.getInstance(this.myFile.getProject())).getNextAvailableId().incrementAndGet();
        }
        return id2;
    }

    public void doApplyInformationToEditor() {
        boolean virtSpace = EditorUtil.isCaretInVirtualSpace((Editor)this.myEditor);
        List infos = virtSpace || this.isCaretOverCollapsedFoldRegion() ? Collections.emptyList() : this.getHighlights();
        PsiFile hostFile = InjectedLanguageManager.getInstance(this.myFile.getProject()).getTopLevelFile(this.myFile);
        Editor hostEditor = InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor);
        UpdateHighlightersUtil.setHighlightersToSingleEditor(this.myFile.getProject(), hostEditor, 0, hostFile.getTextLength(), infos, hostEditor.getColorsScheme(), this.getId());
        this.doAdditionalCodeBlockHighlighting();
    }

    private boolean isCaretOverCollapsedFoldRegion() {
        return this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(this.myEditor.getCaretModel().getOffset()) != null;
    }

    private void doAdditionalCodeBlockHighlighting() {
        if (this.myCodeBlockMarkerRanges.size() < 2 || !(this.myEditor instanceof EditorEx)) {
            return;
        }
        ArrayList<TextRange> markers = new ArrayList<TextRange>(this.myCodeBlockMarkerRanges);
        markers.sort(Segment.BY_START_OFFSET_THEN_END_OFFSET);
        TextRange leftBraceRange = (TextRange)markers.get(0);
        TextRange rightBraceRange = (TextRange)markers.get(markers.size() - 1);
        int startLine = this.myEditor.offsetToLogicalPosition((int)leftBraceRange.getStartOffset()).line;
        int endLine = this.myEditor.offsetToLogicalPosition((int)rightBraceRange.getEndOffset()).line;
        if (endLine - startLine > 0) {
            BraceHighlightingHandler.lineMarkFragment((EditorEx)this.myEditor, this.myEditor.getDocument(), startLine, endLine, true);
        }
        BraceHighlightingHandler.showScopeHint(this.myEditor, this.myFile, leftBraceRange.getStartOffset(), leftBraceRange.getEndOffset());
    }

    @NotNull
    private List<HighlightInfo> getHighlights() {
        if (this.myReadAccessRanges.isEmpty() && this.myWriteAccessRanges.isEmpty() && this.myCodeBlockMarkerRanges.isEmpty()) {
            List<HighlightInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                IdentifierHighlighterPass.$$$reportNull$$$0(17);
            }
            return list2;
        }
        HashSet<Pair<Object, TextRange>> existingMarkupTooltips = new HashSet<Pair<Object, TextRange>>();
        for (RangeHighlighter highlighter : this.myEditor.getMarkupModel().getAllHighlighters()) {
            existingMarkupTooltips.add(Pair.create(highlighter.getErrorStripeTooltip(), new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset())));
        }
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>(this.myReadAccessRanges.size() + this.myWriteAccessRanges.size() + this.myCodeBlockMarkerRanges.size());
        for (TextRange range : this.myReadAccessRanges) {
            ContainerUtil.addIfNotNull(result2, this.createHighlightInfo(range, HighlightInfoType.ELEMENT_UNDER_CARET_READ, existingMarkupTooltips));
        }
        for (TextRange range : this.myWriteAccessRanges) {
            ContainerUtil.addIfNotNull(result2, this.createHighlightInfo(range, HighlightInfoType.ELEMENT_UNDER_CARET_WRITE, existingMarkupTooltips));
        }
        if (CodeInsightSettings.getInstance().HIGHLIGHT_BRACES) {
            this.myCodeBlockMarkerRanges.forEach(it -> ContainerUtil.addIfNotNull(result2, this.createHighlightInfo((TextRange)it, HighlightInfoType.ELEMENT_UNDER_CARET_STRUCTURAL, (Set<Pair<Object, TextRange>>)existingMarkupTooltips)));
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private HighlightInfo createHighlightInfo(@NotNull TextRange range, @NotNull HighlightInfoType type, @NotNull Set<Pair<Object, TextRange>> existingMarkupTooltips) {
        int start2;
        if (range == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(19);
        }
        if (type == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(20);
        }
        if (existingMarkupTooltips == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(21);
        }
        String tooltip = (start2 = range.getStartOffset()) <= this.myEditor.getDocument().getTextLength() ? HighlightHandlerBase.getLineTextErrorStripeTooltip(this.myEditor.getDocument(), start2, false) : null;
        String unescapedTooltip = existingMarkupTooltips.contains(new Pair<String, TextRange>(tooltip, range)) ? null : tooltip;
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(type).range(range);
        if (unescapedTooltip != null) {
            builder2.unescapedToolTip(unescapedTooltip);
        }
        HighlightInfo highlightInfo = builder2.createUnconditionally();
        if (highlightInfo == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(22);
        }
        return highlightInfo;
    }

    public static void clearMyHighlights(@NotNull Document document, @NotNull Project project2) {
        if (document == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(23);
        }
        if (project2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(24);
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
            if (info == null || info.type != HighlightInfoType.ELEMENT_UNDER_CARET_READ && info.type != HighlightInfoType.ELEMENT_UNDER_CARET_WRITE) continue;
            highlighter.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readRanges";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeRanges";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingMarkupTooltips";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSymbols";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlights";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightUsages";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "highlightTargetUsages";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightInfo";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clearMyHighlights";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

